/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.logger;

import com.jacky.cici.logger.AbstractLogger;
import com.jacky.cici.logger.LogFileComparator;
import com.jacky.cici.logger.LogFileFilter;
import com.jacky.cici.logger.LogValue;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;

public class RollingFileLogger
extends AbstractLogger {
    protected String path = null;
    protected int size = 0;
    protected String[] files = null;
    protected String filename = null;
    protected int count = 0;

    RollingFileLogger(String path, String filename, int fileSize, int count, boolean isScreen) {
        int n = count <= 2 ? 10 : (count = count > 999 ? 999 : count);
        fileSize = fileSize <= 0 ? 10 : (fileSize > 10 ? 10 : fileSize);
        this.path = path;
        this.files = new String[count];
        this.filename = filename;
        this.screen = isScreen;
        this.count = count;
        this.size = fileSize;
        try {
            System.out.println("fist create os...");
            this.createPrintWriter();
            System.out.println("fist create os=" + this.os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createPrintWriter() throws Exception {
        int cnt = 0;
        File tfile = new File(this.path);
        File[] tfiles = tfile.listFiles(new LogFileFilter(this.filename));
        Arrays.sort(tfiles, new LogFileComparator());
        cnt = tfiles.length;
        int len = "999".length();
        int i = 0;
        while (i < cnt) {
            this.files[i] = tfiles[i].getName();
            ++i;
        }
        if (cnt == 0) {
            String fix = "000000" + (cnt + 1);
            fix = fix.substring(fix.length() - len);
            String filename1 = String.valueOf(this.filename) + fix + ".log";
            this.file = new File(String.valueOf(this.path) + File.separator + filename1);
            this.files[cnt] = filename1;
        } else if (cnt < this.count) {
            String fix = "000000" + (cnt + 1);
            fix = fix.substring(fix.length() - len);
            String filename1 = String.valueOf(this.filename) + fix + ".log";
            this.file = new File(String.valueOf(this.path) + File.separator + filename1);
            this.files[cnt] = filename1;
        } else {
            i = 0;
            while (i < cnt - 1) {
                File f = new File(String.valueOf(this.path) + File.separator + this.files[i]);
                if (i == 0) {
                    f.delete();
                } else {
                    f.renameTo(new File(String.valueOf(this.path) + File.separator + this.files[i - 1]));
                }
                ++i;
            }
        }
        this.osSem.acquire();
        if (this.os != null) {
            this.os.close();
        }
        if (cnt == this.count) {
            new File(String.valueOf(this.path) + File.separator + this.files[cnt - 1]).renameTo(new File(String.valueOf(this.path) + File.separator + this.files[cnt - 2]));
            this.file = new File(String.valueOf(this.path) + File.separator + this.files[cnt - 1]);
        }
        this.os = new FileWriter(this.file, true);
        this.osSem.release();
        this.writesize = 0L;
    }

    @Override
    public void log(LogValue lv) {
        if (this.writesize >= (long)(this.size * 1024 * 1024) || this.os == null) {
            try {
                this.createPrintWriter();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.log(lv);
    }
}

