/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.junique;

import it.sauronsoftware.junique.AlreadyLockedException;
import it.sauronsoftware.junique.Lock;
import it.sauronsoftware.junique.Message;
import it.sauronsoftware.junique.MessageHandler;
import it.sauronsoftware.junique.Server;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Hashtable;

public class JUnique {
    private static final File LOCK_FILES_DIR = new File(System.getProperty("user.home"), ".junique");
    private static final File GLOBAL_LOCK_FILE = new File(LOCK_FILES_DIR, "global.lock");
    private static FileChannel globalFileChannel = null;
    private static FileLock globalFileLock = null;
    private static Hashtable locks = new Hashtable();

    public static void acquireLock(String string) throws AlreadyLockedException {
        JUnique.acquireLock(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void acquireLock(String string, MessageHandler messageHandler) throws AlreadyLockedException {
        String string2 = JUnique.normalizeID(string);
        JUnique.j_lock();
        try {
            FileLock fileLock;
            FileChannel fileChannel;
            Object object;
            File file = JUnique.getLockFileForNID(string2);
            File file2 = JUnique.getPortFileForNID(string2);
            LOCK_FILES_DIR.mkdirs();
            try {
                object = new RandomAccessFile(file, "rw");
                fileChannel = ((RandomAccessFile)object).getChannel();
                fileLock = fileChannel.tryLock();
                if (fileLock == null) {
                    throw new AlreadyLockedException(string);
                }
            }
            catch (Throwable throwable) {
                throw new AlreadyLockedException(string);
            }
            Server server = new Server(string, messageHandler);
            object = new Lock(string, file, file2, fileChannel, fileLock, server);
            locks.put(string2, object);
            server.start();
            FileWriter fileWriter = null;
            fileWriter = new FileWriter(file2);
            fileWriter.write(String.valueOf(server.getListenedPort()));
            ((Writer)fileWriter).flush();
            Object var12_11 = null;
            if (fileWriter == null) return;
            try {
                ((Writer)fileWriter).close();
                return;
            }
            catch (Throwable throwable) {}
            return;
            {
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (fileWriter == null) return;
                    try {
                        ((Writer)fileWriter).close();
                        return;
                    }
                    catch (Throwable throwable2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (fileWriter == null) throw throwable;
                try {
                    ((Writer)fileWriter).close();
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        finally {
            JUnique.j_unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseLock(String string) {
        String string2 = JUnique.normalizeID(string);
        JUnique.j_lock();
        try {
            Lock lock = (Lock)locks.remove(string2);
            if (lock != null) {
                JUnique.releaseLock(lock);
            }
        }
        finally {
            JUnique.j_unlock();
        }
    }

    private static void releaseLock(Lock lock) {
        lock.getServer().stop();
        try {
            lock.getLockFileLock().release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            lock.getLockFileChannel().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        lock.getPortFile().delete();
        lock.getLockFile().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String sendMessage(String var0, String var1_1) {
        block45: {
            block40: {
                var2_2 = -1;
                JUnique.j_lock();
                try {
                    var3_3 = JUnique.normalizeID(var0);
                    var4_4 = JUnique.getPortFileForNID(var3_3);
                    var5_5 = null;
                    try {
                        block39: {
                            var5_5 = new BufferedReader(new FileReader((File)var4_4));
                            var6_6 = var5_5.readLine();
                            if (var6_6 == null) break block39;
                            var2_2 = Integer.parseInt((String)var6_6);
                        }
                        var8_8 = null;
                        ** if (var5_5 == null) goto lbl-1000
                    }
                    catch (Throwable var7_14) {
                        var8_10 = null;
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (Throwable var9_13) {
                                // empty catch block
                            }
                        }
                        throw var7_14;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var5_5.close();
                        }
                        catch (Throwable var9_11) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block40;
                        catch (Throwable var6_7) {
                            var8_9 = null;
                            if (var5_5 != null) {
                                try {
                                    var5_5.close();
                                }
                                catch (Throwable var9_12) {}
                            }
                        }
                    }
                }
                finally {
                    JUnique.j_unlock();
                }
            }
            var3_3 = null;
            if (var2_2 > 0) {
                block41: {
                    var4_4 = null;
                    var5_5 = null;
                    var6_6 = null;
                    var4_4 = new Socket("localhost", var2_2);
                    var5_5 = var4_4.getInputStream();
                    var6_6 = var4_4.getOutputStream();
                    Message.write(var1_1, (OutputStream)var6_6);
                    var3_3 = Message.read((InputStream)var5_5);
                    var12_17 = null;
                    if (var6_6 == null) break block41;
                    try {
                        var6_6.close();
                    }
                    catch (Throwable var13_20) {
                        // empty catch block
                    }
                }
                if (var5_5 != null) {
                    try {
                        var5_5.close();
                    }
                    catch (Throwable var13_20) {
                        // empty catch block
                    }
                }
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (Throwable var13_20) {}
                }
                break block45;
                {
                    catch (Throwable var7_15) {
                        var7_15.printStackTrace();
                        var12_18 = null;
                        if (var6_6 != null) {
                            try {
                                var6_6.close();
                            }
                            catch (Throwable var13_21) {
                                // empty catch block
                            }
                        }
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (Throwable var13_21) {
                                // empty catch block
                            }
                        }
                        if (var4_4 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (Throwable var13_21) {}
                        }
                    }
                }
                catch (Throwable var11_23) {
                    var12_19 = null;
                    if (var6_6 != null) {
                        try {
                            var6_6.close();
                        }
                        catch (Throwable var13_22) {
                            // empty catch block
                        }
                    }
                    if (var5_5 != null) {
                        try {
                            var5_5.close();
                        }
                        catch (Throwable var13_22) {
                            // empty catch block
                        }
                    }
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (Throwable var13_22) {
                            // empty catch block
                        }
                    }
                    throw var11_23;
                }
            }
        }
        return var3_3;
    }

    private static String normalizeID(String string) {
        int n = string.hashCode();
        boolean bl = n >= 0;
        long l = bl ? (long)n : -((long)n);
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l));
        while (stringBuffer.length() < 8) {
            stringBuffer.insert(0, '0');
        }
        if (bl) {
            stringBuffer.insert(0, '0');
        } else {
            stringBuffer.insert(0, '1');
        }
        return stringBuffer.toString();
    }

    private static File getLockFileForNID(String string) {
        String string2 = JUnique.normalizeID(string) + ".lock";
        return new File(LOCK_FILES_DIR, string2);
    }

    private static File getPortFileForNID(String string) {
        String string2 = JUnique.normalizeID(string) + ".port";
        return new File(LOCK_FILES_DIR, string2);
    }

    private static void j_lock() {
        while (true) {
            LOCK_FILES_DIR.mkdirs();
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(GLOBAL_LOCK_FILE, "rw");
                FileChannel fileChannel = randomAccessFile.getChannel();
                FileLock fileLock = fileChannel.lock();
                globalFileChannel = fileChannel;
                globalFileLock = fileLock;
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private static void j_unlock() {
        FileChannel fileChannel = globalFileChannel;
        FileLock fileLock = globalFileLock;
        globalFileChannel = null;
        globalFileLock = null;
        try {
            fileLock.release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fileChannel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        if (!LOCK_FILES_DIR.exists()) {
            LOCK_FILES_DIR.mkdirs();
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(new ShutdownHook()));
    }

    private static class ShutdownHook
    implements Runnable {
        private ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            JUnique.j_lock();
            try {
                String string;
                ArrayList<String> arrayList = new ArrayList<String>();
                Object object = locks.keys();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    arrayList.add(string);
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    Lock lock = (Lock)locks.remove(string);
                    JUnique.releaseLock(lock);
                }
            }
            finally {
                JUnique.j_unlock();
            }
        }
    }
}

