/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.junique;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Message {
    Message() {
    }

    public static String read(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        if (inputStream.read(byArray) != 4) {
            throw new IOException("Unexpected end of stream");
        }
        int n = Message.byteArrayToInt(byArray);
        if (n < 0) {
            throw new IOException("Invalid length block");
        }
        if (n == 0) {
            return "";
        }
        byte[] byArray2 = new byte[n];
        if (inputStream.read(byArray2) != n) {
            throw new IOException("Unexpected end of stream");
        }
        return new String(byArray2, "UTF-8");
    }

    public static void write(String string, OutputStream outputStream) throws IOException {
        if (string == null) {
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(0);
            outputStream.flush();
        } else {
            int n = string.length();
            byte[] byArray = Message.intToByteArray(n);
            outputStream.write(byArray);
            outputStream.flush();
            byte[] byArray2 = string.getBytes("UTF-8");
            outputStream.write(byArray2);
            outputStream.flush();
        }
    }

    private static byte[] intToByteArray(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n2 = (3 - i) * 8;
            byArray[i] = (byte)(n >> n2 & 0xFF);
        }
        return byArray;
    }

    private static int byteArrayToInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = (3 - i) * 8;
            n += (byArray[i] & 0xFF) << n2;
        }
        return n;
    }
}

