/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.security;

import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAUtil {
    private static ILogger log = MyLogger.getDateLogger((String)"logger/FileAndDirectoryUtil", (String)"FileAndDirectoryUtil", (int)5, (boolean)true);

    public Key getPriviteKey() {
        try {
            FileInputStream keyfis = new FileInputStream("privatekey.store");
            byte[] encKey = new byte[keyfis.available()];
            keyfis.read(encKey);
            keyfis.close();
            PKCS8EncodedKeySpec pubKeySpec = new PKCS8EncodedKeySpec(encKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey pubKey = keyFactory.generatePrivate(pubKeySpec);
            return pubKey;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void savePriviteKey(PrivateKey pri) {
        try {
            byte[] key = pri.getEncoded();
            FileOutputStream keyfos = new FileOutputStream("privatekey.store");
            keyfos.write(key);
            keyfos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Key getPublicKey() {
        try {
            FileInputStream keyfis = new FileInputStream("publickey.store");
            byte[] encKey = new byte[keyfis.available()];
            keyfis.read(encKey);
            keyfis.close();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            return pubKey;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void savePublicKey(PublicKey pub) {
        try {
            byte[] key = pub.getEncoded();
            FileOutputStream keyfos = new FileOutputStream("publickey.store");
            keyfos.write(key);
            keyfos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] decodeBykey(byte[] content, Key pri) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        byte[] encrypted;
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, pri);
        int i = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (i + 512 < content.length) {
            encrypted = cipher.doFinal(content, i, 512);
            baos.write(encrypted);
            i += 512;
        }
        encrypted = cipher.doFinal(content, i, content.length - i);
        baos.write(encrypted);
        return baos.toByteArray();
    }

    public byte[] encodeBykey(byte[] content, Key pub) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        byte[] encrypted;
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pub);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i + 501 < content.length) {
            encrypted = cipher.doFinal(content, i, 501);
            baos.write(encrypted);
            log.logInfo((Object)("" + encrypted.length));
            i += 501;
        }
        encrypted = cipher.doFinal(content, i, content.length - i);
        baos.write(encrypted);
        log.logInfo((Object)("" + encrypted.length));
        return baos.toByteArray();
    }

    public void genkey() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(4096, new SecureRandom());
            KeyPair pair = generator.generateKeyPair();
            PrivateKey pri = pair.getPrivate();
            PublicKey pub = pair.getPublic();
            log.logInfo((Object)pub.getFormat());
            log.logInfo((Object)pri.getFormat());
            this.savePriviteKey(pri);
            this.savePublicKey(pub);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void test() throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, IOException {
        this.genkey();
    }

    public static void main(String[] agr) {
        try {
            new RSAUtil().test();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

