/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.updater;

import ch.fhnw.filecopier.CopyJob;
import ch.fhnw.filecopier.FileCopier;
import ch.fhnw.filecopier.Source;
import com.jacky.cici.exception.NoDirectoryException;
import com.jacky.cici.exception.NoEmptyInDirectoryException;
import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import com.jacky.cici.updater.UpdaterServiceFtpImpl;
import com.jacky.cici.util.ConfigFileUtil;
import com.jacky.cici.util.FileAndDirectoryUtil;
import com.jacky.cici.util.WapperConfUtil;
import com.jacky.cici.vo.SoftConf;
import com.jacky.cici.vo.WapperConf;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;

public class UpdateMain {
    private static ILogger log = MyLogger.getDateLogger((String)"logger/UpdateMain", (String)"UpdateMain", (int)5, (boolean)true);
    private static int count = 1;

    public void startUpdater() throws IOException {
        new Thread(){

            @Override
            public void run() {
                boolean flag = false;
                try {
                    UpdateMain.this.processUpdate();
                    flag = true;
                }
                catch (InvalidPropertiesFormatException e) {
                    e.printStackTrace();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (!flag) {
                    try {
                        Thread.sleep(count * 30 * 60 * 1000);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    try {
                        UpdateMain.this.startUpdater();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void processUpdate() throws IOException, InvalidPropertiesFormatException, FileNotFoundException {
        UpdaterServiceFtpImpl us;
        SoftConf sc = null;
        sc = new ConfigFileUtil<SoftConf>().readConfigFile("conf" + File.separator + "sofconf.xml", sc);
        log.logInfo((Object)"get currversion ok --------------------------------------");
        File file = new File("update");
        if (!file.exists()) {
            file.mkdir();
        }
        if ((us = new UpdaterServiceFtpImpl()).compareVersion(sc.getCurrVersion()) != 0) {
            log.logInfo((Object)"get update info ok --------------------------------------");
            if (us.downloadUpdateFiles("update")) {
                File[] oldFiles;
                log.logInfo((Object)"downloda update file ok -----------------------------");
                int[] ver = us.getVersion();
                String verStr = "";
                int[] nArray = ver;
                int n = ver.length;
                int n2 = 0;
                while (n2 < n) {
                    int b = nArray[n2];
                    verStr = String.valueOf(verStr) + "_" + b;
                    ++n2;
                }
                log.logInfo((Object)("new version[" + verStr + "] ------------------------------"));
                verStr = "lib" + verStr;
                log.logInfo((Object)"create new lib dir -----------------------------------");
                WapperConf w = new WapperConfUtil().readWapperConf(new File("conf" + File.separator + "wapperConf.xml"));
                File jarfilepathdest = new File(verStr);
                jarfilepathdest.mkdir();
                Source[] sources = new Source[]{new Source(w.getJarPath(), ".*\\.jar"), new Source(w.getJarPath(), ".*\\.dll")};
                String[] destinations = new String[]{verStr};
                CopyJob copyJob = new CopyJob(sources, destinations);
                FileCopier fc = new FileCopier();
                fc.copy(new CopyJob[]{copyJob});
                log.logInfo((Object)"move jar to new lib dir ---------------------------------");
                sources = new Source[]{new Source("update", ".*\\.jar")};
                copyJob = new CopyJob(sources, destinations);
                fc.copy(new CopyJob[]{copyJob});
                log.logInfo((Object)"copy update jar to new lib dir ---------------------------------");
                final String newLib = verStr;
                File oldFile = new File(".");
                File[] fileArray = oldFiles = oldFile.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("lib") && !name.toLowerCase().equalsIgnoreCase(newLib);
                    }
                });
                int n3 = oldFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File ff = fileArray[n4];
                    try {
                        FileAndDirectoryUtil.deleteDirectory(ff, true);
                    }
                    catch (NoDirectoryException e) {
                        e.printStackTrace();
                    }
                    catch (NoEmptyInDirectoryException e) {
                        e.printStackTrace();
                    }
                    ++n4;
                }
                log.logInfo((Object)"delete old lib dir ---------------------------------");
                w.setJarPath(verStr);
                new WapperConfUtil().writeWapperConf(w, new File("conf" + File.separator + "wapperConf.xml"));
                sc.setOldVersion(sc.getCurrVersion());
                sc.setCurrVersion(ver);
                sc.setUpdateVersion(ver);
                new ConfigFileUtil<SoftConf>().saveConfigFile(sc, "conf" + File.separator + "sofconf.xml");
                log.logInfo((Object)"update soft version info---------------------------------");
            }
        } else {
            log.logInfo((Object)"no find new version!");
        }
    }

    public static void main(String[] args) {
        SoftConf sc = new SoftConf();
        sc.setCurrVersion(new int[3]);
        sc.setEmail("66@66.com");
        try {
            new ConfigFileUtil<SoftConf>().saveConfigFile(sc, "conf" + File.separator + "SoftConf.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

