/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.updater;

import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import com.jacky.cici.updater.FtpConfig;
import com.jacky.cici.updater.IUpdaterService;
import com.jacky.cici.util.ConfigFileUtil;
import com.jacky.cici.vo.UpdateConfig;
import it.sauronsoftware.ftp4j.FTPAbortedException;
import it.sauronsoftware.ftp4j.FTPClient;
import it.sauronsoftware.ftp4j.FTPDataTransferException;
import it.sauronsoftware.ftp4j.FTPException;
import it.sauronsoftware.ftp4j.FTPIllegalReplyException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class UpdaterServiceFtpImpl
implements IUpdaterService {
    private static ILogger log = MyLogger.getDateLogger((String)"logger/UpdaterServiceFtpImpl", (String)"UpdaterServiceFtpImpl", (int)5, (boolean)true);
    private FtpConfig ftpConfig = null;
    private UpdateConfig updateConfig = null;

    public UpdaterServiceFtpImpl(FtpConfig ftpConfig) {
        this.ftpConfig = ftpConfig;
    }

    public UpdaterServiceFtpImpl() {
        this.readFtpConfig();
        this.ftpConfig.setFtpHost("FTP.drivehq.com");
        this.ftpConfig.setUpdateDir("update");
        this.ftpConfig.setUser("auto123");
        this.ftpConfig.setPassword("auto123");
    }

    private void readFtpConfig() {
        try {
            this.ftpConfig = new ConfigFileUtil<FtpConfig>().readConfigFile("conf" + File.separator + "ftpConfig.xml", this.ftpConfig);
            log.logInfo((Object)("" + this.ftpConfig));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int[] getVersion() {
        if (this.updateConfig != null) {
            return this.updateConfig.getVersion();
        }
        if (this.ftpConfig != null) {
            this.readUpdateInfo();
            if (this.updateConfig != null) {
                return this.updateConfig.getVersion();
            }
        }
        return new int[3];
    }

    private void readUpdateInfo() {
        try {
            FTPClient fc = new FTPClient();
            fc.connect(this.ftpConfig.getFtpHost(), Integer.valueOf(this.ftpConfig.getFtpPort()).intValue());
            fc.login(this.ftpConfig.getUser(), this.ftpConfig.getPassword());
            fc.changeDirectory(this.ftpConfig.getUpdateDir());
            File updateFile = new File("update" + File.separator + "update.xml");
            fc.download("update.xml", updateFile);
            fc.disconnect(true);
            this.updateConfig = new ConfigFileUtil<UpdateConfig>().readConfigFile(updateFile, this.updateConfig);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FTPIllegalReplyException e) {
            e.printStackTrace();
        }
        catch (FTPException e) {
            e.printStackTrace();
        }
        catch (FTPDataTransferException e) {
            e.printStackTrace();
        }
        catch (FTPAbortedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean downloadUpdateFiles(String path) {
        if (this.ftpConfig != null) {
            if (this.updateConfig == null) {
                this.readUpdateInfo();
            }
            if (this.updateConfig != null) {
                try {
                    FTPClient fc = new FTPClient();
                    fc.connect(this.ftpConfig.getFtpHost(), Integer.valueOf(this.ftpConfig.getFtpPort()).intValue());
                    fc.login(this.ftpConfig.getUser(), this.ftpConfig.getPassword());
                    fc.changeDirectory(this.ftpConfig.getUpdateDir());
                    for (String file : this.updateConfig.getUpdateFiles()) {
                        fc.download(file, new File(String.valueOf(path) + File.separator + file));
                    }
                    fc.disconnect(true);
                    return true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (FTPIllegalReplyException e) {
                    e.printStackTrace();
                }
                catch (FTPException e) {
                    e.printStackTrace();
                }
                catch (FTPDataTransferException e) {
                    e.printStackTrace();
                }
                catch (FTPAbortedException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static void main(String[] arg) {
        try {
            UpdateConfig uc = new UpdateConfig();
            int[] nArray = new int[3];
            nArray[0] = 2;
            uc.setVersion(nArray);
            ArrayList<String> jars = new ArrayList<String>();
            jars.add("1.jar");
            jars.add("2.jar");
            uc.setUpdateFiles(jars);
            new ConfigFileUtil<UpdateConfig>().saveConfigFile(uc, "conf" + File.separator + "updateConfig.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    @Override
    public int compareVersion(int[] version) {
        if (this.ftpConfig != null) {
            this.readUpdateInfo();
            if (this.updateConfig != null) {
                if (version.length != this.updateConfig.getVersion().length) {
                    return 0;
                }
                int i = 0;
                while (i < version.length) {
                    if (this.updateConfig.getVersion()[i] != version[i]) {
                        return this.updateConfig.getVersion()[i] - version[i];
                    }
                    ++i;
                }
            }
        }
        return 0;
    }
}

