/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.util;

import com.jacky.cici.exception.FileNoExistException;
import com.jacky.cici.exception.NoDirectoryException;
import com.jacky.cici.exception.NoEmptyInDirectoryException;
import com.jacky.cici.exception.NoFileException;
import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;

public class FileAndDirectoryUtil {
    private static ILogger log = MyLogger.getDateLogger((String)"logger/FileAndDirectoryUtil", (String)"FileAndDirectoryUtil", (int)5, (boolean)true);

    public static boolean deleteFile(File f) throws NoFileException, FileNoExistException {
        if (!f.exists()) {
            throw new FileNoExistException();
        }
        if (f.isFile()) {
            return f.delete();
        }
        throw new NoFileException();
    }

    public static void deleteDirectory(File f, boolean rescure) throws NoDirectoryException, NoEmptyInDirectoryException {
        log.logInfo((Object)("delete directory :" + f.getAbsolutePath()));
        if (f.isFile()) {
            throw new NoDirectoryException();
        }
        File[] files = f.listFiles();
        ArrayList<File> fl = new ArrayList<File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f1 = fileArray[n2];
            if (f1.isFile()) {
                log.logInfo((Object)("delete file :" + f1.getAbsolutePath()));
                f1.delete();
            } else {
                fl.add(f1);
            }
            ++n2;
        }
        if (fl.size() > 0 && !rescure) {
            throw new NoEmptyInDirectoryException();
        }
        FileAndDirectoryUtil.deleteDirectoryFoce(f);
        f.delete();
    }

    private static void deleteDirectoryFoce(File f) {
        File[] files;
        File[] fileArray = files = f.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f1 = fileArray[n2];
            if (f1.isFile()) {
                f1.delete();
            } else {
                FileAndDirectoryUtil.deleteDirectoryFoce(f1);
            }
            ++n2;
        }
        f.delete();
    }

    public static boolean moveFile(File f1, File f2) throws FileNoExistException, NoFileException {
        if (!f1.exists()) {
            throw new FileNoExistException();
        }
        if (!f1.isFile()) {
            throw new NoFileException();
        }
        boolean flag = false;
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            try {
                in = new FileInputStream(f1).getChannel();
                out = new FileInputStream(f2).getChannel();
                in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
                f1.delete();
                flag = true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                block31: {
                    e.printStackTrace();
                    if (out == null) break block31;
                    try {
                        out.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public static boolean moveDirectory(File f1, File f2) throws NoDirectoryException, IOException, FileNoExistException, NoFileException {
        File[] files;
        if (f1.isFile()) {
            throw new NoDirectoryException();
        }
        if (f1.isFile()) {
            throw new NoDirectoryException();
        }
        File[] fileArray = files = f1.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File nf;
            File f = fileArray[n2];
            if (f.isFile()) {
                nf = new File(String.valueOf(f2.getAbsolutePath()) + File.separator + f.getName());
                nf.createNewFile();
                FileAndDirectoryUtil.copyFile(f, nf);
            } else if (f.isDirectory()) {
                nf = new File(String.valueOf(f2.getAbsolutePath()) + File.separator + f.getName());
                nf.mkdir();
                FileAndDirectoryUtil.moveDirectory(f, nf);
            }
            ++n2;
        }
        f1.delete();
        return false;
    }

    public static boolean copyFile(File f1, File f2) throws FileNoExistException, NoFileException {
        if (!f1.exists()) {
            throw new FileNoExistException();
        }
        if (!f1.isFile()) {
            throw new NoFileException();
        }
        boolean flag = false;
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            try {
                in = new FileInputStream(f1).getChannel();
                out = new FileInputStream(f2).getChannel();
                in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
                flag = true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                block31: {
                    e.printStackTrace();
                    if (out == null) break block31;
                    try {
                        out.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public static boolean copyDirectory(File f1, File f2, boolean rescure) throws NoDirectoryException, IOException, FileNoExistException, NoFileException {
        File[] files;
        if (f1.isFile()) {
            throw new NoDirectoryException();
        }
        if (f1.isFile()) {
            throw new NoDirectoryException();
        }
        File[] fileArray = files = f1.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File nf;
            File f = fileArray[n2];
            if (f.isFile()) {
                nf = new File(String.valueOf(f2.getAbsolutePath()) + File.separator + f.getName());
                nf.createNewFile();
                FileAndDirectoryUtil.copyFile(f, nf);
            } else if (f.isDirectory()) {
                nf = new File(String.valueOf(f2.getAbsolutePath()) + File.separator + f.getName());
                nf.mkdir();
                FileAndDirectoryUtil.copyDirectory(f, nf, rescure);
            }
            ++n2;
        }
        return false;
    }
}

