/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.autoWiFi.service;

import com.jacky.cici.autoWiFi.vo.WiFiConf;
import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import com.jacky.cici.util.DebugUtil;
import com.xzdl.util.win.CommandService;
import java.util.ArrayList;
import java.util.List;

public class WiFiService {
    private static ILogger log = MyLogger.getDateLogger((String)"logger/WiFiService", (String)"WiFiService", (int)5, (boolean)DebugUtil.isLog2Screen);

    public List<String> scanWiFiAP() {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("netsh wlan show networks");
        List<Object> result = new ArrayList();
        try {
            result = CommandService.synExcuteCommand(commands);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        log.logInfo((Object)("excute in cmd [" + (String)commands.get(0) + "]"));
        for (String string : result) {
            String[] l;
            if (!(string.contains("SSID") | string.contains("SSID".toLowerCase())) || (l = string.split(":|\uff1a")).length != 2) continue;
            ret.add(l[1].trim());
        }
        return ret;
    }

    public WiFiConf scanNetInterfaceConfig(String netInterface, WiFiConf ret) {
        ret = ret != null ? ret : new WiFiConf();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("netsh interface ipv4 show addresses \"" + netInterface + "\"");
        List<Object> result = new ArrayList();
        try {
            result = CommandService.synExcuteCommand(commands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] ss = null;
        for (String string : result) {
            String string2 = string.toLowerCase();
            if (string2.contains("dhcp") && (ss = string2.split(":|\uff1a")).length > 1 && ss[1].trim().contains("\u662f") | ss[1].trim().contains("y")) break;
            if (string2.contains("ip address") | string2.contains("ip \u5730\u5740") && (ss = string2.split(":|\uff1a")).length > 1) {
                ret.setIp(ss[1].trim());
            }
            if ((string2.contains("\u63a9\u7801") || string2.contains("mask")) && (ss = string2.split(":|\uff1a|\\(|\\)|\uff08|\uff09")).length > 2) {
                ss = ss[2].trim().split(" ");
                ret.setMask(ss[1].trim());
            }
            if (!string2.contains("\u9ed8\u8ba4\u7f51\u5173") && !string2.contains("gw") && !string2.contains("gateway") || (ss = string2.split(":|\uff1a")).length <= 1) continue;
            ret.setGateway(ss[1].trim());
        }
        return ret;
    }

    public List<WiFiConf> scanNetInterface() {
        ArrayList<WiFiConf> ret = new ArrayList<WiFiConf>();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("netsh wlan show interfaces");
        List<Object> result = new ArrayList();
        try {
            result = CommandService.synExcuteCommand(commands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.logInfo((Object)("excute in cmd [" + (String)commands.get(0) + "]"));
        WiFiConf wc = null;
        for (String string : result) {
            String[] l;
            String string2 = string.toLowerCase();
            if (string2.contains("\u540d\u79f0") | string2.contains("name")) {
                l = string2.split(":|\uff1a");
                wc = new WiFiConf();
                if (l.length == 2) {
                    wc.setNetName(l[1].trim());
                } else {
                    wc.setNetName("");
                }
            }
            if (wc == null || !(string2.contains("\u72b6\u6001") | string2.contains("status"))) continue;
            l = string2.split(":|\uff1a");
            if (l.length == 2) {
                if (l[1].contains("\u5df2\u65ad\u5f00\u8fde\u63a5") | l[1].contains("disconnect")) {
                    wc.setUsed(false);
                } else {
                    wc.setUsed(true);
                }
            } else {
                wc.setUsed(false);
            }
            ret.add(wc);
            wc = null;
        }
        return ret;
    }

    private void configStaticIP(WiFiConf wfc) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("netsh interface ipv4 set address \"" + wfc.getNetName() + "\" static " + wfc.getIp() + " " + wfc.getMask() + " " + wfc.getGateway() + " 1");
        try {
            CommandService.synExcuteCommand(commands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.logInfo((Object)("excute in cmd [" + (String)commands.get(0) + "]"));
    }

    private void configDhcpIP(WiFiConf wfc) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("netsh interface ipv4 set address name=\"" + wfc.getNetName() + "\" source=dhcp");
        try {
            CommandService.synExcuteCommand(commands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.logInfo((Object)("excute in cmd [" + (String)commands.get(0) + "]"));
    }

    private void configStaticDNS(WiFiConf wfc) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("netsh interface ipv4 set dns name=\"" + wfc.getNetName() + "\" source=static addr=" + wfc.getDns1() + " register=PRIMARY");
        try {
            CommandService.synExcuteCommand(commands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.logInfo((Object)("excute in cmd [" + (String)commands.get(0) + "]"));
        commands = new ArrayList();
        commands.add("netsh interface ipv4 set dns name=\"" + wfc.getNetName() + "\" source=static addr=" + wfc.getDns2() + " register=PRIMARY");
        try {
            CommandService.synExcuteCommand(commands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.logInfo((Object)("excute in cmd [" + (String)commands.get(0) + "]"));
    }

    private void configDhcpDns(WiFiConf wfc) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("netsh interface ipv4 set dns name=\"" + wfc.getNetName() + "\" source=dhcp");
        try {
            CommandService.synExcuteCommand(commands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.logInfo((Object)("excute in cmd [" + (String)commands.get(0) + "]"));
    }

    public boolean setWiFiNetWork(WiFiConf wfc) {
        if (wfc.getIp().length() > 0) {
            this.configStaticIP(wfc);
            this.configStaticDNS(wfc);
        } else if (wfc.getDns1().length() > 0) {
            this.configDhcpIP(wfc);
            this.configStaticDNS(wfc);
        } else {
            this.configDhcpIP(wfc);
            this.configDhcpDns(wfc);
        }
        return true;
    }

    public boolean connect(WiFiConf wfc) {
        boolean ret = true;
        try {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("netsh wlan connect name=\"" + wfc.getSsid() + "\" ssid=" + wfc.getSsid());
            CommandService.synExcuteCommand(commands);
            log.logInfo((Object)("excute in cmd [" + (String)commands.get(0) + "]"));
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        WiFiService wc = new WiFiService();
        List<String> ret = wc.scanWiFiAP();
        for (String s : ret) {
            System.out.println(s);
        }
    }
}

