/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.autoWiFi.ui;

import com.jacky.cici.autoWiFi.service.WiFiService;
import com.jacky.cici.autoWiFi.vo.WiFiConf;
import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import com.jacky.cici.util.ConfigFileUtil;
import com.jacky.cici.util.DebugUtil;
import com.jacky.cici.util.TxtUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AddEditDialog
extends JDialog {
    private static ILogger log = MyLogger.getDateLogger((String)"logger/AddEditDialog", (String)"AddEditDialog", (int)5, (boolean)DebugUtil.isLog2Screen);
    private static final long serialVersionUID = 1L;
    private WiFiConf wiFiConf = null;
    private boolean isEdit = false;
    private JLabel Jssid = new JLabel(TxtUtil.getMessageByKey("ssid.name"));
    private JLabel Jnet = new JLabel(TxtUtil.getMessageByKey("wifi.name"));
    private JRadioButton confIpByHandRadio = new JRadioButton(TxtUtil.getMessageByKey("ip.radio1"));
    private JRadioButton confIpByDhcpRadio = new JRadioButton(TxtUtil.getMessageByKey("ip.radio2"));
    private ButtonGroup JIpGroup = new ButtonGroup();
    private JRadioButton confDnsByHandRadio = new JRadioButton(TxtUtil.getMessageByKey("net.radio1"));
    private JRadioButton confDnsByDhcpRadio = new JRadioButton(TxtUtil.getMessageByKey("net.radio2"));
    private ButtonGroup JNetGroup = new ButtonGroup();
    private JLabel JIp = new JLabel(TxtUtil.getMessageByKey("ip.address"));
    private JLabel JMask = new JLabel(TxtUtil.getMessageByKey("ip.mask"));
    private JLabel JGate = new JLabel(TxtUtil.getMessageByKey("ip.gate"));
    private JLabel JDns1 = new JLabel(TxtUtil.getMessageByKey("dns1"));
    private JLabel JDns2 = new JLabel(TxtUtil.getMessageByKey("dns2"));
    private JComboBox JsidCom = new JComboBox();
    private JComboBox JnetCom = new JComboBox();
    private JTextField JipTxt = new JTextField("");
    private JTextField JmaskTxt = new JTextField("");
    private JTextField JgateTxt = new JTextField("");
    private JTextField Jdns1Txt = new JTextField("");
    private JTextField Jdns2Txt = new JTextField("");
    private JButton ack = new JButton(TxtUtil.getMessageByKey("add.ack"));
    private JButton canl = new JButton(TxtUtil.getMessageByKey("add.canl"));

    public WiFiConf getWiFiConf() {
        return this.wiFiConf;
    }

    public void setWiFiConf(WiFiConf wiFiConf, boolean isEdit) {
        this.wiFiConf = wiFiConf;
        this.isEdit = isEdit;
        if (wiFiConf != null) {
            this.setTitle(TxtUtil.getMessageByKey("edit.name"));
        }
        this.updateAddEditDialog();
    }

    public AddEditDialog(Frame parent, WiFiConf wf, boolean isEdit) {
        super(parent);
        this.wiFiConf = wf;
        this.isEdit = isEdit;
        this.initComponents();
        this.updateAddEditDialog();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setSize(270, 310);
        this.setTitle(TxtUtil.getMessageByKey("add.name"));
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setModal(true);
        FormLayout layout = new FormLayout("center:40dlu,center:20dlu,center:40dlu,center:20dlu", "center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu");
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.Jssid, cc.xywh(1, 1, 1, 1));
        this.add((Component)this.JsidCom, cc.xywh(2, 1, 3, 1));
        this.add((Component)this.Jnet, cc.xywh(1, 2, 1, 1));
        this.add((Component)this.JnetCom, cc.xywh(2, 2, 3, 1));
        this.add((Component)this.confIpByHandRadio, cc.xywh(1, 3, 2, 1));
        this.add((Component)this.confIpByDhcpRadio, cc.xywh(3, 3, 2, 1));
        this.add((Component)this.JIp, cc.xywh(1, 4, 1, 1));
        this.add((Component)this.JipTxt, cc.xywh(2, 4, 3, 1));
        this.add((Component)this.JMask, cc.xywh(1, 5, 1, 1));
        this.add((Component)this.JmaskTxt, cc.xywh(2, 5, 3, 1));
        this.add((Component)this.JGate, cc.xywh(1, 6, 1, 1));
        this.add((Component)this.JgateTxt, cc.xywh(2, 6, 3, 1));
        this.add((Component)this.confDnsByHandRadio, cc.xywh(1, 7, 2, 1));
        this.add((Component)this.confDnsByDhcpRadio, cc.xywh(3, 7, 2, 1));
        this.add((Component)this.JDns1, cc.xywh(1, 8, 1, 1));
        this.add((Component)this.Jdns1Txt, cc.xywh(2, 8, 3, 1));
        this.add((Component)this.JDns2, cc.xywh(1, 9, 1, 1));
        this.add((Component)this.Jdns2Txt, cc.xywh(2, 9, 3, 1));
        this.add((Component)this.ack, cc.xywh(1, 10, 1, 1));
        this.add((Component)this.canl, cc.xywh(3, 10, 1, 1));
        this.pack();
        this.JIpGroup.add(this.confIpByHandRadio);
        this.JIpGroup.add(this.confIpByDhcpRadio);
        this.confIpByHandRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JRadioButton source = (JRadioButton)e.getSource();
                AddEditDialog.this.JipTxt.setEnabled(source.isSelected());
                AddEditDialog.this.JmaskTxt.setEnabled(source.isSelected());
                AddEditDialog.this.JgateTxt.setEnabled(source.isSelected());
                if (source.isSelected()) {
                    AddEditDialog.this.confDnsByHandRadio.setSelected(true);
                    AddEditDialog.this.confDnsByDhcpRadio.setEnabled(false);
                } else {
                    AddEditDialog.this.confDnsByDhcpRadio.setEnabled(true);
                }
            }
        });
        this.JNetGroup.add(this.confDnsByHandRadio);
        this.JNetGroup.add(this.confDnsByDhcpRadio);
        this.confDnsByHandRadio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JRadioButton source = (JRadioButton)e.getSource();
                AddEditDialog.this.Jdns1Txt.setEnabled(source.isSelected());
                AddEditDialog.this.Jdns2Txt.setEnabled(source.isSelected());
            }
        });
        WiFiService wc = new WiFiService();
        List<String> ls = wc.scanWiFiAP();
        int i = 0;
        while (i < ls.size()) {
            this.JsidCom.addItem(ls.get(i));
            ++i;
        }
        List<WiFiConf> ln = wc.scanNetInterface();
        int i2 = 0;
        while (i2 < ln.size()) {
            this.JnetCom.addItem(ln.get(i2).getNetName());
            ++i2;
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                JButton source = (JButton)arg0.getSource();
                if (source.equals(AddEditDialog.this.ack)) {
                    AddEditDialog.this.ackProcess();
                }
                if (source.equals(AddEditDialog.this.canl)) {
                    AddEditDialog.this.canlProcess();
                }
            }
        };
        this.ack.addMouseListener(mouseListener);
        this.canl.addMouseListener(mouseListener);
    }

    private void updateAddEditDialog() {
        if (this.wiFiConf != null) {
            Object[] items = this.JsidCom.getSelectedObjects();
            boolean flag = false;
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o.equals(this.wiFiConf.getSsid())) {
                    flag = true;
                }
                ++n2;
            }
            if (!flag) {
                this.JsidCom.addItem(this.wiFiConf.getSsid());
            }
            this.JsidCom.setSelectedItem(this.wiFiConf.getSsid());
            this.JnetCom.setSelectedItem(this.wiFiConf.getNetName());
            this.confIpByHandRadio.setSelected(this.wiFiConf.getIp().length() > 0);
            this.confDnsByHandRadio.setSelected(this.wiFiConf.getDns1().length() > 0);
            this.confIpByDhcpRadio.setSelected(!this.confIpByHandRadio.isSelected());
            this.confDnsByDhcpRadio.setSelected(!this.confDnsByHandRadio.isSelected());
            this.JipTxt.setText(this.wiFiConf.getIp());
            this.JmaskTxt.setText(this.wiFiConf.getMask());
            this.JgateTxt.setText(this.wiFiConf.getGateway());
            this.Jdns1Txt.setText(this.wiFiConf.getDns1());
            this.Jdns2Txt.setText(this.wiFiConf.getDns2());
        } else {
            this.confIpByHandRadio.setSelected(true);
            this.confDnsByHandRadio.setSelected(true);
        }
        this.JsidCom.setEnabled(this.isEdit);
        this.JnetCom.setEnabled(this.isEdit);
        this.confIpByHandRadio.setEnabled(this.isEdit);
        this.confIpByDhcpRadio.setEnabled(this.isEdit);
        this.confDnsByHandRadio.setEnabled(this.isEdit);
        this.confDnsByDhcpRadio.setEnabled(this.isEdit);
        this.JipTxt.setEnabled(this.isEdit);
        this.JmaskTxt.setEnabled(this.isEdit);
        this.JgateTxt.setEnabled(this.isEdit);
        this.Jdns1Txt.setEnabled(this.isEdit);
        this.Jdns2Txt.setEnabled(this.isEdit);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ackProcess() {
        if (this.wiFiConf == null) {
            if (!this.newWIFIprocess()) {
                log.logInfo((Object)"failure....");
                return;
            }
            log.logInfo((Object)"success....");
        } else if (this.isEdit) {
            this.editWIFIprocess();
        } else {
            log.logErro((Object)"wrong happened.....");
        }
        this.dispose();
    }

    private boolean newWIFIprocess() {
        WiFiConf[] wcs = new WiFiConf[]{};
        try {
            wcs = (WiFiConf[])new ConfigFileUtil().readConfigFile("conf" + File.separator + "autowificonf.xml", (Object)wcs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String ssid = this.JsidCom.getSelectedItem().toString();
        log.logInfo((Object)("ssid=" + ssid));
        WiFiConf[] wiFiConfArray = wcs;
        int n = wcs.length;
        int n2 = 0;
        while (n2 < n) {
            WiFiConf wc = wiFiConfArray[n2];
            log.logInfo((Object)("wc.getSsid()=" + wc.getSsid()));
            if (ssid.equalsIgnoreCase(wc.getSsid())) {
                JOptionPane.showMessageDialog(this, TxtUtil.getMessageByKey("add.msg1"));
                return false;
            }
            ++n2;
        }
        if (!this.checkParamenters()) {
            return false;
        }
        this.wiFiConf = new WiFiConf();
        this.wiFiConf.setId(wcs.length);
        this.transfWiFiConf();
        WiFiConf[] wcs1 = new WiFiConf[wcs.length + 1];
        int i = 0;
        while (i < wcs.length) {
            wcs1[i] = wcs[i];
            ++i;
        }
        wcs1[wcs.length] = this.wiFiConf;
        try {
            new ConfigFileUtil().saveConfigFile((Object)wcs1, "conf" + File.separator + "autowificonf.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void transfWiFiConf() {
        this.wiFiConf.setName(this.JsidCom.getSelectedItem().toString());
        this.wiFiConf.setSsid(this.JsidCom.getSelectedItem().toString());
        this.wiFiConf.setNetName(this.JnetCom.getSelectedItem().toString());
        this.wiFiConf.setIp(this.JipTxt.getText());
        this.wiFiConf.setMask(this.JmaskTxt.getText());
        this.wiFiConf.setGateway(this.JgateTxt.getText());
        this.wiFiConf.setDns1(this.Jdns1Txt.getText());
        this.wiFiConf.setDns2(this.Jdns2Txt.getText());
    }

    private void editWIFIprocess() {
        WiFiConf[] wcs = new WiFiConf[]{};
        try {
            wcs = (WiFiConf[])new ConfigFileUtil().readConfigFile("conf" + File.separator + "autowificonf.xml", (Object)wcs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.checkParamenters();
        this.transfWiFiConf();
        int i = 0;
        while (i < wcs.length) {
            if (wcs[i].getId() == this.wiFiConf.getId()) {
                wcs[i] = this.wiFiConf;
                break;
            }
            ++i;
        }
        try {
            new ConfigFileUtil().saveConfigFile((Object)wcs, "conf" + File.separator + "autowificonf.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean checkParamenters() {
        if (this.JsidCom.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, TxtUtil.getMessageByKey("add.msg2"));
            return false;
        }
        if (this.JnetCom.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, TxtUtil.getMessageByKey("add.msg3"));
            return false;
        }
        if (this.confIpByHandRadio.isSelected()) {
            if (this.JipTxt.getText() == null) {
                JOptionPane.showMessageDialog(this, TxtUtil.getMessageByKey("add.msg4"));
                return false;
            }
            if (this.JmaskTxt.getText() == null) {
                JOptionPane.showMessageDialog(this, TxtUtil.getMessageByKey("add.msg5"));
                return false;
            }
            if (this.JgateTxt.getText() == null) {
                JOptionPane.showMessageDialog(this, TxtUtil.getMessageByKey("add.msg6"));
                return false;
            }
            if (this.JipTxt.getText().length() == 0 || this.checkIP(this.JipTxt.getText())) {
                JOptionPane.showMessageDialog(this, String.valueOf(TxtUtil.getMessageByKey("add.msg9")) + TxtUtil.getMessageByKey("add.msg4"));
                return false;
            }
            if (this.JmaskTxt.getText().length() == 0 || this.checkMask(this.JmaskTxt.getText())) {
                JOptionPane.showMessageDialog(this, String.valueOf(TxtUtil.getMessageByKey("add.msg9")) + TxtUtil.getMessageByKey("add.msg5"));
                return false;
            }
            if (this.JgateTxt.getText().length() == 0 || this.checkIP(this.JgateTxt.getText())) {
                JOptionPane.showMessageDialog(this, String.valueOf(TxtUtil.getMessageByKey("add.msg9")) + TxtUtil.getMessageByKey("add.msg6"));
                return false;
            }
        }
        this.confIpByDhcpRadio.isSelected();
        if (this.confDnsByHandRadio.isSelected()) {
            if (this.Jdns1Txt.getText() == null) {
                JOptionPane.showMessageDialog(this, TxtUtil.getMessageByKey("add.msg7"));
                return false;
            }
            if (this.Jdns2Txt.getText() == null) {
                JOptionPane.showMessageDialog(this, TxtUtil.getMessageByKey("add.msg8"));
                return false;
            }
            if (this.Jdns1Txt.getText().length() == 0 || this.checkIP(this.Jdns1Txt.getText())) {
                JOptionPane.showMessageDialog(this, String.valueOf(TxtUtil.getMessageByKey("add.msg9")) + TxtUtil.getMessageByKey("add.msg7"));
                return false;
            }
            if (this.Jdns2Txt.getText().length() == 0 || this.checkIP(this.Jdns2Txt.getText())) {
                JOptionPane.showMessageDialog(this, String.valueOf(TxtUtil.getMessageByKey("add.msg9")) + TxtUtil.getMessageByKey("add.msg8"));
                return false;
            }
        }
        this.confDnsByDhcpRadio.isSelected();
        return true;
    }

    private boolean checkIP(String ip) {
        return !ip.matches("((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|[1-9])");
    }

    private boolean checkMask(String mask) {
        return !mask.matches("((25[0-5]|2[0-4]\\d|1\\d\\d|[0-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[0-9]\\d|[0-9])");
    }

    private void canlProcess() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        AddEditDialog dialog = new AddEditDialog(null, null, true);
        dialog.setDefaultCloseOperation(2);
        dialog.setLocationRelativeTo(null);
        dialog.getContentPane().setPreferredSize(dialog.getSize());
        dialog.setVisible(true);
    }
}

