/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.autoWiFi.ui;

import com.jacky.cici.autoWiFi.ui.AboutDialog;
import com.jacky.cici.autoWiFi.ui.AddEditDialog;
import com.jacky.cici.autoWiFi.ui.WifiJToggleButton;
import com.jacky.cici.autoWiFi.ui.WifiTableModel;
import com.jacky.cici.autoWiFi.vo.WiFiConf;
import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import com.jacky.cici.util.ConfigFileUtil;
import com.jacky.cici.util.DebugUtil;
import com.jacky.cici.util.PngUtil;
import com.jacky.cici.util.TxtUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static ILogger log = MyLogger.getDateLogger((String)"logger/MainFrame", (String)"MainFrame", (int)5, (boolean)DebugUtil.isLog2Screen);
    private JLabel logo = new JLabel();
    private WifiJToggleButton add = new WifiJToggleButton();
    private WifiJToggleButton up = new WifiJToggleButton();
    private WifiJToggleButton down = new WifiJToggleButton();
    private WifiJToggleButton edit = new WifiJToggleButton();
    private WifiJToggleButton hidden = new WifiJToggleButton();
    private AddEditDialog addDialog = new AddEditDialog(null, null, true);
    private AboutDialog aboutDialog = new AboutDialog();
    private ButtonGroup bg = new ButtonGroup();
    private boolean mainFrameVisible = false;
    private FlowLayout flowLayoutRight = new FlowLayout();
    private BorderLayout borderLayoutCenter = new BorderLayout();
    private JTable autoTable = new JTable(){
        private static final long serialVersionUID = 6264536810777469019L;
    };
    private WifiTableModel tm = null;
    private MouseAdapter mouseEventHandle = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            WifiJToggleButton source = (WifiJToggleButton)e.getSource();
            if (!source.isEnabled()) {
                return;
            }
            if (source.equals(MainFrame.this.add)) {
                MainFrame.this.add.setEnabled(false);
                log.logInfo((Object)"add dailog");
                new SwingWorker<ArrayList<?>, Long>(){

                    @Override
                    protected ArrayList<?> doInBackground() throws Exception {
                        MainFrame.this.addDialog = new AddEditDialog((Frame)MainFrame.this, null, true);
                        MainFrame.this.addDialog.setModal(true);
                        MainFrame.this.addDialog.setVisible(true);
                        return null;
                    }

                    @Override
                    protected void done() {
                        MainFrame.this.loadTableDatas();
                        MainFrame.this.add.setEnabled(true);
                    }
                }.execute();
            } else if (source.equals(MainFrame.this.up)) {
                log.logInfo((Object)"up list");
                int selectedRow = MainFrame.this.autoTable.getSelectedRow();
                if (selectedRow != -1) {
                    MainFrame.this.tm.upList(selectedRow);
                    MainFrame.this.saveTableDatas();
                    MainFrame.this.loadTableDatas();
                    MainFrame.this.autoTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                }
            } else if (source.equals(MainFrame.this.down)) {
                log.logInfo((Object)"down list");
                int selectedRow = MainFrame.this.autoTable.getSelectedRow();
                if (selectedRow != -1) {
                    MainFrame.this.tm.downList(selectedRow);
                    MainFrame.this.saveTableDatas();
                    MainFrame.this.loadTableDatas();
                    MainFrame.this.autoTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
                }
            } else if (source.equals(MainFrame.this.edit)) {
                log.logInfo((Object)"show edit dailog");
                if (MainFrame.this.autoTable.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog(null, "\u8bf7\u9009\u62e9\u7f16\u8f91\u9879");
                } else {
                    MainFrame.this.edit.setEnabled(false);
                    WiFiConf wiFiConf = MainFrame.this.tm.getWifiConf(MainFrame.this.autoTable.getSelectedRow());
                    MainFrame.this.addDialog = new AddEditDialog((Frame)MainFrame.this, wiFiConf, true);
                    MainFrame.this.addDialog.setModal(true);
                    MainFrame.this.addDialog.setVisible(true);
                    MainFrame.this.edit.setEnabled(true);
                    MainFrame.this.loadTableDatas();
                }
            } else if (source.equals(MainFrame.this.hidden)) {
                log.logInfo((Object)"hidden mainframe ok");
                MainFrame.this.hiddenMainFrame();
            } else {
                log.logInfo((Object)"unkown deal with");
            }
        }
    };

    public boolean isMainFrameVisible() {
        return this.mainFrameVisible;
    }

    public void setMainFrameVisible(boolean mainFrameVisible) {
        this.mainFrameVisible = mainFrameVisible;
    }

    private void loadTableDatas() {
        ArrayList<WiFiConf> al = new ArrayList<WiFiConf>();
        Object[] wcs = new WiFiConf[]{};
        wcs = this.readDataFromFile((WiFiConf[])wcs);
        al.clear();
        Arrays.sort(wcs);
        al.addAll(Arrays.asList(wcs));
        this.tm.setDatas(al);
        this.autoTable.repaint();
    }

    private WiFiConf[] readDataFromFile(WiFiConf[] wcs) {
        try {
            wcs = (WiFiConf[])new ConfigFileUtil().readConfigFile("conf" + File.separator + "autowificonf.xml", (Object)wcs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wcs;
    }

    private void saveTableDatas() {
        WiFiConf[] wcs = new WiFiConf[]{};
        wcs = this.tm.getDatas().toArray(new WiFiConf[0]);
        this.saveDatasToFile(wcs);
    }

    private void saveDatasToFile(WiFiConf[] wcs) {
        try {
            new ConfigFileUtil().saveConfigFile((Object)wcs, "conf" + File.separator + "autowificonf.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void ShowAboutDialog() {
        this.aboutDialog.setVisible(true);
        this.addDialog.setVisible(false);
        this.setVisible(false);
    }

    protected void hiddeAboutDialog() {
        this.aboutDialog.setVisible(false);
    }

    public MainFrame() {
        log.logInfo((Object)"\u5b9e\u73b0\u9762\u677f\u5e03\u5c40\u64cd\u4f5c");
        this.setUndecorated(true);
        this.initComponents();
        this.addAutoComponents();
        log.logInfo((Object)"\u5b9e\u73b0\u9762\u677f\u5e03\u5c40\u64cd\u4f5c--0k");
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(220, 290));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent arg0) {
                if (!MainFrame.this.addDialog.isVisible()) {
                    log.logInfo((Object)"mainFrame windowDeactivated");
                    MainFrame.this.hiddenMainFrame();
                }
            }
        });
    }

    private void hiddenMainFrame() {
        this.setAlwaysOnTop(false);
        this.setMainFrameVisible(false);
        this.setVisible(false);
        this.addDialog.setVisible(false);
        this.aboutDialog.setVisible(false);
    }

    private void addAutoComponents() {
        this.bg.add(this.add);
        this.bg.add(this.up);
        this.bg.add(this.down);
        this.bg.add(this.edit);
        this.bg.add(this.hidden);
        this.logo.setText(TxtUtil.getMessageByKey("logo.name"));
        this.logo.setIcon(PngUtil.getImageIcon("wifi16X16.png"));
        this.add.setIcon(PngUtil.getImageIcon("add16X16.png"));
        this.add.setToolTipText("\u65b0\u589e");
        this.add.addMouseListener(this.mouseEventHandle);
        this.up.setIcon(PngUtil.getImageIcon("up16X16.png"));
        this.up.setToolTipText("\u4e0a\u79fb");
        this.up.addMouseListener(this.mouseEventHandle);
        this.down.setIcon(PngUtil.getImageIcon("down16X16.png"));
        this.down.setToolTipText("\u4e0b\u79fb");
        this.down.addMouseListener(this.mouseEventHandle);
        this.edit.setIcon(PngUtil.getImageIcon("edit16X16.png"));
        this.edit.setToolTipText("\u7f16\u8f91");
        this.edit.addMouseListener(this.mouseEventHandle);
        this.hidden.setIcon(PngUtil.getImageIcon("invisible16X16.png"));
        this.hidden.setToolTipText("\u9690\u85cf");
        this.hidden.addMouseListener(this.mouseEventHandle);
        JPanel toolPanel = new JPanel();
        this.flowLayoutRight.setAlignment(2);
        this.flowLayoutRight.setHgap(0);
        toolPanel.setLayout(this.flowLayoutRight);
        toolPanel.add(this.add);
        toolPanel.add(this.edit);
        toolPanel.add(this.up);
        toolPanel.add(this.down);
        toolPanel.add(this.hidden);
        JPanel logoPanel = new JPanel();
        logoPanel.add(this.logo);
        JPanel menuPanel = new JPanel();
        menuPanel.setLayout(new BorderLayout());
        menuPanel.add((Component)logoPanel, "West");
        menuPanel.add((Component)toolPanel, "Center");
        this.tm = new WifiTableModel(null);
        this.loadTableDatas();
        this.autoTable.setModel(this.tm);
        this.autoTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.autoTable.getColumnModel().getColumn(1).setMaxWidth(130);
        this.autoTable.getColumnModel().getColumn(2).setMaxWidth(40);
        this.autoTable.setSelectionMode(0);
        this.tm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                WiFiConf wfc;
                if (e.getColumn() == 2 && (wfc = MainFrame.this.tm.getWifiConf(e.getFirstRow())).isUsed()) {
                    WiFiConf[] wcs = new WiFiConf[]{};
                    WiFiConf[] wiFiConfArray = wcs = MainFrame.this.readDataFromFile(wcs);
                    int n = wcs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        WiFiConf wc = wiFiConfArray[n2];
                        if (wc.equals(wfc)) {
                            wc.setUsed(true);
                        } else {
                            wc.setUsed(false);
                        }
                        ++n2;
                    }
                    MainFrame.this.saveDatasToFile(wcs);
                    MainFrame.this.loadTableDatas();
                    MainFrame.this.autoTable.repaint();
                }
            }
        });
        JScrollPane jsPanel = new JScrollPane();
        jsPanel.getViewport().add(this.autoTable);
        this.setLayout(this.borderLayoutCenter);
        this.add((Component)menuPanel, "North");
        this.add((Component)jsPanel, "Center");
    }

    public void updateTable() {
        this.loadTableDatas();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.autoTable.repaint();
            }
        });
    }

    public static void main(String[] args) {
        MainFrame t = new MainFrame();
        t.setDefaultCloseOperation(2);
        t.pack();
        t.setVisible(true);
        t.toFront();
    }
}

