/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.autoWiFi.ui;

import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import com.jacky.cici.util.DebugUtil;
import com.jacky.cici.util.SecurityUtil;
import com.jacky.cici.util.TxtUtil;
import com.jacky.cici.util.WindowUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class RegisterDialog
extends JDialog {
    private static ILogger log = MyLogger.getDateLogger((String)"logger/RegisterDialog", (String)"RegisterDialog", (int)5, (boolean)DebugUtil.isLog2Screen);
    private static final long serialVersionUID = 1L;
    private JLabel memoLab = new JLabel(TxtUtil.getMessageByKey("register.memo"));
    private JLabel nameLab = new JLabel(TxtUtil.getMessageByKey("register.name"));
    private JLabel emaiLab = new JLabel(TxtUtil.getMessageByKey("register.email"));
    private JLabel cellLab = new JLabel(TxtUtil.getMessageByKey("register.cell"));
    private JTextField nameTxt = new JTextField("");
    private JTextField emailTxt = new JTextField("");
    private JTextField cellTxt = new JTextField("");
    private JButton smt = new JButton(TxtUtil.getMessageByKey("register.submit"));
    private JButton ack = new JButton(TxtUtil.getMessageByKey("register.register"));
    private JButton canl = new JButton(TxtUtil.getMessageByKey("register.cancel"));
    private JTabbedPane jtabP = new JTabbedPane();

    public RegisterDialog() {
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setSize(275, 180);
        this.setTitle(TxtUtil.getMessageByKey("register.title"));
        this.setLocationRelativeTo(null);
        this.add(this.jtabP);
        this.createUserInfoPanel();
        this.createLicensePanel();
        this.createRegisterInfoPanel();
    }

    private void createUserInfoPanel() {
        JPanel userPanel = new JPanel();
        FormLayout layout = new FormLayout("center:2dlu,center:30dlu,center:20dlu,center:30dlu,center:20dlu,center:30dlu,center:2dlu", "center:2dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:2dlu");
        CellConstraints cc = new CellConstraints();
        userPanel.setLayout((LayoutManager)layout);
        userPanel.add((Component)this.memoLab, cc.xywh(2, 2, 5, 1, CellConstraints.CENTER, CellConstraints.CENTER));
        userPanel.add((Component)this.nameLab, cc.xywh(2, 3, 1, 1));
        userPanel.add((Component)this.nameTxt, cc.xywh(3, 3, 4, 1));
        userPanel.add((Component)this.emaiLab, cc.xywh(2, 4, 1, 1));
        userPanel.add((Component)this.emailTxt, cc.xywh(3, 4, 4, 1));
        userPanel.add((Component)this.cellLab, cc.xywh(2, 5, 1, 1));
        userPanel.add((Component)this.cellTxt, cc.xywh(3, 5, 4, 1));
        userPanel.add((Component)this.smt, cc.xywh(2, 6, 2, 1));
        userPanel.add((Component)this.canl, cc.xywh(5, 6, 2, 1));
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                boolean flag = true;
                StringBuilder sb = new StringBuilder();
                JButton source = (JButton)arg0.getSource();
                if (source.equals(RegisterDialog.this.canl)) {
                    RegisterDialog.this.setVisible(false);
                    return;
                }
                if (source.equals(RegisterDialog.this.ack)) {
                    flag = this.checkParamenter1(flag, sb);
                    if (RegisterDialog.this.cellTxt.getText().length() == 0) {
                        flag = false;
                        sb.append(String.valueOf(sb.length() == 0 ? "\u8bf7\u586b\u5199" : "") + "\u6ce8\u518c\u7801,");
                    }
                    this.showMessageDialog(flag, sb);
                }
                if (source.equals(RegisterDialog.this.smt)) {
                    flag = this.checkParamenter1(flag, sb);
                    this.showMessageDialog(flag, sb);
                }
                if (!flag) {
                    return;
                }
                this.saveUploadInfo();
            }

            private void saveUploadInfo() {
                WindowUtil.execFixed.execute(new Runnable(){

                    @Override
                    public void run() {
                        log.logInfo((Object)"\u65b9\u6cd5\u672a\u5b9e\u73b0");
                    }
                });
            }

            private void showMessageDialog(boolean flag, StringBuilder sb) {
                if (!flag) {
                    sb.setLength(sb.length() - 1);
                    sb.append("!");
                    JOptionPane.showMessageDialog(RegisterDialog.this, sb.toString());
                }
            }

            private boolean checkParamenter1(boolean flag, StringBuilder sb) {
                if (RegisterDialog.this.nameTxt.getText().length() == 0) {
                    flag = false;
                    sb.append(String.valueOf(sb.length() == 0 ? "\u8bf7\u586b\u5199" : "") + "\u59d3\u540d,");
                }
                if (RegisterDialog.this.emailTxt.getText().length() == 0) {
                    flag = false;
                    sb.append(String.valueOf(sb.length() == 0 ? "\u8bf7\u586b\u5199" : "") + "\u90ae\u7bb1,");
                }
                if (RegisterDialog.this.cellTxt.getText().length() == 0) {
                    flag = false;
                    sb.append(String.valueOf(sb.length() == 0 ? "\u8bf7\u586b\u5199" : "") + "\u624b\u673a,");
                }
                return flag;
            }
        };
        this.smt.addMouseListener(mouseListener);
        this.canl.addMouseListener(mouseListener);
        this.jtabP.add(TxtUtil.getMessageByKey("register.tab1"), userPanel);
    }

    private void createLicensePanel() {
        JPanel userPanel = new JPanel();
        this.jtabP.add(TxtUtil.getMessageByKey("register.tab2"), userPanel);
        FormLayout layout = new FormLayout("center:2dlu,center:30dlu,center:20dlu,center:30dlu,center:20dlu,center:30dlu,center:2dlu", "center:2dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:2dlu");
        CellConstraints cc = new CellConstraints();
        userPanel.setLayout((LayoutManager)layout);
        JLabel memoLab = new JLabel(TxtUtil.getMessageByKey("register.memo3"));
        JLabel licenLab = new JLabel(TxtUtil.getMessageByKey("register.licen"));
        JTextField licenTxt = new JTextField("");
        userPanel.add((Component)memoLab, cc.xywh(2, 2, 5, 1, CellConstraints.CENTER, CellConstraints.CENTER));
        userPanel.add((Component)licenLab, cc.xywh(2, 3, 1, 1));
        userPanel.add((Component)licenTxt, cc.xywh(3, 3, 4, 1));
        licenTxt.setEnabled(false);
        final JButton browser = new JButton(TxtUtil.getMessageByKey("register.browser"));
        final JButton smt = new JButton(TxtUtil.getMessageByKey("register.ok"));
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                if (arg0.getSource().equals(smt)) {
                    RegisterDialog.this.setVisible(false);
                    return;
                }
                if (arg0.getSource().equals(browser)) {
                    JFileChooser jfc = new JFileChooser();
                    jfc.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.getName().endsWith("dat");
                        }

                        @Override
                        public String getDescription() {
                            return "*.dat file. example : license.dat";
                        }
                    });
                    jfc.setMultiSelectionEnabled(false);
                    jfc.showOpenDialog(RegisterDialog.this);
                    if (jfc.getSelectedFile() != null) {
                        this.processLicence(jfc.getSelectedFile());
                    }
                }
            }

            private void processLicence(final File licenFile) {
                WindowUtil.execFixed.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileInputStream keyfis = new FileInputStream(licenFile);
                            byte[] encKey = new byte[keyfis.available()];
                            keyfis.read(encKey);
                            SecurityUtil su = new SecurityUtil();
                            su.checkCode(null);
                        }
                        catch (Exception e) {
                            log.logErro((Object)e);
                        }
                    }
                });
            }
        };
        smt.addMouseListener(mouseListener);
        browser.addMouseListener(mouseListener);
        userPanel.add((Component)browser, cc.xywh(5, 4, 2, 1));
        userPanel.add((Component)smt, cc.xywh(5, 6, 2, 1));
    }

    private void createRegisterInfoPanel() {
        JPanel userPanel = new JPanel();
        this.jtabP.add(TxtUtil.getMessageByKey("register.tab3"), userPanel);
        FormLayout layout = new FormLayout("center:2dlu,center:30dlu,center:20dlu,center:30dlu,center:20dlu,center:30dlu,center:2dlu", "center:2dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:18dlu,center:2dlu");
        CellConstraints cc = new CellConstraints();
        userPanel.setLayout((LayoutManager)layout);
        JLabel memoLab = new JLabel(TxtUtil.getMessageByKey("register.memo3"));
        JLabel emaiLab = new JLabel(TxtUtil.getMessageByKey("register.email"));
        JLabel cellLab = new JLabel(TxtUtil.getMessageByKey("register.cell"));
        JLabel expiredLab = new JLabel(TxtUtil.getMessageByKey("register.expired"));
        JTextField emailTxt = new JTextField("");
        JTextField cellTxt = new JTextField("");
        JTextField expiredTxt = new JTextField("");
        userPanel.add((Component)memoLab, cc.xywh(2, 2, 5, 1, CellConstraints.CENTER, CellConstraints.CENTER));
        userPanel.add((Component)emaiLab, cc.xywh(2, 3, 1, 1));
        userPanel.add((Component)emailTxt, cc.xywh(3, 3, 4, 1));
        userPanel.add((Component)cellLab, cc.xywh(2, 4, 1, 1));
        userPanel.add((Component)cellTxt, cc.xywh(3, 4, 4, 1));
        userPanel.add((Component)expiredLab, cc.xywh(2, 5, 1, 1));
        userPanel.add((Component)expiredTxt, cc.xywh(3, 5, 4, 1));
        emailTxt.setEnabled(false);
        cellTxt.setEnabled(false);
        expiredTxt.setEnabled(false);
        JButton smt = new JButton(TxtUtil.getMessageByKey("register.ok"));
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                RegisterDialog.this.setVisible(false);
            }
        };
        smt.addMouseListener(mouseListener);
        userPanel.add((Component)smt, cc.xywh(5, 6, 2, 1));
    }

    public static void main(String[] args) {
        RegisterDialog dialog = new RegisterDialog();
        dialog.setDefaultCloseOperation(2);
        dialog.setLocationRelativeTo(null);
        dialog.getContentPane().setPreferredSize(dialog.getSize());
        dialog.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegisterDialog.this.setVisible(true);
            }
        });
    }
}

