/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.autoWiFi.ui;

import com.jacky.cici.autoWiFi.service.WiFiSwitchService;
import com.jacky.cici.autoWiFi.ui.MainFrame;
import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import com.jacky.cici.util.DebugUtil;
import com.jacky.cici.util.PngUtil;
import com.jacky.cici.util.TxtUtil;
import com.jacky.cici.util.WindowUtil;
import it.sauronsoftware.junique.AlreadyLockedException;
import it.sauronsoftware.junique.JUnique;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class WifiMain {
    private static ILogger log = MyLogger.getDateLogger((String)"logger/WifiMain", (String)"WifiMain", (int)5, (boolean)DebugUtil.isLog2Screen);

    public void initTryIcon() {
        boolean alreadyRunning;
        String appId = "AutoWiFiSwitch";
        try {
            JUnique.acquireLock((String)appId);
            alreadyRunning = false;
        }
        catch (AlreadyLockedException e) {
            alreadyRunning = true;
        }
        if (alreadyRunning) {
            final JLabel jlabel = new JLabel("\u667a\u80fdWIFI\u5207\u6362\u8f6f\u4ef6\u5df2\u7ecf\u5728\u8fd0\u884c!");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, jlabel);
                    }
                });
            }
            catch (InterruptedException e) {
                log.logErro((Object)e);
            }
            catch (InvocationTargetException e) {
                log.logErro((Object)e);
            }
            System.exit(1);
            return;
        }
        log.logInfo((Object)"\u542f\u52a8switch\u7a0b\u5e8f\uff0c\u521d\u59cb\u5316UI\u9762\u677f");
        final MainFrame mainFrame = new MainFrame();
        log.logInfo((Object)"\u542f\u52a8switch\u7a0b\u5e8f\uff0c\u521d\u59cb\u5316UI\u9762\u677f---ok");
        WindowUtil.execFixed.execute(new Runnable(){

            @Override
            public void run() {
                log.logInfo((Object)"\u542f\u52a8wifi\u68c0\u67e5\u5b9a\u65f6\u5668\u4e0e\u684c\u9762\u5feb\u6377\u952e\u521b\u5efa");
                WindowUtil.execScheduled.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        log.logInfo((Object)"\u540e\u53f0\u6267\u884c\u5207\u6362\u7a0b\u5e8f");
                        new WiFiSwitchService().autoWifi();
                        mainFrame.updateTable();
                        log.logInfo((Object)"\u540e\u53f0\u6267\u884c\u5207\u6362\u7a0b\u5e8f---ok");
                    }
                }, 0L, 30L, TimeUnit.SECONDS);
                File f1 = new File("wifi.ico");
                File f2 = new File("autoSwitch.exe");
                WindowUtil.createShortCut(f2.getAbsolutePath(), f1.getAbsolutePath());
                WindowUtil.createRun(f2.getAbsolutePath());
            }
        });
        if (!SystemTray.isSupported()) {
            log.logInfo((Object)"\u7cfb\u7edf\u65e0\u6cd5\u652f\u6301\u7cfb\u7edf\u6258\u76d8\u64cd\u4f5c");
            return;
        }
        final SystemTray tray = SystemTray.getSystemTray();
        final TrayIcon ti = new TrayIcon(PngUtil.getImageIcon("wifi16X16try.png").getImage(), TxtUtil.getMessageByKey("logo.name"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    tray.add(ti);
                    log.logInfo((Object)"\u6dfb\u52a0\u7cfb\u7edf\u56fe\u6807---ok");
                }
                catch (AWTException e) {
                    log.logErro((Object)e);
                }
            }
        });
        final JMenuItem displayItem = new JMenuItem(TxtUtil.getMessageByKey("tray.display"));
        final JMenuItem aboutItem = new JMenuItem(TxtUtil.getMessageByKey("tray.about"));
        final JMenuItem exitItem = new JMenuItem(TxtUtil.getMessageByKey("tray.exit"));
        final JMenuItem helpItem = new JMenuItem("\u5e2e\u52a9");
        final JFrame IconDialog = new JFrame();
        IconDialog.setUndecorated(true);
        IconDialog.setSize(0, 0);
        final JPopupMenu popupTi = new JPopupMenu();
        popupTi.add(displayItem);
        popupTi.add(helpItem);
        popupTi.add(aboutItem);
        popupTi.add(exitItem);
        popupTi.setInvoker(IconDialog);
        IconDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent arg0) {
                log.logInfo((Object)"======windowDeactivated");
                IconDialog.setVisible(false);
            }
        });
        ActionListener showListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(displayItem)) {
                    WifiMain.this.showMainFrame(mainFrame, MouseInfo.getPointerInfo().getLocation());
                } else if (e.getSource().equals(aboutItem)) {
                    mainFrame.ShowAboutDialog();
                } else if (e.getSource().equals(exitItem)) {
                    log.logInfo((Object)"\u6e05\u9664\u7cfb\u7edf\u56fe\u6807\uff0c\u9000\u51fa\u7cfb\u7edf\uff01");
                    tray.remove(ti);
                    System.exit(0);
                } else if (e.getSource().equals(helpItem)) {
                    log.logInfo((Object)"help button ......");
                    try {
                        Runtime.getRuntime().exec("cmd.exe /c start help.chm");
                    }
                    catch (Exception e1) {
                        log.logErro((Object)e1);
                    }
                }
            }
        };
        displayItem.addActionListener(showListener);
        aboutItem.addActionListener(showListener);
        exitItem.addActionListener(showListener);
        helpItem.addActionListener(showListener);
        ti.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getSource() instanceof Component) {
                    return;
                }
                if (arg0.getButton() == 3) {
                    if (!popupTi.isVisible()) {
                        Point p = arg0.getPoint();
                        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
                        Dimension d2 = popupTi.getPreferredSize();
                        if (d1.width - p.x < d2.width) {
                            p.x -= d2.width;
                        }
                        p.y -= d2.height;
                        popupTi.setLocation(p);
                        IconDialog.setAlwaysOnTop(true);
                        IconDialog.setVisible(true);
                        popupTi.setVisible(true);
                        IconDialog.toFront();
                    }
                    mainFrame.setMainFrameVisible(false);
                } else {
                    IconDialog.setAlwaysOnTop(false);
                    IconDialog.setVisible(false);
                    popupTi.setVisible(false);
                    if (mainFrame.isMainFrameVisible()) {
                        mainFrame.setVisible(false);
                    } else {
                        Point p = arg0.getPoint();
                        WifiMain.this.showMainFrame(mainFrame, p);
                    }
                    mainFrame.setMainFrameVisible(!mainFrame.isMainFrameVisible());
                }
            }
        });
    }

    private void showMainFrame(final MainFrame mainFrame, final Point p) {
        mainFrame.hiddeAboutDialog();
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                if (!mainFrame.isVisible()) {
                    Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension d2 = mainFrame.getPreferredSize();
                    Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(mainFrame.getGraphicsConfiguration());
                    p.x = d1.width - p.x < d2.width / 2 ? (p.x -= d2.width) : (p.x -= d2.width / 2);
                    p.y = d1.height - d2.height - screenInsets.bottom;
                    mainFrame.setLocation(p);
                }
                mainFrame.setAlwaysOnTop(true);
                mainFrame.pack();
                return null;
            }

            @Override
            protected void done() {
                mainFrame.setVisible(true);
                mainFrame.toFront();
            }
        }.execute();
    }

    public static void main(String[] args) {
        new WifiMain().initTryIcon();
    }
}

