/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.autoWiFi.ui;

import com.jacky.cici.autoWiFi.vo.WiFiConf;
import com.jacky.cici.util.TxtUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class WifiTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4862606829983206315L;
    private String[] columnNames = new String[]{TxtUtil.getMessageByKey("table.id"), TxtUtil.getMessageByKey("table.name"), TxtUtil.getMessageByKey("table.status")};
    private List<WiFiConf> datas = new ArrayList<WiFiConf>();

    public WifiTableModel(List<WiFiConf> datas) {
        this.datas = datas;
    }

    public List<WiFiConf> getDatas() {
        return this.datas;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.datas.size();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.datas.size()) {
            switch (columnIndex) {
                case 0: {
                    return this.datas.get(rowIndex).getId();
                }
                case 1: {
                    return this.datas.get(rowIndex).getName();
                }
                case 2: {
                    return this.datas.get(rowIndex).isUsed();
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.datas.size()) {
            switch (columnIndex) {
                case 0: {
                    this.datas.get(rowIndex).setId((Integer)aValue);
                }
                case 1: {
                    this.datas.get(rowIndex).setName("" + aValue);
                }
                case 2: {
                    this.datas.get(rowIndex).setUsed((Boolean)aValue);
                }
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex > 1) {
            return false;
        }
        return false;
    }

    public void setDatas(List<WiFiConf> datas) {
        this.datas = datas;
    }

    public WiFiConf getWifiConf(int index) {
        return this.datas.get(index);
    }

    public void upList(int index) {
        if (index != 0) {
            WiFiConf wfc1 = this.datas.get(index - 1);
            WiFiConf wfc2 = this.datas.get(index);
            int id = wfc1.getId();
            wfc1.setId(wfc2.getId());
            wfc2.setId(id);
        }
    }

    public void downList(int index) {
        if (index != this.datas.size() - 1) {
            WiFiConf wfc1 = this.datas.get(index);
            WiFiConf wfc2 = this.datas.get(index + 1);
            int id = wfc1.getId();
            wfc1.setId(wfc2.getId());
            wfc2.setId(id);
        }
    }
}

