/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.cici.util;

import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import com.jacky.cici.util.DebugUtil;
import com.jacky.cici.util.WindowUtil;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ImageIcon;

public class PngUtil {
    private static final ILogger log = MyLogger.getDateLogger((String)"logger/PngUtil", (String)"PngUtil", (int)5, (boolean)DebugUtil.isLog2Screen);
    private static final String[] imageNames = new String[]{"wifi16X16try.png", "wifi16X16.png", "add16X16.png", "edit16X16.png", "up16X16.png", "down16X16.png", "invisible16X16.png", "about320X240.png"};
    private static final ConcurrentHashMap<String, ImageIcon> images = new ConcurrentHashMap();

    static {
        WindowUtil.execFixed.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String[] stringArray = imageNames;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s;
                    String string = s = stringArray[n2];
                    synchronized (string) {
                        if (!images.containsKey(s)) {
                            PngUtil.loadImage(s);
                        }
                    }
                    ++n2;
                }
                log.logInfo((Object)"\u56fe\u7247\u52a0\u8f7d\u5b8c\u6210--ok");
            }
        });
    }

    private static void loadImage(String imageName) {
        log.logInfo((Object)("loading imageName=" + imageName));
        URL url = PngUtil.class.getResource("/image/" + imageName);
        log.logInfo((Object)("url=" + url));
        ImageIcon image = new ImageIcon(url);
        images.put(imageName, image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getImageIcon(String imageName) {
        String string = imageName;
        synchronized (string) {
            if (!images.containsKey(imageName)) {
                PngUtil.loadImage(imageName);
            }
            return images.get(imageName);
        }
    }
}

