/*
 * Decompiled with CFR 0.152.
 */
package com.xzdl.util.win;

import com.jacky.cici.interfaces.ILogger;
import com.jacky.cici.logger.MyLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

public class CommandService {
    private ILogger log = MyLogger.getDateLogger((String)"logger/CommandService", (String)"CommandService", (int)5, (boolean)true);
    private Process pb = null;
    private String echoString = "";
    public static final byte[] ENTER_BYTES = "\n".getBytes();
    public static final byte[] EXIT_BYTES = "exit\n".getBytes();
    public static final String SPACE = " ";
    private ExecutorService exeService = Executors.newFixedThreadPool(1000);
    private OutputStream out = null;
    private ProcessIOreadEnhancedThread standIothread;
    private ProcessIOreadEnhancedThread erroIothread;
    private int cmdWaiteTimeMillionSecond = 80;
    private List<CallBack> callBackList = new ArrayList<CallBack>();
    private LinkedBlockingQueue<String> echoStringList = new LinkedBlockingQueue();
    private LinkedBlockingQueue<String> resultStringList = new LinkedBlockingQueue();

    private void addCallBack(CallBack cb) {
        if (!this.callBackList.contains(cb) && cb != null) {
            this.callBackList.add(cb);
        }
    }

    public CommandService() throws IOException {
        this.pb = Runtime.getRuntime().exec("cmd");
        this.out = this.pb.getOutputStream();
        this.log.logInfo((Object)"\u6210\u529f\u521b\u5efacmd\u7a97\u53e3\u8fdb\u7a0b");
        this.standIothread = new ProcessIOreadEnhancedThread(this.pb.getInputStream());
        this.erroIothread = new ProcessIOreadEnhancedThread(this.pb.getErrorStream());
        this.exeService.execute(this.standIothread);
        this.exeService.execute(this.erroIothread);
        this.echoString = this.getEchoString();
    }

    private String getEchoString() {
        try {
            Thread.sleep(this.cmdWaiteTimeMillionSecond);
            this.echoStringList.clear();
            this.out.write(ENTER_BYTES);
            this.out.flush();
            this.out.write(ENTER_BYTES);
            this.out.flush();
            String fistString = this.echoStringList.take();
            String secondString = this.echoStringList.take();
            while (!fistString.equals(secondString)) {
                fistString = secondString;
                secondString = this.echoStringList.take();
            }
            this.echoString = secondString;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.echoString;
    }

    private String convertToString(List<String> commands) {
        StringBuffer sb = new StringBuffer();
        for (String s : commands) {
            sb.append(s).append(SPACE);
        }
        return sb.toString().trim();
    }

    private byte[] getLocalByte(String string) {
        String language = System.getProperty("user.language");
        if (language != null) {
            if (language.toLowerCase().contains("zh")) {
                try {
                    return string.getBytes("GBK");
                }
                catch (UnsupportedEncodingException e) {
                    this.log.logErro((Object)e);
                }
            } else {
                return string.getBytes();
            }
        }
        return string.getBytes();
    }

    public List<String> synExcuteCommandImpl(List<String> commands) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            this.out.write(ENTER_BYTES);
            this.out.flush();
            String answer = "";
            while (!(answer = this.echoStringList.take()).equals(this.echoString)) {
            }
            Thread.sleep(this.cmdWaiteTimeMillionSecond);
            this.echoStringList.clear();
            this.resultStringList.clear();
            this.out.write(this.getLocalByte(this.convertToString(commands)));
            this.out.flush();
            this.out.write(ENTER_BYTES);
            this.out.flush();
            this.out.write(ENTER_BYTES);
            this.out.flush();
            while (!(answer = this.resultStringList.take()).equals(this.echoString)) {
                ret.add(answer);
            }
            this.out.write(ENTER_BYTES);
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void asyExcuteCommandImpl(final List<String> commands, final CallBack callBack) {
        this.exeService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CommandService.this.out.write(ENTER_BYTES);
                    CommandService.this.out.flush();
                    String answer = "";
                    while (!(answer = (String)CommandService.this.echoStringList.take()).equals(CommandService.this.echoString)) {
                    }
                    Thread.sleep(CommandService.this.cmdWaiteTimeMillionSecond);
                    CommandService.this.echoStringList.clear();
                    CommandService.this.out.write(CommandService.this.getLocalByte(CommandService.this.convertToString(commands)));
                    CommandService.this.out.flush();
                    CommandService.this.out.write(ENTER_BYTES);
                    CommandService.this.out.flush();
                    CommandService.this.out.write(ENTER_BYTES);
                    CommandService.this.out.flush();
                    while (!(answer = (String)CommandService.this.echoStringList.take()).equals(CommandService.this.echoString)) {
                        callBack.returnValues(answer);
                    }
                    CommandService.this.out.write(EXIT_BYTES);
                    CommandService.this.out.write(ENTER_BYTES);
                    CommandService.this.out.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void realExcuteCommandImpl(List<String> commands, CallBack callBack) {
        this.addCallBack(callBack);
        try {
            this.out.write(ENTER_BYTES);
            this.out.flush();
            Thread.sleep(this.cmdWaiteTimeMillionSecond);
            this.echoStringList.clear();
            this.out.write(this.getLocalByte(this.convertToString(commands)));
            this.out.flush();
            this.out.write(ENTER_BYTES);
            this.out.flush();
            this.out.write(EXIT_BYTES);
            this.out.write(ENTER_BYTES);
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String> synExcuteCommand(List<String> commands) throws Exception {
        CommandService cs = new CommandService();
        List<String> ret = cs.synExcuteCommandImpl(commands);
        cs.release();
        return ret;
    }

    public static CommandService asyExcuteCommand(List<String> commands, CallBack callBack) throws Exception {
        CommandService cs = new CommandService();
        cs.asyExcuteCommandImpl(commands, callBack);
        return cs;
    }

    public static CommandService realExcuteCommand(List<String> commands, CallBack callBack) throws Exception {
        CommandService cs = new CommandService();
        cs.realExcuteCommandImpl(commands, callBack);
        return cs;
    }

    private void release() throws Exception {
        if (this.pb != null) {
            this.out.write(ENTER_BYTES);
            this.out.flush();
            this.out.write(EXIT_BYTES);
            this.out.flush();
            this.out.write(ENTER_BYTES);
            this.out.flush();
            if (this.out != null) {
                this.out.close();
            }
            this.pb.destroy();
            this.pb = null;
            this.log.logInfo((Object)"finalize....1");
        }
    }

    protected void finalize() throws Throwable {
        if (this.pb != null) {
            this.log.logInfo((Object)"finalize....");
            this.pb.destroy();
        }
        super.finalize();
    }

    public static void main(String[] args) {
        try {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("netsh wlan show interfaces \"\u65e0\u7ebf\u7f51\u7edc\u8fde\u63a5\"");
            commands.add("/fo");
            commands.add("table");
            CommandService.realExcuteCommand(commands, new CallBack(){

                @Override
                public void returnValues(String result) {
                    System.out.println("qqqqResult=" + result);
                }

                @Override
                public void realReturnValues(String realResult) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface CallBack {
        public void returnValues(String var1);

        public void realReturnValues(String var1);
    }

    private class ProcessIOreadEnhancedThread
    extends Thread {
        protected InputStream inStream = null;
        private byte[] readbyte = new byte[2048];
        private String curLineStr = "";

        private String convertLocalString(byte[] content, int length) {
            content = Arrays.copyOf(content, length);
            String language = System.getProperty("user.language");
            if (language != null) {
                if (language.toLowerCase().contains("zh")) {
                    try {
                        return new String(content, "GBK");
                    }
                    catch (UnsupportedEncodingException e) {
                        CommandService.this.log.logErro((Object)e);
                    }
                } else {
                    return new String(content);
                }
            }
            return "";
        }

        private void notifyRealResult(String c) {
            if (c != null && !"".endsWith(c)) {
                CommandService.this.echoStringList.add(c);
                for (CallBack cb : CommandService.this.callBackList) {
                    cb.realReturnValues(c);
                }
            }
        }

        private void notifyEcho(String c) {
            if (c != null && !"".endsWith(c)) {
                CommandService.this.resultStringList.add(c);
                for (CallBack cb : CommandService.this.callBackList) {
                    cb.returnValues(c);
                }
            }
        }

        public ProcessIOreadEnhancedThread(InputStream inStream) {
            this.inStream = inStream;
        }

        @Override
        public void run() {
            int read = 0;
            try {
                while (true) {
                    if ((read = this.inStream.read(this.readbyte)) == -1) {
                        CommandService.this.log.logInfo((Object)"cmd break out");
                        break;
                    }
                    this.curLineStr = String.valueOf(this.curLineStr) + this.convertLocalString(this.readbyte, read);
                    int r_index = this.curLineStr.indexOf("\r");
                    int n_index = this.curLineStr.indexOf("\n");
                    int rn_index = this.curLineStr.indexOf("\r\n");
                    while (r_index >= 0 || n_index >= 0) {
                        if (r_index >= 0 && rn_index == r_index) {
                            if (rn_index >= 0) {
                                if (!"".equalsIgnoreCase(this.curLineStr.substring(0, rn_index))) {
                                    this.notifyEcho(this.curLineStr.substring(0, rn_index));
                                    this.notifyRealResult(this.curLineStr.substring(0, rn_index));
                                }
                                this.curLineStr = this.curLineStr.substring(rn_index + "\r\n".length(), this.curLineStr.length());
                            }
                        } else if (r_index >= 0) {
                            if (!"".equalsIgnoreCase(this.curLineStr.substring(0, r_index))) {
                                this.notifyEcho(this.curLineStr.substring(0, r_index));
                                this.notifyRealResult(this.curLineStr.substring(0, r_index));
                            }
                            this.curLineStr = this.curLineStr.substring(r_index + "\r".length(), this.curLineStr.length());
                        } else if (n_index >= 0) {
                            if (!"".equalsIgnoreCase(this.curLineStr.substring(0, n_index))) {
                                this.notifyEcho(this.curLineStr.substring(0, n_index));
                                this.notifyRealResult(this.curLineStr.substring(0, n_index));
                            }
                            this.curLineStr = this.curLineStr.substring(n_index + "\n".length(), this.curLineStr.length());
                        }
                        r_index = this.curLineStr.indexOf("\r");
                        n_index = this.curLineStr.indexOf("\n");
                        rn_index = this.curLineStr.indexOf("\r\n");
                    }
                    if ("".equals(this.curLineStr)) continue;
                    this.notifyRealResult(this.curLineStr);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

