/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import org.achartengine.chart.AbstractChart;
import org.achartengine.model.CategorySeries;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;

public class PieChart
extends AbstractChart {
    private static final int SHAPE_WIDTH = 10;
    private CategorySeries mDataset;
    private DefaultRenderer mRenderer;

    public PieChart(CategorySeries categorySeries, DefaultRenderer defaultRenderer) {
        this.mDataset = categorySeries;
        this.mRenderer = defaultRenderer;
    }

    @Override
    public void draw(Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int n5 = this.mRenderer.getLegendHeight();
        if (this.mRenderer.isShowLegend() && n5 == 0) {
            n5 = n4 / 5;
        }
        int n6 = n + 15;
        int n7 = n2 + 5;
        int n8 = n + n3 - 5;
        int n9 = n2 + n4 - n5;
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, n4, paint, false, 0);
        int n10 = this.mDataset.getItemCount();
        double d = 0.0;
        String[] stringArray = new String[n10];
        for (int i = 0; i < n10; ++i) {
            d += this.mDataset.getValue(i);
            stringArray[i] = this.mDataset.getCategory(i);
        }
        float f = 0.0f;
        int n11 = Math.min(Math.abs(n8 - n6), Math.abs(n9 - n7));
        int n12 = (int)((double)n11 * 0.35);
        int n13 = (n6 + n8) / 2;
        int n14 = (n9 + n7) / 2;
        float f2 = (float)n12 * 0.9f;
        float f3 = (float)n12 * 1.1f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 20.0f;
        float f7 = 1.0f;
        RectF rectF = new RectF((float)(n13 - n12), (float)(n14 - n12), (float)(n13 + n12), (float)(n14 + n12));
        for (int i = 0; i < n10; ++i) {
            paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
            float f8 = (float)this.mDataset.getValue(i);
            float f9 = (float)((double)f8 / d * 360.0);
            canvas.drawArc(rectF, f, f9, true, paint);
            if (this.mRenderer.isShowLabels()) {
                paint.setColor(this.mRenderer.getLabelsColor());
                double d2 = Math.toRadians(90.0f - (f + f9 / 2.0f));
                double d3 = Math.sin(d2);
                double d4 = Math.cos(d2);
                int n15 = Math.round((float)n13 + (float)((double)f2 * d3));
                int n16 = Math.round((float)n14 + (float)((double)f2 * d4));
                int n17 = Math.round((float)n13 + (float)((double)f3 * d3));
                int n18 = Math.round((float)n14 + (float)((double)f3 * d4));
                if (Math.sqrt(((float)n17 - f4) * ((float)n17 - f4) + ((float)n18 - f5) * ((float)n18 - f5)) <= (double)f6) {
                    f7 = (float)((double)f7 * 1.1);
                    n17 = Math.round((float)n13 + (float)((double)(f3 * f7) * d3));
                    n18 = Math.round((float)n14 + (float)((double)(f3 * f7) * d4));
                } else {
                    f7 = 1.0f;
                }
                canvas.drawLine((float)n15, (float)n16, (float)n17, (float)n18, paint);
                int n19 = 10;
                paint.setTextAlign(Paint.Align.LEFT);
                if (n15 > n17) {
                    n19 = -n19;
                    paint.setTextAlign(Paint.Align.RIGHT);
                }
                canvas.drawLine((float)n17, (float)n18, (float)(n17 + n19), (float)n18, paint);
                canvas.drawText(this.mDataset.getCategory(i), (float)(n17 + n19), (float)(n18 + 5), paint);
                f4 = n17;
                f5 = n18;
            }
            f += f9;
        }
        this.drawLegend(canvas, this.mRenderer, stringArray, n6, n8, n2, n3, n4, n5, paint);
    }

    @Override
    public int getLegendShapeWidth() {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, Paint paint) {
        canvas.drawRect(f, f2 - 5.0f, f + 10.0f, f2 + 5.0f, paint);
    }
}

