/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.achartengine.chart.BarChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class RangeBarChart
extends BarChart {
    public RangeBarChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, BarChart.Type type) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, type);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n) {
        int n2 = this.mDataset.getSeriesCount();
        int n3 = fArray.length;
        paint.setColor(simpleSeriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        float f2 = this.getHalfDiffX(fArray, n3, n2);
        for (int i = 0; i < n3; i += 4) {
            float f3 = fArray[i];
            float f4 = fArray[i + 1];
            float f5 = fArray[i + 2];
            float f6 = fArray[i + 3];
            if (this.mType == BarChart.Type.STACKED) {
                canvas.drawRect(f3 - f2, f6, f5 + f2, f4, paint);
                continue;
            }
            float f7 = f3 - (float)n2 * f2 + (float)(n * 2) * f2;
            canvas.drawRect(f7, f6, f7 + 2.0f * f2, f4, paint);
        }
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, Paint paint, float[] fArray, int n) {
        int n2 = this.mDataset.getSeriesCount();
        float f = this.getHalfDiffX(fArray, fArray.length, n2);
        for (int i = 0; i < fArray.length; i += 4) {
            float f2 = fArray[i];
            if (this.mType == BarChart.Type.DEFAULT) {
                f2 += (float)(n * 2) * f - ((float)n2 - 1.5f) * f;
            }
            this.drawText(canvas, this.getLabel(xYSeries.getY(i / 2 + 1)), f2, fArray[i + 3] - 3.0f, paint, 0.0f);
            this.drawText(canvas, this.getLabel(xYSeries.getY(i / 2)), f2, fArray[i + 1] + 7.5f, paint, 0.0f);
        }
    }

    @Override
    protected float getCoeficient() {
        return 0.5f;
    }
}

