/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Typeface;
import java.util.ArrayList;
import java.util.List;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.ScatterChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.util.MathHelper;

public abstract class XYChart
extends AbstractChart {
    protected XYMultipleSeriesDataset mDataset;
    protected XYMultipleSeriesRenderer mRenderer;
    private float mScale;
    private float mTranslate;
    private PointF mCenter;
    private Rect screenR;
    private double[] calcRange = new double[4];

    public XYChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        this.mDataset = xYMultipleSeriesDataset;
        this.mRenderer = xYMultipleSeriesRenderer;
    }

    @Override
    public void draw(Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        int n5;
        int n6;
        Object object;
        int n7;
        int n8;
        int n9;
        XYMultipleSeriesRenderer.Orientation orientation;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        int n10 = this.mRenderer.getLegendHeight();
        if (this.mRenderer.isShowLegend() && n10 == 0) {
            n10 = n4 / 5;
        }
        int[] nArray = this.mRenderer.getMargins();
        int n11 = n + nArray[1];
        int n12 = n2 + nArray[0];
        int n13 = n + n3 - nArray[3];
        int n14 = n2 + n4 - nArray[2] - n10;
        if (this.screenR == null) {
            this.screenR = new Rect();
        }
        this.screenR.set(n11, n12, n13, n14);
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, n4, paint, false, 0);
        if (paint.getTypeface() == null || !paint.getTypeface().toString().equals(this.mRenderer.getTextTypefaceName()) || paint.getTypeface().getStyle() != this.mRenderer.getTextTypefaceStyle()) {
            paint.setTypeface(Typeface.create((String)this.mRenderer.getTextTypefaceName(), (int)this.mRenderer.getTextTypefaceStyle()));
        }
        if ((orientation = this.mRenderer.getOrientation()) == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            n13 -= n10;
            n14 += n10 - 20;
        }
        boolean bl = (n9 = orientation.getAngle()) == 90;
        this.mScale = (float)n4 / (float)n3;
        this.mTranslate = Math.abs(n3 - n4) / 2;
        if (this.mScale < 1.0f) {
            this.mTranslate *= -1.0f;
        }
        this.mCenter = new PointF((float)((n + n3) / 2), (float)((n2 + n4) / 2));
        if (bl) {
            this.transform(canvas, n9, false);
        }
        double d = this.mRenderer.getXAxisMin();
        double d2 = this.mRenderer.getXAxisMax();
        double d3 = this.mRenderer.getYAxisMin();
        double d4 = this.mRenderer.getYAxisMax();
        boolean bl2 = this.mRenderer.isMinXSet();
        boolean bl3 = this.mRenderer.isMaxXSet();
        boolean bl4 = this.mRenderer.isMinYSet();
        boolean bl5 = this.mRenderer.isMaxYSet();
        double d5 = 0.0;
        double d6 = 0.0;
        int n15 = this.mDataset.getSeriesCount();
        String[] stringArray = new String[n15];
        for (n8 = 0; n8 < n15; ++n8) {
            double d7;
            XYSeries xYSeries = this.mDataset.getSeriesAt(n8);
            stringArray[n8] = xYSeries.getTitle();
            if (xYSeries.getItemCount() == 0) continue;
            if (!bl2) {
                d7 = xYSeries.getMinX();
                this.calcRange[0] = d = Math.min(d, d7);
            }
            if (!bl3) {
                d7 = xYSeries.getMaxX();
                this.calcRange[1] = d2 = Math.max(d2, d7);
            }
            if (!bl4) {
                d7 = xYSeries.getMinY();
                this.calcRange[2] = d3 = Math.min(d3, (double)((float)d7));
            }
            if (bl5) continue;
            d7 = xYSeries.getMaxY();
            this.calcRange[3] = d4 = Math.max(d4, (double)((float)d7));
        }
        if (d2 - d != 0.0) {
            d5 = (double)(n13 - n11) / (d2 - d);
        }
        if (d4 - d3 != 0.0) {
            d6 = (float)((double)(n14 - n12) / (d4 - d3));
        }
        n8 = 0;
        for (n7 = 0; n7 < n15; ++n7) {
            int n16;
            XYSeries xYSeries = this.mDataset.getSeriesAt(n7);
            if (xYSeries.getItemCount() == 0) continue;
            n8 = 1;
            object = this.mRenderer.getSeriesRendererAt(n7);
            n6 = n16 = xYSeries.getItemCount();
            n5 = n6 * 2;
            ArrayList<Float> arrayList = new ArrayList<Float>();
            for (int i = 0; i < n5; i += 2) {
                int n17 = i / 2;
                double d8 = xYSeries.getY(n17);
                if (d8 != Double.MAX_VALUE) {
                    arrayList.add(Float.valueOf((float)((double)n11 + d5 * (xYSeries.getX(n17) - d))));
                    arrayList.add(Float.valueOf((float)((double)n14 - d6 * (d8 - d3))));
                    continue;
                }
                if (arrayList.size() <= 0) continue;
                this.drawSeries(xYSeries, canvas, paint, arrayList, (SimpleSeriesRenderer)object, Math.min((float)n14, (float)((double)n14 + d6 * d3)), n7, orientation);
                arrayList.clear();
            }
            if (arrayList.size() <= 0) continue;
            this.drawSeries(xYSeries, canvas, paint, arrayList, (SimpleSeriesRenderer)object, Math.min((float)n14, (float)((double)n14 + d6 * d3)), n7, orientation);
        }
        this.drawBackground(this.mRenderer, canvas, n, n14, n3, n4 - n14, paint, true, this.mRenderer.getMarginsColor());
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, nArray[0], paint, true, this.mRenderer.getMarginsColor());
        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawBackground(this.mRenderer, canvas, n, n2, n11 - n, n4 - n2, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, n13, n2, nArray[3], n4 - n2, paint, true, this.mRenderer.getMarginsColor());
        } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.drawBackground(this.mRenderer, canvas, n13, n2, n3 - n13, n4 - n2, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, n, n2, n11 - n, n4 - n2, paint, true, this.mRenderer.getMarginsColor());
        }
        n7 = this.mRenderer.isShowLabels() && n8 != 0 ? 1 : 0;
        boolean bl6 = this.mRenderer.isShowGrid();
        if (n7 != 0 || bl6) {
            object = this.getValidLabels(MathHelper.getLabels(d, d2, this.mRenderer.getXLabels()));
            List<Double> list = this.getValidLabels(MathHelper.getLabels(d3, d4, this.mRenderer.getYLabels()));
            n6 = n11;
            if (n7 != 0) {
                paint.setColor(this.mRenderer.getLabelsColor());
                paint.setTextSize(this.mRenderer.getLabelsTextSize());
                paint.setTextAlign(this.mRenderer.getXLabelsAlign());
                if (this.mRenderer.getXLabelsAlign() == Paint.Align.LEFT) {
                    n6 = (int)((float)n6 + this.mRenderer.getLabelsTextSize() / 4.0f);
                }
            }
            this.drawXLabels((List<Double>)object, this.mRenderer.getXTextLabelLocations(), canvas, paint, n6, n12, n14, d5, d);
            paint.setTextAlign(this.mRenderer.getYLabelsAlign());
            n5 = list.size();
            for (int i = 0; i < n5; ++i) {
                double d9 = list.get(i);
                float f = (float)((double)n14 - d6 * (d9 - d3));
                if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    if (n7 != 0) {
                        paint.setColor(this.mRenderer.getLabelsColor());
                        canvas.drawLine((float)(n11 - 4), f, (float)n11, f, paint);
                        this.drawText(canvas, this.getLabel(d9), n11 - 2, f - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                    }
                    if (!bl6) continue;
                    paint.setColor(this.mRenderer.getGridColor());
                    canvas.drawLine((float)n11, f, (float)n13, f, paint);
                    continue;
                }
                if (orientation != XYMultipleSeriesRenderer.Orientation.VERTICAL) continue;
                if (n7 != 0) {
                    paint.setColor(this.mRenderer.getLabelsColor());
                    canvas.drawLine((float)(n13 + 4), f, (float)n13, f, paint);
                    this.drawText(canvas, this.getLabel(d9), n13 + 10, f - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                }
                if (!bl6) continue;
                paint.setColor(this.mRenderer.getGridColor());
                canvas.drawLine((float)n13, f, (float)n11, f, paint);
            }
            if (n7 != 0) {
                paint.setColor(this.mRenderer.getLabelsColor());
                float f = this.mRenderer.getAxisTitleTextSize();
                paint.setTextSize(f);
                paint.setTextAlign(Paint.Align.CENTER);
                if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), n + n3 / 2, (float)n14 + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f + f, paint, 0.0f);
                    this.drawText(canvas, this.mRenderer.getYTitle(), (float)n + f, n2 + n4 / 2, paint, -90.0f);
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), n + n3 / 2, (float)n2 + this.mRenderer.getChartTitleTextSize(), paint, 0.0f);
                } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), n + n3 / 2, (float)(n2 + n4) - f, paint, -90.0f);
                    this.drawText(canvas, this.mRenderer.getYTitle(), n13 + 20, n2 + n4 / 2, paint, 0.0f);
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), (float)n + f, n12 + n4 / 2, paint, 0.0f);
                }
            }
        }
        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawLegend(canvas, this.mRenderer, stringArray, n11, n13, n2, n3, n4, n10, paint);
        } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.transform(canvas, n9, true);
            this.drawLegend(canvas, this.mRenderer, stringArray, n11, n13, n2, n3, n4, n10, paint);
            this.transform(canvas, n9, false);
        }
        if (this.mRenderer.isShowAxes()) {
            paint.setColor(this.mRenderer.getAxesColor());
            canvas.drawLine((float)n11, (float)n14, (float)n13, (float)n14, paint);
            if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                canvas.drawLine((float)n11, (float)n12, (float)n11, (float)n14, paint);
            } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                canvas.drawLine((float)n13, (float)n12, (float)n13, (float)n14, paint);
            }
        }
        if (bl) {
            this.transform(canvas, n9, true);
        }
    }

    private List<Double> getValidLabels(List<Double> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>(list);
        for (Double d : list) {
            if (!d.isNaN()) continue;
            arrayList.remove(d);
        }
        return arrayList;
    }

    private void drawSeries(XYSeries xYSeries, Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, XYMultipleSeriesRenderer.Orientation orientation) {
        ScatterChart scatterChart;
        float[] fArray = MathHelper.getFloats(list);
        this.drawSeries(canvas, paint, fArray, simpleSeriesRenderer, f, n);
        if (this.isRenderPoints(simpleSeriesRenderer) && (scatterChart = this.getPointsChart()) != null) {
            scatterChart.drawSeries(canvas, paint, fArray, simpleSeriesRenderer, 0.0f, n);
        }
        paint.setTextSize(this.mRenderer.getChartValuesTextSize());
        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            paint.setTextAlign(Paint.Align.CENTER);
        } else {
            paint.setTextAlign(Paint.Align.LEFT);
        }
        if (this.mRenderer.isDisplayChartValues()) {
            this.drawChartValuesText(canvas, xYSeries, paint, fArray, n);
        }
    }

    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, Paint paint, float[] fArray, int n) {
        for (int i = 0; i < fArray.length; i += 2) {
            this.drawText(canvas, this.getLabel(xYSeries.getY(i / 2)), fArray[i], fArray[i + 1] - 3.5f, paint, 0.0f);
        }
    }

    protected void drawText(Canvas canvas, String string, float f, float f2, Paint paint, float f3) {
        float f4 = (float)(-this.mRenderer.getOrientation().getAngle()) + f3;
        if (f4 != 0.0f) {
            canvas.rotate(f4, f, f2);
        }
        canvas.drawText(string, f, f2, paint);
        if (f4 != 0.0f) {
            canvas.rotate(-f4, f, f2);
        }
    }

    private void transform(Canvas canvas, float f, boolean bl) {
        if (bl) {
            canvas.scale(1.0f / this.mScale, this.mScale);
            canvas.translate(this.mTranslate, -this.mTranslate);
            canvas.rotate(-f, this.mCenter.x, this.mCenter.y);
        } else {
            canvas.rotate(f, this.mCenter.x, this.mCenter.y);
            canvas.translate(-this.mTranslate, this.mTranslate);
            canvas.scale(this.mScale, 1.0f / this.mScale);
        }
    }

    protected String getLabel(double d) {
        String string = "";
        string = d == (double)Math.round(d) ? Math.round(d) + "" : d + "";
        return string;
    }

    protected void drawXLabels(List<Double> list, Double[] doubleArray, Canvas canvas, Paint paint, int n, int n2, int n3, double d, double d2) {
        int n4 = list.size();
        boolean bl = this.mRenderer.isShowLabels();
        boolean bl2 = this.mRenderer.isShowGrid();
        for (int i = 0; i < n4; ++i) {
            double d3 = list.get(i);
            float f = (float)((double)n + d * (d3 - d2));
            if (bl) {
                paint.setColor(this.mRenderer.getLabelsColor());
                canvas.drawLine(f, (float)n3, f, (float)n3 + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                this.drawText(canvas, this.getLabel(d3), f, (float)n3 + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f, paint, this.mRenderer.getXLabelsAngle());
            }
            if (!bl2) continue;
            paint.setColor(this.mRenderer.getGridColor());
            canvas.drawLine(f, (float)n3, f, (float)n2, paint);
        }
        if (bl) {
            paint.setColor(this.mRenderer.getLabelsColor());
            for (Double d4 : doubleArray) {
                float f = (float)((double)n + d * (d4 - d2));
                canvas.drawLine(f, (float)n3, f, (float)(n3 + 4), paint);
                this.drawText(canvas, this.mRenderer.getXTextLabel(d4), f, (float)n3 + this.mRenderer.getLabelsTextSize(), paint, this.mRenderer.getXLabelsAngle());
            }
        }
    }

    public XYMultipleSeriesRenderer getRenderer() {
        return this.mRenderer;
    }

    public XYMultipleSeriesDataset getDataset() {
        return this.mDataset;
    }

    public double[] getCalcRange() {
        return this.calcRange;
    }

    public PointF toRealPoint(float f, float f2) {
        double d = this.mRenderer.getXAxisMin();
        double d2 = this.mRenderer.getXAxisMax();
        double d3 = this.mRenderer.getYAxisMin();
        double d4 = this.mRenderer.getYAxisMax();
        return new PointF((float)((double)(f - (float)this.screenR.left) * (d2 - d) / (double)this.screenR.width() + d), (float)((double)((float)(this.screenR.top + this.screenR.height()) - f2) * (d4 - d3) / (double)this.screenR.height() + d3));
    }

    public PointF toScreenPoint(PointF pointF) {
        double d = this.mRenderer.getXAxisMin();
        double d2 = this.mRenderer.getXAxisMax();
        double d3 = this.mRenderer.getYAxisMin();
        double d4 = this.mRenderer.getYAxisMax();
        return new PointF((float)(((double)pointF.x - d) * (double)this.screenR.width() / (d2 - d) + (double)this.screenR.left), (float)((d4 - (double)pointF.y) * (double)this.screenR.height() / (d4 - d3) + (double)this.screenR.top));
    }

    public abstract void drawSeries(Canvas var1, Paint var2, float[] var3, SimpleSeriesRenderer var4, float var5, int var6);

    public boolean isRenderPoints(SimpleSeriesRenderer simpleSeriesRenderer) {
        return false;
    }

    public double getDefaultMinimum() {
        return Double.MAX_VALUE;
    }

    public ScatterChart getPointsChart() {
        return null;
    }
}

