/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.bytestreams.BytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Data;
import org.jivesoftware.smackx.bytestreams.ibb.packet.DataPacketExtension;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.packet.SyncPacketSend;

public class InBandBytestreamSession
implements BytestreamSession {
    private final Connection connection;
    private final Open byteStreamRequest;
    private IBBInputStream inputStream;
    private IBBOutputStream outputStream;
    private String remoteJID;
    private boolean closeBothStreamsEnabled = false;
    private boolean isClosed = false;

    protected InBandBytestreamSession(Connection connection, Open open, String string) {
        this.connection = connection;
        this.byteStreamRequest = open;
        this.remoteJID = string;
        switch (open.getStanza()) {
            case IQ: {
                this.inputStream = new IQIBBInputStream();
                this.outputStream = new IQIBBOutputStream();
                break;
            }
            case MESSAGE: {
                this.inputStream = new MessageIBBInputStream();
                this.outputStream = new MessageIBBOutputStream();
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public int getReadTimeout() {
        return this.inputStream.readTimeout;
    }

    public void setReadTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        this.inputStream.readTimeout = n;
    }

    public boolean isCloseBothStreamsEnabled() {
        return this.closeBothStreamsEnabled;
    }

    public void setCloseBothStreamsEnabled(boolean bl) {
        this.closeBothStreamsEnabled = bl;
    }

    public void close() throws IOException {
        this.closeByLocal(true);
        this.closeByLocal(false);
    }

    protected void closeByPeer(Close close) {
        this.inputStream.closeInternal();
        this.inputStream.cleanup();
        this.outputStream.closeInternal(false);
        IQ iQ = IQ.createResultIQ(close);
        this.connection.sendPacket(iQ);
    }

    protected synchronized void closeByLocal(boolean bl) throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.closeBothStreamsEnabled) {
            this.inputStream.closeInternal();
            this.outputStream.closeInternal(true);
        } else if (bl) {
            this.inputStream.closeInternal();
        } else {
            this.outputStream.closeInternal(true);
        }
        if (this.inputStream.isClosed && this.outputStream.isClosed) {
            this.isClosed = true;
            Close close = new Close(this.byteStreamRequest.getSessionID());
            close.setTo(this.remoteJID);
            try {
                SyncPacketSend.getReply(this.connection, close);
            }
            catch (XMPPException xMPPException) {
                throw new IOException("Error while closing stream: " + xMPPException.getMessage());
            }
            this.inputStream.cleanup();
            InBandBytestreamManager.getByteStreamManager(this.connection).getSessions().remove(this);
        }
    }

    private class MessageIBBOutputStream
    extends IBBOutputStream {
        private MessageIBBOutputStream() {
        }

        protected synchronized void writeToXML(DataPacketExtension dataPacketExtension) {
            Message message = new Message(InBandBytestreamSession.this.remoteJID);
            message.addExtension(dataPacketExtension);
            InBandBytestreamSession.this.connection.sendPacket(message);
        }
    }

    private class IQIBBOutputStream
    extends IBBOutputStream {
        private IQIBBOutputStream() {
        }

        protected synchronized void writeToXML(DataPacketExtension dataPacketExtension) throws IOException {
            block2: {
                Data data = new Data(dataPacketExtension);
                data.setTo(InBandBytestreamSession.this.remoteJID);
                try {
                    SyncPacketSend.getReply(InBandBytestreamSession.this.connection, data);
                }
                catch (XMPPException xMPPException) {
                    if (this.isClosed) break block2;
                    InBandBytestreamSession.this.close();
                    throw new IOException("Error while sending Data: " + xMPPException.getMessage());
                }
            }
        }
    }

    private abstract class IBBOutputStream
    extends OutputStream {
        protected final byte[] buffer;
        protected int bufferPointer = 0;
        protected long seq = 0L;
        protected boolean isClosed = false;

        public IBBOutputStream() {
            this.buffer = new byte[InBandBytestreamSession.this.byteStreamRequest.getBlockSize()];
        }

        protected abstract void writeToXML(DataPacketExtension var1) throws IOException;

        public synchronized void write(int n) throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            if (this.bufferPointer >= this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.bufferPointer++] = (byte)n;
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            if (n2 >= this.buffer.length) {
                this.writeOut(byArray, n, this.buffer.length);
                this.write(byArray, n + this.buffer.length, n2 - this.buffer.length);
            } else {
                this.writeOut(byArray, n, n2);
            }
        }

        public synchronized void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        private synchronized void writeOut(byte[] byArray, int n, int n2) throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            int n3 = 0;
            if (n2 > this.buffer.length - this.bufferPointer) {
                n3 = this.buffer.length - this.bufferPointer;
                System.arraycopy(byArray, n, this.buffer, this.bufferPointer, n3);
                this.bufferPointer += n3;
                this.flushBuffer();
            }
            System.arraycopy(byArray, n + n3, this.buffer, this.bufferPointer, n2 - n3);
            this.bufferPointer += n2 - n3;
        }

        public synchronized void flush() throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            this.flushBuffer();
        }

        private synchronized void flushBuffer() throws IOException {
            if (this.bufferPointer == 0) {
                return;
            }
            String string = StringUtils.encodeBase64(this.buffer, 0, this.bufferPointer, false);
            DataPacketExtension dataPacketExtension = new DataPacketExtension(InBandBytestreamSession.this.byteStreamRequest.getSessionID(), this.seq, string);
            this.writeToXML(dataPacketExtension);
            this.bufferPointer = 0;
            this.seq = this.seq + 1L == 65535L ? 0L : this.seq + 1L;
        }

        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            InBandBytestreamSession.this.closeByLocal(false);
        }

        protected void closeInternal(boolean bl) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            try {
                if (bl) {
                    this.flushBuffer();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class IBBDataPacketFilter
    implements PacketFilter {
        private IBBDataPacketFilter() {
        }

        public boolean accept(Packet packet) {
            if (!packet.getFrom().equalsIgnoreCase(InBandBytestreamSession.this.remoteJID)) {
                return false;
            }
            PacketExtension packetExtension = packet.getExtension("data", "http://jabber.org/protocol/ibb");
            if (packetExtension == null || !(packetExtension instanceof DataPacketExtension)) {
                return false;
            }
            DataPacketExtension dataPacketExtension = (DataPacketExtension)packetExtension;
            return dataPacketExtension.getSessionID().equals(InBandBytestreamSession.this.byteStreamRequest.getSessionID());
        }
    }

    private class MessageIBBInputStream
    extends IBBInputStream {
        private MessageIBBInputStream() {
        }

        protected PacketListener getDataPacketListener() {
            return new PacketListener(){

                public void processPacket(Packet packet) {
                    DataPacketExtension dataPacketExtension = (DataPacketExtension)packet.getExtension("data", "http://jabber.org/protocol/ibb");
                    if (dataPacketExtension.getDecodedData() == null) {
                        return;
                    }
                    MessageIBBInputStream.this.dataQueue.offer(dataPacketExtension);
                }
            };
        }

        protected PacketFilter getDataPacketFilter() {
            return new AndFilter(new PacketTypeFilter(Message.class), new IBBDataPacketFilter());
        }
    }

    private class IQIBBInputStream
    extends IBBInputStream {
        private IQIBBInputStream() {
        }

        protected PacketListener getDataPacketListener() {
            return new PacketListener(){
                private long lastSequence = -1L;

                public void processPacket(Packet packet) {
                    DataPacketExtension dataPacketExtension = (DataPacketExtension)packet.getExtension("data", "http://jabber.org/protocol/ibb");
                    if (dataPacketExtension.getSeq() <= this.lastSequence) {
                        IQ iQ = IQ.createErrorResponse((IQ)packet, new XMPPError(XMPPError.Condition.unexpected_request));
                        InBandBytestreamSession.this.connection.sendPacket(iQ);
                        return;
                    }
                    if (dataPacketExtension.getDecodedData() == null) {
                        IQ iQ = IQ.createErrorResponse((IQ)packet, new XMPPError(XMPPError.Condition.bad_request));
                        InBandBytestreamSession.this.connection.sendPacket(iQ);
                        return;
                    }
                    IQIBBInputStream.this.dataQueue.offer(dataPacketExtension);
                    IQ iQ = IQ.createResultIQ((IQ)packet);
                    InBandBytestreamSession.this.connection.sendPacket(iQ);
                    this.lastSequence = dataPacketExtension.getSeq();
                    if (this.lastSequence == 65535L) {
                        this.lastSequence = -1L;
                    }
                }
            };
        }

        protected PacketFilter getDataPacketFilter() {
            return new AndFilter(new PacketTypeFilter(Data.class), new IBBDataPacketFilter());
        }
    }

    private abstract class IBBInputStream
    extends InputStream {
        private final PacketListener dataPacketListener;
        protected final BlockingQueue<DataPacketExtension> dataQueue = new LinkedBlockingQueue<DataPacketExtension>();
        private byte[] buffer;
        private int bufferPointer = -1;
        private long seq = -1L;
        private boolean isClosed = false;
        private boolean closeInvoked = false;
        private int readTimeout = 0;

        public IBBInputStream() {
            this.dataPacketListener = this.getDataPacketListener();
            InBandBytestreamSession.this.connection.addPacketListener(this.dataPacketListener, this.getDataPacketFilter());
        }

        protected abstract PacketListener getDataPacketListener();

        protected abstract PacketFilter getDataPacketFilter();

        public synchronized int read() throws IOException {
            this.checkClosed();
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBuffer())) {
                return -1;
            }
            return this.buffer[this.bufferPointer++];
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            this.checkClosed();
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBuffer())) {
                return -1;
            }
            int n3 = this.buffer.length - this.bufferPointer;
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(this.buffer, this.bufferPointer, byArray, n, n2);
            this.bufferPointer += n2;
            return n2;
        }

        public synchronized int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        private synchronized boolean loadBuffer() throws IOException {
            long l;
            DataPacketExtension dataPacketExtension = null;
            try {
                if (this.readTimeout == 0) {
                    while (dataPacketExtension == null) {
                        if (this.isClosed && this.dataQueue.isEmpty()) {
                            return false;
                        }
                        dataPacketExtension = this.dataQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    }
                } else {
                    dataPacketExtension = this.dataQueue.poll(this.readTimeout, TimeUnit.MILLISECONDS);
                    if (dataPacketExtension == null) {
                        throw new SocketTimeoutException();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
            if (this.seq == 65535L) {
                this.seq = -1L;
            }
            if ((l = dataPacketExtension.getSeq()) - 1L != this.seq) {
                InBandBytestreamSession.this.close();
                throw new IOException("Packets out of sequence");
            }
            this.seq = l;
            this.buffer = dataPacketExtension.getDecodedData();
            this.bufferPointer = 0;
            return true;
        }

        private void checkClosed() throws IOException {
            if (this.isClosed && this.dataQueue.isEmpty() || this.closeInvoked) {
                this.dataQueue.clear();
                throw new IOException("Stream is closed");
            }
        }

        public boolean markSupported() {
            return false;
        }

        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            this.closeInvoked = true;
            InBandBytestreamSession.this.closeByLocal(true);
        }

        private void closeInternal() {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }

        private void cleanup() {
            InBandBytestreamSession.this.connection.removePacketListener(this.dataPacketListener);
        }
    }
}

