/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.InitiationListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.SyncPacketSend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Socks5BytestreamManager
implements BytestreamManager {
    public static final String NAMESPACE = "http://jabber.org/protocol/bytestreams";
    private static final String SESSION_ID_PREFIX = "js5_";
    private static final Random randomGenerator;
    private static final Map<Connection, Socks5BytestreamManager> managers;
    private final Connection connection;
    private final Map<String, BytestreamListener> userListeners = new ConcurrentHashMap<String, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private int targetResponseTimeout = 10000;
    private int proxyConnectionTimeout = 10000;
    private final List<String> proxyBlacklist = Collections.synchronizedList(new LinkedList());
    private String lastWorkingProxy = null;
    private boolean proxyPrioritizationEnabled = true;
    private List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    public static synchronized Socks5BytestreamManager getBytestreamManager(Connection connection) {
        if (connection == null) {
            return null;
        }
        Socks5BytestreamManager socks5BytestreamManager = managers.get(connection);
        if (socks5BytestreamManager == null) {
            socks5BytestreamManager = new Socks5BytestreamManager(connection);
            managers.put(connection, socks5BytestreamManager);
            socks5BytestreamManager.activate();
        }
        return socks5BytestreamManager;
    }

    private Socks5BytestreamManager(Connection connection) {
        this.connection = connection;
        this.initiationListener = new InitiationListener(this);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener bytestreamListener) {
        this.allRequestListeners.add(bytestreamListener);
    }

    @Override
    public void removeIncomingBytestreamListener(BytestreamListener bytestreamListener) {
        this.allRequestListeners.remove(bytestreamListener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener bytestreamListener, String string) {
        this.userListeners.put(string, bytestreamListener);
    }

    @Override
    public void removeIncomingBytestreamListener(String string) {
        this.userListeners.remove(string);
    }

    public void ignoreBytestreamRequestOnce(String string) {
        this.ignoredBytestreamRequests.add(string);
    }

    public synchronized void disableService() {
        ServiceDiscoveryManager serviceDiscoveryManager;
        this.connection.removePacketListener(this.initiationListener);
        this.initiationListener.shutdown();
        this.allRequestListeners.clear();
        this.userListeners.clear();
        this.lastWorkingProxy = null;
        this.proxyBlacklist.clear();
        this.ignoredBytestreamRequests.clear();
        managers.remove(this.connection);
        if (managers.size() == 0) {
            Socks5Proxy.getSocks5Proxy().stop();
        }
        if ((serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection)) != null) {
            serviceDiscoveryManager.removeFeature(NAMESPACE);
        }
    }

    public int getTargetResponseTimeout() {
        if (this.targetResponseTimeout <= 0) {
            this.targetResponseTimeout = 10000;
        }
        return this.targetResponseTimeout;
    }

    public void setTargetResponseTimeout(int n) {
        this.targetResponseTimeout = n;
    }

    public int getProxyConnectionTimeout() {
        if (this.proxyConnectionTimeout <= 0) {
            this.proxyConnectionTimeout = 10000;
        }
        return this.proxyConnectionTimeout;
    }

    public void setProxyConnectionTimeout(int n) {
        this.proxyConnectionTimeout = n;
    }

    public boolean isProxyPrioritizationEnabled() {
        return this.proxyPrioritizationEnabled;
    }

    public void setProxyPrioritizationEnabled(boolean bl) {
        this.proxyPrioritizationEnabled = bl;
    }

    @Override
    public Socks5BytestreamSession establishSession(String string) throws XMPPException, IOException, InterruptedException {
        String string2 = this.getNextSessionID();
        return this.establishSession(string, string2);
    }

    @Override
    public Socks5BytestreamSession establishSession(String string, String string2) throws XMPPException, IOException, InterruptedException {
        Object object;
        if (!this.supportsSocks5(string)) {
            throw new XMPPException(string + " doesn't support SOCKS5 Bytestream");
        }
        List<String> list = this.determineProxies();
        List<Bytestream.StreamHost> list2 = this.determineStreamHostInfos(list);
        String string3 = Socks5Utils.createDigest(string2, this.connection.getUser(), string);
        if (list2.isEmpty()) {
            throw new XMPPException("no SOCKS5 proxies available");
        }
        if (this.proxyPrioritizationEnabled && this.lastWorkingProxy != null) {
            object = null;
            for (Bytestream.StreamHost object2 : list2) {
                if (!object2.getJID().equals(this.lastWorkingProxy)) continue;
                object = object2;
                break;
            }
            if (object != null) {
                list2.remove(object);
                list2.add(0, (Bytestream.StreamHost)object);
            }
        }
        object = Socks5Proxy.getSocks5Proxy();
        try {
            ((Socks5Proxy)object).addTransfer(string3);
            Bytestream bytestream = this.createBytestreamInitiation(string2, string, list2);
            Packet packet = SyncPacketSend.getReply(this.connection, bytestream, this.getTargetResponseTimeout());
            Bytestream.StreamHostUsed streamHostUsed = ((Bytestream)packet).getUsedHost();
            Bytestream.StreamHost streamHost = bytestream.getStreamHost(streamHostUsed.getJID());
            if (streamHost == null) {
                throw new XMPPException("Remote user responded with unknown host");
            }
            Socks5ClientForInitiator socks5ClientForInitiator = new Socks5ClientForInitiator(streamHost, string3, this.connection, string2, string);
            Socket socket = ((Socks5Client)socks5ClientForInitiator).getSocket(this.getProxyConnectionTimeout());
            this.lastWorkingProxy = streamHost.getJID();
            Socks5BytestreamSession socks5BytestreamSession = new Socks5BytestreamSession(socket, streamHost.getJID().equals(this.connection.getUser()));
            return socks5BytestreamSession;
        }
        catch (TimeoutException timeoutException) {
            throw new IOException("Timeout while connecting to SOCKS5 proxy");
        }
        finally {
            ((Socks5Proxy)object).removeTransfer(string3);
        }
    }

    private boolean supportsSocks5(String string) throws XMPPException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        DiscoverInfo discoverInfo = serviceDiscoveryManager.discoverInfo(string);
        return discoverInfo.containsFeature(NAMESPACE);
    }

    private List<String> determineProxies() throws XMPPException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        ArrayList<String> arrayList = new ArrayList<String>();
        DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(this.connection.getServiceName());
        Iterator<DiscoverItems.Item> iterator = discoverItems.getItems();
        block2: while (iterator.hasNext()) {
            DiscoverItems.Item item = iterator.next();
            if (this.proxyBlacklist.contains(item.getEntityID())) continue;
            try {
                DiscoverInfo discoverInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
                Iterator<DiscoverInfo.Identity> iterator2 = discoverInfo.getIdentities();
                while (iterator2.hasNext()) {
                    DiscoverInfo.Identity identity = iterator2.next();
                    if ("proxy".equalsIgnoreCase(identity.getCategory()) && "bytestreams".equalsIgnoreCase(identity.getType())) {
                        arrayList.add(item.getEntityID());
                        continue block2;
                    }
                    this.proxyBlacklist.add(item.getEntityID());
                }
            }
            catch (XMPPException xMPPException) {
                this.proxyBlacklist.add(item.getEntityID());
            }
        }
        return arrayList;
    }

    private List<Bytestream.StreamHost> determineStreamHostInfos(List<String> list) {
        ArrayList<Bytestream.StreamHost> arrayList = new ArrayList<Bytestream.StreamHost>();
        List<Bytestream.StreamHost> list2 = this.getLocalStreamHost();
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        for (String string : list) {
            Bytestream bytestream = this.createStreamHostRequest(string);
            try {
                Bytestream bytestream2 = (Bytestream)SyncPacketSend.getReply(this.connection, bytestream);
                arrayList.addAll(bytestream2.getStreamHosts());
            }
            catch (XMPPException xMPPException) {
                this.proxyBlacklist.add(string);
            }
        }
        return arrayList;
    }

    private Bytestream createStreamHostRequest(String string) {
        Bytestream bytestream = new Bytestream();
        bytestream.setType(IQ.Type.GET);
        bytestream.setTo(string);
        return bytestream;
    }

    private List<Bytestream.StreamHost> getLocalStreamHost() {
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        if (socks5Proxy.isRunning()) {
            List<String> list = socks5Proxy.getLocalAddresses();
            int n = socks5Proxy.getPort();
            if (list.size() >= 1) {
                ArrayList<Bytestream.StreamHost> arrayList = new ArrayList<Bytestream.StreamHost>();
                for (String string : list) {
                    Bytestream.StreamHost streamHost = new Bytestream.StreamHost(this.connection.getUser(), string);
                    streamHost.setPort(n);
                    arrayList.add(streamHost);
                }
                return arrayList;
            }
        }
        return null;
    }

    private Bytestream createBytestreamInitiation(String string, String string2, List<Bytestream.StreamHost> list) {
        Bytestream bytestream = new Bytestream(string);
        for (Bytestream.StreamHost streamHost : list) {
            bytestream.addStreamHost(streamHost);
        }
        bytestream.setType(IQ.Type.SET);
        bytestream.setTo(string2);
        return bytestream;
    }

    protected void replyRejectPacket(IQ iQ) {
        XMPPError xMPPError = new XMPPError(XMPPError.Condition.no_acceptable);
        IQ iQ2 = IQ.createErrorResponse(iQ, xMPPError);
        this.connection.sendPacket(iQ2);
    }

    private void activate() {
        this.connection.addPacketListener(this.initiationListener, this.initiationListener.getFilter());
        this.enableService();
    }

    private void enableService() {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        if (!serviceDiscoveryManager.includesFeature(NAMESPACE)) {
            serviceDiscoveryManager.addFeature(NAMESPACE);
        }
    }

    private String getNextSessionID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SESSION_ID_PREFIX);
        stringBuilder.append(Math.abs(randomGenerator.nextLong()));
        return stringBuilder.toString();
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected BytestreamListener getUserListener(String string) {
        return this.userListeners.get(string);
    }

    protected List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    protected List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                final Socks5BytestreamManager socks5BytestreamManager = Socks5BytestreamManager.getBytestreamManager(connection);
                connection.addConnectionListener(new AbstractConnectionListener(){

                    public void connectionClosed() {
                        socks5BytestreamManager.disableService();
                    }
                });
            }
        });
        randomGenerator = new Random();
        managers = new HashMap<Connection, Socks5BytestreamManager>();
    }
}

