/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.packet.SyncPacketSend;

class Socks5ClientForInitiator
extends Socks5Client {
    private Connection connection;
    private String sessionID;
    private String target;

    public Socks5ClientForInitiator(Bytestream.StreamHost streamHost, String string, Connection connection, String string2, String string3) {
        super(streamHost, string);
        this.connection = connection;
        this.sessionID = string2;
        this.target = string3;
    }

    public Socket getSocket(int n) throws IOException, XMPPException, InterruptedException, TimeoutException {
        Socket socket = null;
        if (this.streamHost.getJID().equals(this.connection.getUser())) {
            Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
            socket = socks5Proxy.getSocket(this.digest);
            if (socket == null) {
                throw new XMPPException("target is not connected to SOCKS5 proxy");
            }
        } else {
            socket = super.getSocket(n);
            try {
                this.activate();
            }
            catch (XMPPException xMPPException) {
                socket.close();
                throw new XMPPException("activating SOCKS5 Bytestream failed", xMPPException);
            }
        }
        return socket;
    }

    private void activate() throws XMPPException {
        Bytestream bytestream = this.createStreamHostActivation();
        SyncPacketSend.getReply(this.connection, bytestream);
    }

    private Bytestream createStreamHostActivation() {
        Bytestream bytestream = new Bytestream(this.sessionID);
        bytestream.setMode(null);
        bytestream.setType(IQ.Type.SET);
        bytestream.setTo(this.streamHost.getJID());
        bytestream.setToActivate(this.target);
        return bytestream;
    }
}

