/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections;

import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.collections.MapEntry4;
import com.db4o.ta.Activatable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMap4<K, V>
implements Map<K, V>,
Serializable,
Cloneable,
Activatable {
    private static final long serialVersionUID = 1L;
    private K[] _keys;
    private V[] _values;
    private int _size;
    private transient Activator _activator;

    public ArrayMap4() {
        this(16);
    }

    public ArrayMap4(int initialCapacity) {
        this.initializeBackingArray(initialCapacity);
    }

    @Override
    public void activate(ActivationPurpose purpose) {
        if (this._activator != null) {
            this._activator.activate(purpose);
        }
    }

    @Override
    public void bind(Activator activator) {
        if (this._activator == activator) {
            return;
        }
        if (activator != null && this._activator != null) {
            throw new IllegalStateException();
        }
        this._activator = activator;
    }

    @Override
    public void clear() {
        this.activate(ActivationPurpose.WRITE);
        this._size = 0;
        Arrays.fill(this._keys, this.defaultKeyValue());
        Arrays.fill(this._values, this.defaultValue());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKeyImpl(key);
    }

    private boolean containsKeyImpl(K key) {
        this.activate(ActivationPurpose.READ);
        return this.indexOfKey(key) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        this.activate(ActivationPurpose.READ);
        return this.indexOf(this._values, value) != -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.activate(ActivationPurpose.READ);
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (int i = 0; i < this._size; ++i) {
            MapEntry4<K, V> entry = new MapEntry4<K, V>(this.keyAt(i), this.valueAt(i));
            set.add(entry);
        }
        return set;
    }

    @Override
    public V get(Object key) {
        this.activate(ActivationPurpose.READ);
        int index = this.indexOfKey(key);
        return index == -1 ? null : (V)this.valueAt(index);
    }

    private V valueAt(int index) {
        return this._values[index];
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        this.activate(ActivationPurpose.READ);
        HashSet<K> set = new HashSet<K>();
        for (int i = 0; i < this._size; ++i) {
            set.add(this.keyAt(i));
        }
        return set;
    }

    private K keyAt(int i) {
        return this._keys[i];
    }

    @Override
    public V put(K key, V value) {
        this.activate(ActivationPurpose.WRITE);
        return this.putInternal(key, value);
    }

    private V putInternal(K key, V value) {
        int index = this.indexOfKey(key);
        if (index == -1) {
            this.insert(key, value);
            return null;
        }
        return this.replace(index, value);
    }

    private int indexOfKey(Object key) {
        return this.indexOf(this._keys, key);
    }

    @Override
    private V replace(int index, V value) {
        V oldValue = this.valueAt(index);
        this._values[index] = value;
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.activate(ActivationPurpose.WRITE);
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        this.activate(ActivationPurpose.READ);
        int index = this.indexOfKey(key);
        if (index == -1) {
            return null;
        }
        return this.delete(index);
    }

    @Override
    public int size() {
        this.activate(ActivationPurpose.READ);
        return this._size;
    }

    @Override
    public Collection<V> values() {
        this.activate(ActivationPurpose.READ);
        ArrayList<V> list = new ArrayList<V>();
        for (int i = 0; i < this._size; ++i) {
            list.add(this.valueAt(i));
        }
        return list;
    }

    public ArrayMap4<K, V> clone() {
        this.activate(ActivationPurpose.READ);
        try {
            ArrayMap4 mapClone = (ArrayMap4)super.clone();
            mapClone._activator = null;
            mapClone._keys = (Object[])this._keys.clone();
            mapClone._values = (Object[])this._values.clone();
            return mapClone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (this.size() != other.size()) {
            return false;
        }
        Set otherKeySet = other.keySet();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            K key = entry.getKey();
            if (!otherKeySet.contains(key)) {
                return false;
            }
            V value = entry.getValue();
            if (value != null ? value.equals(other.get(key)) : other.get(key) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            hashCode += ((Object)entry).hashCode();
        }
        return hashCode;
    }

    private void initializeBackingArray(int length) {
        this._keys = this.allocateKeyStorage(length);
        this._values = this.allocateValueStorage(length);
    }

    private int indexOf(Object[] array, Object obj) {
        int index = -1;
        for (int i = 0; i < this._size; ++i) {
            if (!(array[i] == null ? obj == null : array[i].equals(obj))) continue;
            index = i;
            break;
        }
        return index;
    }

    private void insert(K key, V value) {
        this.ensureCapacity();
        this._keys[this._size] = key;
        this._values[this._size] = value;
        ++this._size;
    }

    private void ensureCapacity() {
        if (this._size == this._keys.length) {
            int count = this._keys.length * 2;
            K[] newKeys = this.allocateKeyStorage(count);
            V[] newValues = this.allocateValueStorage(count);
            System.arraycopy(this._keys, 0, newKeys, 0, this._size);
            System.arraycopy(this._values, 0, newValues, 0, this._size);
            this._keys = newKeys;
            this._values = newValues;
        }
    }

    private V delete(int index) {
        this.activate(ActivationPurpose.WRITE);
        V value = this.valueAt(index);
        for (int i = index; i < this._size - 1; ++i) {
            this._keys[i] = this._keys[i + 1];
            this._values[i] = this._values[i + 1];
        }
        --this._size;
        this._keys[this._size] = this.defaultKeyValue();
        this._values[this._size] = this.defaultValue();
        return value;
    }

    private K defaultKeyValue() {
        return null;
    }

    private V defaultValue() {
        return null;
    }

    private V[] allocateValueStorage(int count) {
        return new Object[count];
    }

    private K[] allocateKeyStorage(int count) {
        return new Object[count];
    }
}

