/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.Db4o;
import com.db4o.config.Configuration;
import com.db4o.defragment.DefragmentConfig;
import com.db4o.defragment.DefragmentInfo;
import com.db4o.defragment.DefragmentListener;
import com.db4o.defragment.DefragmentServices;
import com.db4o.defragment.IDMappingCollector;
import com.db4o.defragment.IdMapping;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.ClassMetadataRepository;
import com.db4o.internal.CommitTimestampSupport;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.ids.FreespaceCommitter;
import com.db4o.internal.ids.IdSlotMapping;
import com.db4o.internal.mapping.IdSource;
import com.db4o.internal.mapping.MappingNotFoundException;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChangeFactory;
import com.db4o.io.FileStorage;
import com.db4o.io.NonFlushingStorage;
import com.db4o.io.Storage;
import com.db4o.typehandlers.TypeHandler4;
import java.io.IOException;

public class DefragmentServicesImpl
implements DefragmentServices {
    public static final DbSelector SOURCEDB = new DbSelector(){

        LocalObjectContainer db(DefragmentServicesImpl context) {
            return context._sourceDb;
        }
    };
    public static final DbSelector TARGETDB = new DbSelector(){

        LocalObjectContainer db(DefragmentServicesImpl context) {
            return context._targetDb;
        }
    };
    private final LocalObjectContainer _sourceDb;
    private final LocalObjectContainer _targetDb;
    private final IdMapping _mapping;
    private DefragmentListener _listener;
    private Queue4 _unindexed = new NonblockingQueue();
    private DefragmentConfig _defragConfig;
    private Hashtable4 _classIndices = new Hashtable4(16);

    public DefragmentServicesImpl(DefragmentConfig defragConfig, DefragmentListener listener) throws IOException {
        this._listener = listener;
        Config4Impl originalConfig = (Config4Impl)defragConfig.db4oConfig();
        Storage storage = defragConfig.backupStorage();
        if (defragConfig.readOnly()) {
            storage = new NonFlushingStorage(storage);
        }
        Config4Impl sourceConfig = this.prepareConfig(originalConfig, storage, defragConfig.readOnly());
        this._sourceDb = (LocalObjectContainer)Db4o.openFile(sourceConfig, defragConfig.tempPath()).ext();
        this._sourceDb.showInternalClasses(true);
        defragConfig.db4oConfig().blockSize(this._sourceDb.blockSize());
        if (!originalConfig.generateCommitTimestamps().definiteNo()) {
            defragConfig.db4oConfig().generateCommitTimestamps(this._sourceDb.config().generateCommitTimestamps().definiteYes());
        }
        this._targetDb = DefragmentServicesImpl.freshTargetFile(defragConfig);
        this._mapping = defragConfig.mapping();
        this._mapping.open();
        this._defragConfig = defragConfig;
    }

    private Config4Impl prepareConfig(Config4Impl originalConfig, Storage storage, boolean readOnly) {
        Config4Impl sourceConfig = (Config4Impl)originalConfig.deepClone(null);
        sourceConfig.weakReferences(false);
        sourceConfig.storage(storage);
        sourceConfig.readOnly(readOnly);
        return sourceConfig;
    }

    static LocalObjectContainer freshTempFile(String fileName, int blockSize) throws IOException {
        FileStorage storage = new FileStorage();
        storage.delete(fileName);
        Configuration db4oConfig = DefragmentConfig.vanillaDb4oConfig(blockSize);
        db4oConfig.objectClass(IdSlotMapping.class).objectField("_id").indexed(true);
        db4oConfig.storage(storage);
        return (LocalObjectContainer)Db4o.openFile(db4oConfig, fileName).ext();
    }

    static LocalObjectContainer freshTargetFile(DefragmentConfig config) throws IOException {
        config.db4oConfig().storage().delete(config.origPath());
        return (LocalObjectContainer)Db4o.openFile(config.clonedDb4oConfig(), config.origPath());
    }

    public int mappedID(int oldID, int defaultID) {
        int mapped = this.internalMappedID(oldID);
        return mapped != 0 ? mapped : defaultID;
    }

    public int strictMappedID(int oldID) throws MappingNotFoundException {
        int mapped = this.internalMappedID(oldID);
        if (mapped == 0) {
            throw new MappingNotFoundException(oldID);
        }
        return mapped;
    }

    public int mappedID(int id) {
        if (id == 0) {
            return 0;
        }
        int mapped = this.internalMappedID(id);
        if (mapped == 0) {
            this._listener.notifyDefragmentInfo(new DefragmentInfo("No mapping found for ID " + id));
            return 1;
        }
        return mapped;
    }

    private int internalMappedID(int oldID) throws MappingNotFoundException {
        if (oldID == 0) {
            return 0;
        }
        int mappedId = this._mapping.mappedId(oldID);
        if (mappedId == 0 && this._sourceDb.handlers().isSystemHandler(oldID)) {
            return oldID;
        }
        return mappedId;
    }

    public void mapIDs(int oldID, int newID, boolean isClassID) {
        this._mapping.mapId(oldID, newID, isClassID);
    }

    public void close() {
        this._sourceDb.close();
        this._targetDb.close();
        this._mapping.close();
    }

    public ByteArrayBuffer bufferByID(DbSelector selector, int id) {
        Slot slot = this.committedSlot(selector, id);
        return this.bufferByAddress(selector, slot.address(), slot.length());
    }

    private Slot committedSlot(DbSelector selector, int id) {
        return selector.db(this).idSystem().committedSlot(id);
    }

    public ByteArrayBuffer sourceBufferByAddress(int address, int length) throws IOException {
        return this.bufferByAddress(SOURCEDB, address, length);
    }

    public ByteArrayBuffer targetBufferByAddress(int address, int length) throws IOException {
        return this.bufferByAddress(TARGETDB, address, length);
    }

    public ByteArrayBuffer bufferByAddress(DbSelector selector, int address, int length) {
        return selector.db(this).decryptedBufferByAddress(address, length);
    }

    public StatefulBuffer targetStatefulBufferByAddress(int address, int length) throws IllegalArgumentException {
        return this._targetDb.readWriterByAddress(TARGETDB.transaction(this), address, length);
    }

    public Slot allocateTargetSlot(int length) {
        return this._targetDb.allocateSlot(length);
    }

    public void targetWriteBytes(DefragmentContextImpl context, int address) {
        context.write(this._targetDb, address);
    }

    public void targetWriteBytes(ByteArrayBuffer reader, int address) {
        this._targetDb.writeBytes(reader, address, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass[] storedClasses(DbSelector selector) {
        LocalObjectContainer db = selector.db(this);
        db.showInternalClasses(true);
        try {
            StoredClass[] storedClassArray = db.classCollection().storedClasses();
            return storedClassArray;
        }
        finally {
            db.showInternalClasses(false);
        }
    }

    public LatinStringIO stringIO() {
        return this._sourceDb.stringIO();
    }

    public void targetCommit() {
        this._targetDb.commit();
    }

    public TypeHandler4 sourceHandler(int id) {
        return this._sourceDb.typeHandlerForClassMetadataID(id);
    }

    public int sourceClassCollectionID() {
        return this._sourceDb.classCollection().getID();
    }

    public int classIndexID(ClassMetadata classMetadata) {
        return this.classIndex(classMetadata).id();
    }

    public void traverseAll(ClassMetadata classMetadata, Visitor4 command) {
        if (!classMetadata.hasClassIndex()) {
            return;
        }
        classMetadata.index().traverseAll(SOURCEDB.transaction(this), command);
    }

    public void traverseAllIndexSlots(ClassMetadata classMetadata, Visitor4 command) {
        Iterator4 slotIDIter = classMetadata.index().allSlotIDs(SOURCEDB.transaction(this));
        while (slotIDIter.moveNext()) {
            command.visit(slotIDIter.current());
        }
    }

    public void traverseAllIndexSlots(BTree btree, Visitor4 command) {
        Iterator4 slotIDIter = btree.allNodeIds(SOURCEDB.transaction(this));
        while (slotIDIter.moveNext()) {
            command.visit(slotIDIter.current());
        }
    }

    public void registerBTreeIDs(BTree btree, final IDMappingCollector collector) {
        collector.createIDMapping(this, btree.getID(), false);
        this.traverseAllIndexSlots(btree, new Visitor4(){

            public void visit(Object obj) {
                int id = (Integer)obj;
                collector.createIDMapping(DefragmentServicesImpl.this, id, false);
            }
        });
    }

    public int databaseIdentityID(DbSelector selector) {
        LocalObjectContainer db = selector.db(this);
        Db4oDatabase identity = db.identity();
        if (identity == null) {
            return 0;
        }
        return identity.getID(selector.transaction(this));
    }

    private ClassIndexStrategy classIndex(ClassMetadata classMetadata) {
        ClassIndexStrategy classIndex = (ClassIndexStrategy)this._classIndices.get(classMetadata);
        if (classIndex == null) {
            classIndex = new BTreeClassIndexStrategy(classMetadata);
            this._classIndices.put(classMetadata, (Object)classIndex);
            classIndex.initialize(this._targetDb);
        }
        return classIndex;
    }

    public Transaction systemTrans() {
        return SOURCEDB.transaction(this);
    }

    public void copyIdentity() {
        this._targetDb.setIdentity(this._sourceDb.identity());
    }

    public void replaceClassMetadataRepository() {
        Transaction systemTransaction = this._targetDb.systemTransaction();
        int newRepositoryId = this._mapping.mappedId(this.sourceClassCollectionID());
        int sourceIdentityID = this.databaseIdentityID(SOURCEDB);
        int targetIdentityID = this._mapping.mappedId(sourceIdentityID);
        int targetUuidIndexID = this._mapping.mappedId(this.sourceUuidIndexID());
        int oldIdentityId = this._targetDb.systemData().identity().getID(systemTransaction);
        int oldRepositoryId = this._targetDb.classCollection().getID();
        ClassMetadataRepository oldRepository = this._targetDb.classCollection();
        ClassMetadataRepository newRepository = new ClassMetadataRepository(systemTransaction);
        newRepository.setID(newRepositoryId);
        newRepository.read(systemTransaction);
        newRepository.initOnUp(systemTransaction);
        this._targetDb.systemData().classCollectionID(newRepositoryId);
        this._targetDb.replaceClassMetadataRepository(newRepository);
        this._targetDb.systemData().uuidIndexId(targetUuidIndexID);
        Db4oDatabase identity = (Db4oDatabase)this._targetDb.getByID(systemTransaction, targetIdentityID);
        this._targetDb.setIdentity(identity);
        ClassMetadataIterator iterator = oldRepository.iterator();
        while (iterator.moveNext()) {
            ClassMetadata classMetadata = iterator.currentClass();
            BTreeClassIndexStrategy index = (BTreeClassIndexStrategy)classMetadata.index();
            index.btree().free(this._targetDb.localSystemTransaction());
            this.freeById(classMetadata.getID());
        }
        this.freeById(oldIdentityId);
        this.freeById(oldRepositoryId);
    }

    public void defragIdToTimestampBtree() {
        if (this._sourceDb.systemData().idToTimestampIndexId() == 0) {
            return;
        }
        final LocalTransaction targetTransaction = (LocalTransaction)this._targetDb.systemTransaction();
        LocalTransaction sourceTransaction = (LocalTransaction)this._sourceDb.systemTransaction();
        final CommitTimestampSupport target = targetTransaction.commitTimestampSupport();
        CommitTimestampSupport source = sourceTransaction.commitTimestampSupport();
        if (source.idToTimestamp() == null) {
            return;
        }
        source.idToTimestamp().traverseKeys(sourceTransaction, new Visitor4<CommitTimestampSupport.TimestampEntry>(){

            @Override
            public void visit(CommitTimestampSupport.TimestampEntry te) {
                int mappedID = DefragmentServicesImpl.this.mappedID(te.parentID());
                target.put(targetTransaction, mappedID, te.getCommitTimestamp());
            }
        });
    }

    private void freeById(int id) {
        this._targetDb.systemTransaction().idSystem().notifySlotDeleted(id, SlotChangeFactory.SYSTEM_OBJECTS);
    }

    public ByteArrayBuffer sourceBufferByID(int sourceID) {
        return this.bufferByID(SOURCEDB, sourceID);
    }

    public BTree sourceUuidIndex() {
        if (this.sourceUuidIndexID() == 0) {
            return null;
        }
        return this._sourceDb.uUIDIndex().getIndex(this.systemTrans());
    }

    public void targetUuidIndexID(int id) {
        this._targetDb.systemData().uuidIndexId(id);
    }

    public int sourceUuidIndexID() {
        return this._sourceDb.systemData().uuidIndexId();
    }

    public int sourceIdToTimestampIndexID() {
        return this._sourceDb.systemData().idToTimestampIndexId();
    }

    public ClassMetadata classMetadataForId(int id) {
        return this._sourceDb.classMetadataForID(id);
    }

    public void registerUnindexed(int id) {
        this._unindexed.add(new Integer(id));
    }

    public IdSource unindexedIDs() {
        return new IdSource(this._unindexed);
    }

    public ObjectHeader sourceObjectHeader(ByteArrayBuffer buffer) {
        return new ObjectHeader(this._sourceDb, (ReadWriteBuffer)buffer);
    }

    public int blockSize() {
        return this._sourceDb.blockSize();
    }

    public int sourceAddressByID(int sourceID) {
        return this.committedSlot(SOURCEDB, sourceID).address();
    }

    public int targetAddressByID(int sourceID) {
        return this._mapping.addressForId(sourceID);
    }

    public boolean accept(StoredClass klass) {
        return this._defragConfig.storedClassFilter().accept(klass);
    }

    public int targetNewId() {
        return this._targetDb.idSystem().newId();
    }

    public IdMapping mapping() {
        return this._mapping;
    }

    public void commitIds() {
        FreespaceCommitter freespaceCommitter = new FreespaceCommitter(this._targetDb.freespaceManager());
        freespaceCommitter.transactionalIdSystem(this.systemTrans().idSystem());
        this._targetDb.idSystem().commit(this.mapping().slotChanges(), freespaceCommitter);
        freespaceCommitter.commit();
    }

    public static abstract class DbSelector {
        DbSelector() {
        }

        abstract LocalObjectContainer db(DefragmentServicesImpl var1);

        Transaction transaction(DefragmentServicesImpl context) {
            return this.db(context).systemTransaction();
        }
    }
}

