/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.defragment.AbstractIdMapping;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitable;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.ids.IdSlotTree;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryIdMapping
extends AbstractIdMapping {
    private IdSlotTree _idsToSlots;
    private Tree _tree;

    @Override
    public int mappedId(int oldID) {
        int classID = this.mappedClassID(oldID);
        if (classID != 0) {
            return classID;
        }
        TreeIntObject res = (TreeIntObject)TreeInt.find(this._tree, oldID);
        if (res != null) {
            return (Integer)res._object;
        }
        return 0;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    protected void mapNonClassIDs(int origID, int mappedID) {
        this._tree = Tree.add(this._tree, new TreeIntObject<Integer>(origID, new Integer(mappedID)));
    }

    @Override
    public int addressForId(int id) {
        IdSlotTree node = (IdSlotTree)this._idsToSlots.find(id);
        if (node == null) {
            throw new IllegalStateException();
        }
        return node.slot().address();
    }

    @Override
    public void mapId(int id, Slot slot) {
        IdSlotTree idSlotMapping = new IdSlotTree(id, slot);
        this._idsToSlots = Tree.add(this._idsToSlots, idSlotMapping);
    }

    @Override
    public Visitable<SlotChange> slotChanges() {
        return new Visitable<SlotChange>(){

            @Override
            public void accept(final Visitor4<SlotChange> outSideVisitor) {
                Tree.traverse(InMemoryIdMapping.this._idsToSlots, new Visitor4<IdSlotTree>(){

                    @Override
                    public void visit(IdSlotTree idSlotMapping) {
                        SlotChange slotChange = new SlotChange(idSlotMapping._key);
                        slotChange.notifySlotCreated(idSlotMapping.slot());
                        outSideVisitor.visit(slotChange);
                    }
                });
            }
        };
    }

    @Override
    public void commit() {
    }
}

