/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.ObjectSet;
import com.db4o.StaticClass;
import com.db4o.StaticField;
import com.db4o.TransactionAware;
import com.db4o.config.ConfigScope;
import com.db4o.config.ObjectTranslator;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.StoredClass;
import com.db4o.ext.StoredField;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.ByRef;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.TernaryBool;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ArrayType;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassAspect;
import com.db4o.internal.CommitTimestampFieldMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Field;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.EventDispatcher;
import com.db4o.internal.EventDispatchers;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.Handlers4;
import com.db4o.internal.ModificationAware;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionContext;
import com.db4o.internal.TranslatedAspect;
import com.db4o.internal.TypeHandlerAspect;
import com.db4o.internal.UUIDFieldMetadata;
import com.db4o.internal.VersionFieldMetadata;
import com.db4o.internal.activation.ActivationContext4;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.internal.activation.UpdateDepth;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.delete.DeleteContextImpl;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.encoding.UnicodeStringIO;
import com.db4o.internal.handlers.HandlerVersion;
import com.db4o.internal.handlers.StandardReferenceTypeHandler;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.marshall.AspectVersionContextImpl;
import com.db4o.internal.marshall.ClassMarshaller;
import com.db4o.internal.marshall.CollectIdContext;
import com.db4o.internal.marshall.ContextState;
import com.db4o.internal.marshall.HandlerVersionContext;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderContext;
import com.db4o.internal.marshall.ObjectIdContextImpl;
import com.db4o.internal.marshall.ObjectReferenceContext;
import com.db4o.internal.marshall.QueryingReadContext;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.metadata.AspectTraversalStrategy;
import com.db4o.internal.metadata.HierarchyAnalyzer;
import com.db4o.internal.metadata.ModifiedAspectTraversalStrategy;
import com.db4o.internal.metadata.StandardAspectTraversalStrategy;
import com.db4o.internal.metadata.TraverseAspectCommand;
import com.db4o.internal.metadata.TraverseFieldCommand;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.reflect.FieldAccessor;
import com.db4o.internal.reflect.LenientFieldAccessor;
import com.db4o.internal.reflect.StrictFieldAccessor;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.query.Query;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.core.ReflectorUtils;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.typehandlers.ActivationContext;
import com.db4o.typehandlers.CascadingTypeHandler;
import com.db4o.typehandlers.InstantiatingTypeHandler;
import com.db4o.typehandlers.TypeHandler4;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMetadata
extends PersistentBase
implements StoredClass {
    protected TypeHandler4 _typeHandler;
    public ClassMetadata _ancestor;
    private Config4Class _config;
    public ClassAspect[] _aspects;
    private ClassIndexStrategy _index;
    private String i_name;
    private final ObjectContainerBase _container;
    byte[] i_nameBytes;
    private ByteArrayBuffer i_reader;
    private boolean _classIndexed;
    private ReflectClass _classReflector;
    private EventDispatcher _eventDispatcher;
    private boolean _internal;
    private boolean _unversioned;
    private TernaryBool _canUpdateFast = TernaryBool.UNSPECIFIED;
    private TranslatedAspect _translator;
    private ModificationAware _modificationChecker = AlwaysModified.INSTANCE;
    private FieldAccessor _fieldAccessor;
    private Function4<UnmarshallingContext, Object> _constructor;
    private TypeHandlerAspect _customTypeHandlerAspect;
    private AspectTraversalStrategy _aspectTraversalStrategy;

    final boolean canUpdateFast() {
        if (this._canUpdateFast == TernaryBool.UNSPECIFIED) {
            this._canUpdateFast = TernaryBool.forBoolean(this.checkCanUpdateFast());
        }
        return this._canUpdateFast.booleanValue(false);
    }

    private final boolean checkCanUpdateFast() {
        if (this._ancestor != null && !this._ancestor.canUpdateFast()) {
            return false;
        }
        if (this._config != null && this._config.cascadeOnDelete() == TernaryBool.YES) {
            return false;
        }
        final BooleanByRef hasIndex = new BooleanByRef(false);
        this.traverseDeclaredFields(new Procedure4(){

            public void apply(Object arg) {
                if (((FieldMetadata)arg).hasIndex()) {
                    hasIndex.value = true;
                }
            }
        });
        return !hasIndex.value;
    }

    public boolean isInternal() {
        return this._internal;
    }

    private ClassIndexStrategy createIndexStrategy() {
        return new BTreeClassIndexStrategy(this);
    }

    protected ClassMetadata(ObjectContainerBase container) {
        if (null == container) {
            throw new ArgumentNullException();
        }
        this._container = container;
        this._index = this.createIndexStrategy();
        this._classIndexed = true;
        this._fieldAccessor = new StrictFieldAccessor();
    }

    public ClassMetadata(ObjectContainerBase container, ReflectClass classReflector) {
        if (null == container) {
            throw new ArgumentNullException();
        }
        this._container = container;
        this.classReflector(classReflector);
        this._index = this.createIndexStrategy();
        this._classIndexed = true;
        this._fieldAccessor = this._container.config().exceptionsOnNotStorable() ? new StrictFieldAccessor() : new LenientFieldAccessor();
    }

    FieldAccessor fieldAccessor() {
        return this._fieldAccessor;
    }

    private TypeHandler4 createDefaultTypeHandler() {
        return new StandardReferenceTypeHandler(this);
    }

    public void cascadeActivation(final ActivationContext context) {
        if (!this.objectCanActivate(context.transaction(), context.targetObject())) {
            return;
        }
        this.traverseAllAspects(new TraverseAspectCommand(){

            public void processAspectOnMissingClass(ClassAspect aspect, int currentSlot) {
            }

            public void processAspect(ClassAspect aspect, int currentSlot) {
                aspect.cascadeActivation(context);
            }

            public int declaredAspectCount(ClassMetadata classMetadata) {
                return classMetadata.declaredAspectCount();
            }

            public boolean cancelled() {
                return false;
            }
        });
    }

    public final void addFieldIndices(StatefulBuffer buffer) {
        if (!this.standardReferenceTypeHandlerIsUsed()) {
            return;
        }
        if (this.hasClassIndex() || this.hasVirtualAttributes()) {
            ObjectHeader oh = new ObjectHeader(this, (ReadWriteBuffer)buffer);
            ObjectIdContextImpl context = new ObjectIdContextImpl(buffer.transaction(), buffer, oh, buffer.getID());
            Handlers4.fieldAwareTypeHandler(this.correctHandlerVersion(context)).addFieldIndices(context);
        }
    }

    private boolean standardReferenceTypeHandlerIsUsed() {
        return this._typeHandler instanceof StandardReferenceTypeHandler;
    }

    void initializeAspects() {
        DiagnosticProcessor dp;
        boolean defaultFieldBehaviour;
        this.bitTrue(6);
        Collection4<ClassAspect> aspects = new Collection4<ClassAspect>();
        if (null != this._aspects) {
            aspects.addAll(this._aspects);
        }
        TypeHandler4 customTypeHandler = this.container().handlers().configuredTypeHandler(this.classReflector());
        boolean dirty = this.isDirty();
        if (this.installTranslator(aspects, customTypeHandler)) {
            dirty = true;
        }
        if (this.container().detectSchemaChanges()) {
            if (this.generateCommitTimestamps() && !this.hasCommitTimestampField()) {
                aspects.add(this.container().commitTimestampIndex());
                dirty = true;
            }
            if (this.generateUUIDs() && !this.hasUUIDField()) {
                aspects.add(this.container().uUIDIndex());
                dirty = true;
            }
        }
        if (this.installCustomTypehandler(aspects, customTypeHandler)) {
            dirty = true;
        }
        boolean bl = defaultFieldBehaviour = this._translator == null && customTypeHandler == null;
        if (this.container().detectSchemaChanges()) {
            if (defaultFieldBehaviour && this.collectReflectFields(aspects)) {
                dirty = true;
            }
            if (dirty) {
                this._container.setDirtyInSystemTransaction(this);
            }
        }
        if (dirty || !defaultFieldBehaviour) {
            this._aspects = this.toClassAspectArray(aspects);
        }
        if ((dp = this._container._handlers.diagnosticProcessor()).enabled()) {
            dp.checkClassHasFields(this);
        }
        if (this._aspects == null) {
            this._aspects = new FieldMetadata[0];
        }
        this.initializeConstructor(customTypeHandler);
        if (this.stateDead()) {
            return;
        }
        this._container.callbacks().classOnRegistered(this);
        this.setStateOK();
    }

    private ClassAspect[] toClassAspectArray(Collection4 aspects) {
        ClassAspect[] array = new ClassAspect[aspects.size()];
        aspects.toArray(array);
        for (int i = 0; i < array.length; ++i) {
            array[i].setHandle(i);
        }
        return array;
    }

    private boolean installCustomTypehandler(Collection4 aspects, TypeHandler4 customTypeHandler) {
        if (customTypeHandler == null) {
            return false;
        }
        if (customTypeHandler instanceof ModificationAware) {
            this._modificationChecker = (ModificationAware)((Object)customTypeHandler);
        }
        if (Handlers4.isStandaloneTypeHandler(customTypeHandler)) {
            this._typeHandler = customTypeHandler;
            return false;
        }
        boolean dirty = false;
        TypeHandlerAspect typeHandlerAspect = new TypeHandlerAspect(this, customTypeHandler);
        if (!this.replaceAspectByName(aspects, typeHandlerAspect)) {
            aspects.add(typeHandlerAspect);
            dirty = true;
        }
        this.disableAspectsBefore(aspects, typeHandlerAspect);
        this._customTypeHandlerAspect = typeHandlerAspect;
        return dirty;
    }

    private void disableAspectsBefore(Collection4 aspects, TypeHandlerAspect typeHandlerAspect) {
        ClassAspect aspect;
        int disableFromVersion = aspects.indexOf(typeHandlerAspect) + 1;
        Iterator4 i = aspects.iterator();
        while (i.moveNext() && (aspect = (ClassAspect)i.current()) != typeHandlerAspect) {
            aspect.disableFromAspectCountVersion(disableFromVersion);
        }
    }

    private boolean installTranslator(Collection4 aspects, TypeHandler4 customTypeHandler) {
        if (this._config == null) {
            return false;
        }
        ObjectTranslator translator = this._config.getTranslator();
        if (translator == null) {
            return false;
        }
        ClassAspect existingAspect = this.aspectByName(aspects, TranslatedAspect.fieldNameFor(translator));
        if (null != existingAspect) {
            return this.installTranslatorOnExistingAspect(translator, existingAspect, aspects);
        }
        if (customTypeHandler == null) {
            return this.installTranslatorOnNewAspect(translator, aspects);
        }
        return false;
    }

    private boolean installTranslatorOnNewAspect(ObjectTranslator translator, Collection4 aspects) {
        TranslatedAspect translatedAspect = new TranslatedAspect(this, translator);
        aspects.add(translatedAspect);
        this._translator = translatedAspect;
        return true;
    }

    private boolean installTranslatorOnExistingAspect(ObjectTranslator translator, ClassAspect existingAspect, Collection4 aspects) {
        if (existingAspect instanceof TranslatedAspect) {
            TranslatedAspect translatedAspect = (TranslatedAspect)existingAspect;
            translatedAspect.initializeTranslator(translator);
            this._translator = translatedAspect;
            return false;
        }
        this._translator = new TranslatedAspect(this, translator);
        aspects.replaceByIdentity(existingAspect, this._translator);
        return true;
    }

    private boolean replaceAspectByName(Collection4 aspects, ClassAspect aspect) {
        ClassAspect existing = this.aspectByName(aspects, aspect.getName());
        if (existing == null) {
            return false;
        }
        aspects.replaceByIdentity(existing, aspect);
        return true;
    }

    private ClassAspect aspectByName(Collection4 aspects, String aspectName) {
        Iterator4 i = aspects.iterator();
        while (i.moveNext()) {
            ClassAspect current = (ClassAspect)i.current();
            if (!current.getName().equals(aspectName)) continue;
            return current;
        }
        return null;
    }

    public boolean aspectsAreInitialized() {
        if (this._aspects == null) {
            return false;
        }
        if (this._ancestor != null) {
            return this._ancestor.aspectsAreInitialized();
        }
        return true;
    }

    private boolean collectReflectFields(Collection4 collectedAspects) {
        boolean dirty = false;
        for (ReflectField reflectField : this.reflectFields()) {
            FieldMetadata field;
            ClassMetadata classMetadata;
            if (!this.storeField(reflectField) || (classMetadata = Handlers4.erasedFieldType(this.container(), reflectField.getFieldType())) == null || this.contains(collectedAspects, field = new FieldMetadata(this, reflectField, classMetadata))) continue;
            dirty = true;
            collectedAspects.add(field);
        }
        return dirty;
    }

    private boolean contains(Collection4 collectedAspects, FieldMetadata field) {
        Iterator4 aspectIterator = collectedAspects.iterator();
        while (aspectIterator.moveNext()) {
            if (!((ClassAspect)aspectIterator.current()).equals(field)) continue;
            return true;
        }
        return false;
    }

    void addToIndex(Transaction trans, int id) {
        if (!trans.container().maintainsIndices()) {
            return;
        }
        this.addToIndex1(trans, id);
    }

    final void addToIndex1(Transaction a_trans, int a_id) {
        if (this._ancestor != null) {
            this._ancestor.addToIndex1(a_trans, a_id);
        }
        if (this.hasClassIndex()) {
            this._index.add(a_trans, a_id);
        }
    }

    boolean allowsQueries() {
        return this.hasClassIndex();
    }

    public boolean descendOnCascadingActivation() {
        return true;
    }

    void checkChanges() {
        if (this.stateOK() && !this.bitIsTrue(6)) {
            this.bitTrue(6);
            if (this._ancestor != null) {
                this._ancestor.checkChanges();
            }
            if (this._classReflector != null) {
                this.initializeAspects();
                if (!this._container.isClient() && !this.isReadOnlyContainer()) {
                    this.write(this._container.systemTransaction());
                }
            }
        }
    }

    public void checkType() {
        ReflectClass claxx = this.classReflector();
        if (claxx == null) {
            return;
        }
        if (this._container._handlers.ICLASS_INTERNAL.isAssignableFrom(claxx)) {
            this._internal = true;
        }
        if (this._container._handlers.ICLASS_UNVERSIONED.isAssignableFrom(claxx)) {
            this._unversioned = true;
        }
        if (this.isDb4oTypeImpl()) {
            Db4oTypeImpl db4oTypeImpl = (Db4oTypeImpl)claxx.newInstance();
            this._classIndexed = db4oTypeImpl == null || db4oTypeImpl.hasClassIndex();
        } else if (this._config != null) {
            this._classIndexed = this._config.indexed();
        }
    }

    public boolean isDb4oTypeImpl() {
        return this._container._handlers.ICLASS_DB4OTYPEIMPL.isAssignableFrom(this.classReflector());
    }

    public final UpdateDepth adjustUpdateDepth(Transaction trans, UpdateDepth depth) {
        return depth.adjust(this);
    }

    public boolean cascadesOnDeleteOrUpdate() {
        Config4Class config = this.configOrAncestorConfig();
        if (config == null) {
            return false;
        }
        boolean cascadeOnDelete = config.cascadeOnDelete() == TernaryBool.YES;
        boolean cascadeOnUpdate = config.cascadeOnUpdate() == TernaryBool.YES;
        return cascadeOnDelete || cascadeOnUpdate;
    }

    public FixedActivationDepth adjustCollectionDepthToBorders(FixedActivationDepth depth) {
        if (!this.classReflector().isCollection()) {
            return depth;
        }
        return depth.adjustDepthToBorders();
    }

    public final int updateDepthFromConfig() {
        int ancestordepth;
        if (this._config != null && this._config.updateDepth() != -2147483548) {
            return this._config.updateDepth();
        }
        Config4Impl config = this.configImpl();
        int depth = config.updateDepth();
        if (this._ancestor != null && (ancestordepth = this._ancestor.updateDepthFromConfig()) > depth) {
            return ancestordepth;
        }
        return depth;
    }

    public void collectConstraints(final Transaction trans, final QConObject parentConstraint, final Object obj, final Visitor4 visitor) {
        this.traverseAllAspects(new TraverseFieldCommand(){

            protected void process(FieldMetadata field) {
                if (field.isEnabledOn(AspectVersionContextImpl.CHECK_ALWAYS_ENABLED)) {
                    field.collectConstraints(trans, parentConstraint, obj, visitor);
                }
            }
        });
    }

    public final void collectIDs(CollectIdContext context, final String fieldName) {
        this.collectIDs(context, new Predicate4<ClassAspect>(){

            @Override
            public boolean match(ClassAspect candidate) {
                return fieldName.equals(candidate.getName());
            }
        });
    }

    public final void collectIDs(CollectIdContext context) {
        this.collectIDs(context, new Predicate4<ClassAspect>(){

            @Override
            public boolean match(ClassAspect candidate) {
                return true;
            }
        });
    }

    private void collectIDs(CollectIdContext context, Predicate4<ClassAspect> predicate) {
        if (!this.standardReferenceTypeHandlerIsUsed()) {
            throw new IllegalStateException();
        }
        ((StandardReferenceTypeHandler)this.correctHandlerVersion(context)).collectIDs(context, predicate);
    }

    public void collectIDs(QueryingReadContext context) {
        if (!this.standardReferenceTypeHandlerIsUsed()) {
            throw new IllegalStateException();
        }
        Handlers4.collectIDs(context, this.correctHandlerVersion(context));
    }

    public Config4Class config() {
        return this._config;
    }

    public Config4Class configOrAncestorConfig() {
        if (this._config != null) {
            return this._config;
        }
        if (this._ancestor != null) {
            return this._ancestor.configOrAncestorConfig();
        }
        return null;
    }

    private void resolveClassReflector(String className) {
        ReflectClass reflectClass = this._container.reflector().forName(className);
        if (null == reflectClass) {
            throw new IllegalStateException("Cannot initialize ClassMetadata for '" + className + "'.");
        }
        this.classReflector(reflectClass);
    }

    private void initializeConstructor(TypeHandler4 customTypeHandler) {
        if (this.isTransient()) {
            this._container.logMsg(23, this.getName());
            this.setStateDead();
            return;
        }
        if (this.isInterface() || this.isAbstract()) {
            return;
        }
        Function4<UnmarshallingContext, Object> constructor = this.createConstructor(customTypeHandler);
        if (constructor != null) {
            this._constructor = constructor;
            return;
        }
        this.notStorable();
    }

    private boolean isAbstract() {
        return this.classReflector().isAbstract();
    }

    private boolean isInterface() {
        return this.classReflector().isInterface();
    }

    private Function4<UnmarshallingContext, Object> createConstructor(TypeHandler4 customTypeHandler) {
        if (customTypeHandler instanceof InstantiatingTypeHandler) {
            return new Function4<UnmarshallingContext, Object>(){

                @Override
                public Object apply(UnmarshallingContext context) {
                    return ClassMetadata.this.instantiateWithCustomTypeHandlerIfEnabled(context);
                }
            };
        }
        if (this.hasObjectConstructor()) {
            return new Function4<UnmarshallingContext, Object>(){

                @Override
                public Object apply(UnmarshallingContext context) {
                    return ClassMetadata.this._translator.construct(context);
                }
            };
        }
        if (this.classReflector().ensureCanBeInstantiated()) {
            return new Function4<UnmarshallingContext, Object>(){

                @Override
                public Object apply(UnmarshallingContext context) {
                    return ClassMetadata.this.instantiateFromReflector(context.container());
                }
            };
        }
        return null;
    }

    private void notStorable() {
        this._container.logMsg(7, this.getName());
        this.setStateDead();
    }

    private boolean isTransient() {
        return this._container._handlers.isTransient(this.classReflector());
    }

    private void classReflector(ReflectClass claxx) {
        this._classReflector = claxx;
        if (claxx == null) {
            this._typeHandler = null;
            return;
        }
        this._typeHandler = this.createDefaultTypeHandler();
    }

    public void deactivate(Transaction trans, ObjectInfo reference, ActivationDepth depth) {
        Object obj = reference.getObject();
        if (this.objectCanDeactivate(trans, reference)) {
            this.forceDeactivation(trans, depth, obj);
            this.objectOnDeactivate(trans, reference);
        }
    }

    public void forceDeactivation(Transaction trans, ActivationDepth depth, Object obj) {
        this.deactivateFields(trans.container().activationContextFor(trans, obj, depth));
    }

    private void objectOnDeactivate(Transaction transaction, ObjectInfo obj) {
        ObjectContainerBase container = transaction.container();
        container.callbacks().objectOnDeactivate(transaction, obj);
        this.dispatchEvent(transaction, obj.getObject(), 3);
    }

    private boolean objectCanDeactivate(Transaction transaction, ObjectInfo objectInfo) {
        ObjectContainerBase container = transaction.container();
        return container.callbacks().objectCanDeactivate(transaction, objectInfo) && this.dispatchEvent(transaction, objectInfo.getObject(), 7);
    }

    final void deactivateFields(final ActivationContext context) {
        this.traverseAllAspects(new TraverseAspectCommand(){

            public void processAspectOnMissingClass(ClassAspect aspect, int currentSlot) {
            }

            public void processAspect(ClassAspect aspect, int currentSlot) {
                if (aspect.isEnabledOn(AspectVersionContextImpl.CHECK_ALWAYS_ENABLED)) {
                    aspect.deactivate(context);
                }
            }

            public int declaredAspectCount(ClassMetadata classMetadata) {
                return classMetadata.declaredAspectCount();
            }

            public boolean cancelled() {
                return false;
            }
        });
    }

    final void delete(StatefulBuffer buffer, Object obj) {
        this.removeFromIndex(buffer.transaction(), buffer.getID());
        this.cascadeDeletion(buffer, obj);
    }

    private void cascadeDeletion(StatefulBuffer buffer, Object obj) {
        ObjectHeader oh = new ObjectHeader(this, (ReadWriteBuffer)buffer);
        DeleteContextImpl context = new DeleteContextImpl(buffer, oh, this.classReflector(), null);
        this.deleteMembers(context, this.arrayTypeFor(buffer, obj), false);
    }

    private ArrayType arrayTypeFor(StatefulBuffer buffer, Object obj) {
        return buffer.transaction().container()._handlers.arrayType(obj);
    }

    public void delete(DeleteContext context) throws Db4oIOException {
        this.correctHandlerVersion(context).delete(context);
    }

    void deleteMembers(DeleteContextImpl context, ArrayType arrayType, boolean isUpdate) {
        int preserveCascade;
        StatefulBuffer buffer;
        block5: {
            buffer = (StatefulBuffer)context.buffer();
            preserveCascade = context.cascadeDeleteDepth();
            try {
                if (this.cascadeOnDelete()) {
                    if (this.classReflector().isCollection()) {
                        buffer.setCascadeDeletes(this.collectionDeleteDepth(context));
                    } else {
                        buffer.setCascadeDeletes(1);
                    }
                }
                Handlers4.fieldAwareTypeHandler(this.correctHandlerVersion(context)).deleteMembers(context, isUpdate);
            }
            catch (Exception e) {
                DiagnosticProcessor dp = this.container()._handlers.diagnosticProcessor();
                if (!dp.enabled()) break block5;
                dp.deletionFailed();
            }
        }
        buffer.setCascadeDeletes(preserveCascade);
    }

    private int collectionDeleteDepth(DeleteContextImpl context) {
        return 1;
    }

    public TernaryBool cascadeOnDeleteTernary() {
        Config4Class config = this.config();
        TernaryBool cascadeOnDelete = TernaryBool.UNSPECIFIED;
        if (config != null && (cascadeOnDelete = config.cascadeOnDelete()) != TernaryBool.UNSPECIFIED) {
            return cascadeOnDelete;
        }
        if (this._ancestor == null) {
            return cascadeOnDelete;
        }
        return this._ancestor.cascadeOnDeleteTernary();
    }

    public boolean cascadeOnDelete() {
        return this.cascadeOnDeleteTernary() == TernaryBool.YES;
    }

    public final boolean dispatchEvent(Transaction trans, Object obj, int message) {
        return this.eventDispatcher().dispatch(trans, obj, message);
    }

    public final boolean hasEventRegistered(Transaction trans, int eventID) {
        return this.eventDispatcher().hasEventRegistered(eventID);
    }

    private EventDispatcher eventDispatcher() {
        if (null != this._eventDispatcher) {
            return this._eventDispatcher;
        }
        this._eventDispatcher = EventDispatchers.forClass(this._container, this.classReflector());
        return this._eventDispatcher;
    }

    public final int declaredAspectCount() {
        if (this._aspects == null) {
            return 0;
        }
        return this._aspects.length;
    }

    public final int aspectCount() {
        int count = this.declaredAspectCount();
        if (this._ancestor != null) {
            count += this._ancestor.aspectCount();
        }
        return count;
    }

    public final HandlerVersion seekToField(Transaction trans, ByteArrayBuffer buffer, FieldMetadata field) {
        if (buffer == null) {
            return HandlerVersion.INVALID;
        }
        if (!this.standardReferenceTypeHandlerIsUsed()) {
            return HandlerVersion.INVALID;
        }
        buffer.seek(0);
        ObjectHeader oh = new ObjectHeader(this._container, (ReadWriteBuffer)buffer);
        boolean res = oh.classMetadata().seekToField(new ObjectHeaderContext(trans, buffer, oh), field);
        if (!res) {
            return HandlerVersion.INVALID;
        }
        return new HandlerVersion(oh.handlerVersion());
    }

    public final boolean seekToField(ObjectHeaderContext context, ClassAspect field) {
        if (!this.standardReferenceTypeHandlerIsUsed()) {
            return false;
        }
        return Handlers4.fieldAwareTypeHandler(this.correctHandlerVersion(context)).seekToField(context, field);
    }

    public boolean generateUUIDs() {
        if (!this.generateVirtual()) {
            return false;
        }
        TernaryBool configValue = this._config == null ? TernaryBool.UNSPECIFIED : this._config.generateUUIDs();
        return this.generate1(this._container.config().generateUUIDs(), configValue);
    }

    public boolean generateCommitTimestamps() {
        return this._container.config().generateCommitTimestamps().definiteYes();
    }

    private boolean generateVirtual() {
        if (this._unversioned) {
            return false;
        }
        return !this._internal;
    }

    private boolean generate1(ConfigScope globalConfig, TernaryBool individualConfig) {
        return globalConfig.applyConfig(individualConfig);
    }

    public ClassMetadata getAncestor() {
        return this._ancestor;
    }

    public Object getComparableObject(Object forObject) {
        if (this._config != null && this._config.queryAttributeProvider() != null) {
            return this._config.queryAttributeProvider().attribute(forObject);
        }
        return forObject;
    }

    public ClassMetadata getHigherHierarchy(ClassMetadata a_classMetadata) {
        ClassMetadata yc = this.getHigherHierarchy1(a_classMetadata);
        if (yc != null) {
            return yc;
        }
        return a_classMetadata.getHigherHierarchy1(this);
    }

    private ClassMetadata getHigherHierarchy1(ClassMetadata a_classMetadata) {
        if (a_classMetadata == this) {
            return this;
        }
        if (this._ancestor != null) {
            return this._ancestor.getHigherHierarchy1(a_classMetadata);
        }
        return null;
    }

    public ClassMetadata getHigherOrCommonHierarchy(ClassMetadata a_classMetadata) {
        ClassMetadata yc = this.getHigherHierarchy1(a_classMetadata);
        if (yc != null) {
            return yc;
        }
        if (this._ancestor != null && (yc = this._ancestor.getHigherOrCommonHierarchy(a_classMetadata)) != null) {
            return yc;
        }
        return a_classMetadata.getHigherHierarchy1(this);
    }

    @Override
    public byte getIdentifier() {
        return 67;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getIDs() {
        Object object = this.lock();
        synchronized (object) {
            if (!this.stateOK()) {
                return new long[0];
            }
            return this.getIDs(this._container.transaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getIDs(Transaction trans) {
        Object object = this.lock();
        synchronized (object) {
            if (!this.stateOK()) {
                return new long[0];
            }
            if (!this.hasClassIndex()) {
                return new long[0];
            }
            return trans.container().getIDsForClass(trans, this);
        }
    }

    @Override
    public boolean hasClassIndex() {
        if (!this._classIndexed) {
            return false;
        }
        return this.standardReferenceTypeHandlerIsUsed() || !Handlers4.isValueType(this._typeHandler);
    }

    private boolean ancestorHasUUIDField() {
        if (this._ancestor == null) {
            return false;
        }
        return this._ancestor.hasUUIDField();
    }

    private boolean hasUUIDField() {
        if (this.ancestorHasUUIDField()) {
            return true;
        }
        return Arrays4.containsInstanceOf(this._aspects, UUIDFieldMetadata.class);
    }

    private boolean ancestorHasVersionField() {
        if (this._ancestor == null) {
            return false;
        }
        return this._ancestor.hasVersionField();
    }

    private boolean ancestorHasCommitTimestampField() {
        if (this._ancestor == null) {
            return false;
        }
        return this._ancestor.hasCommitTimestampField();
    }

    public boolean hasVersionField() {
        if (this.ancestorHasVersionField()) {
            return true;
        }
        return Arrays4.containsInstanceOf(this._aspects, VersionFieldMetadata.class);
    }

    private boolean hasCommitTimestampField() {
        if (this.ancestorHasCommitTimestampField()) {
            return true;
        }
        return Arrays4.containsInstanceOf(this._aspects, CommitTimestampFieldMetadata.class);
    }

    public ClassIndexStrategy index() {
        return this._index;
    }

    public int indexEntryCount(Transaction ta) {
        if (!this.stateOK()) {
            return 0;
        }
        return this._index.entryCount(ta);
    }

    public ReflectClass classReflector() {
        return this._classReflector;
    }

    @Override
    public String getName() {
        if (this.i_name == null && this._classReflector != null) {
            this.setName(this._classReflector.getName());
        }
        return this.i_name;
    }

    @Override
    public StoredClass getParentStoredClass() {
        return this.getAncestor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredField[] getStoredFields() {
        Object object = this.lock();
        synchronized (object) {
            if (this._aspects == null) {
                return new StoredField[0];
            }
            final Collection4<StoredField> storedFields = new Collection4<StoredField>();
            this.traverseDeclaredFields(new Procedure4(){

                public void apply(Object field) {
                    storedFields.add(field);
                }
            });
            StoredField[] fields = new StoredField[storedFields.size()];
            storedFields.toArray(fields);
            return fields;
        }
    }

    public final ObjectContainerBase container() {
        return this._container;
    }

    public FieldMetadata fieldMetadataForName(final String name) {
        final ByRef byReference = new ByRef();
        this.traverseAllAspects(new TraverseFieldCommand(){

            protected void process(FieldMetadata field) {
                if (name.equals(field.getName())) {
                    byReference.value = field;
                }
            }
        });
        return (FieldMetadata)byReference.value;
    }

    public boolean hasField(ObjectContainerBase container, String fieldName) {
        if (this.classReflector().isCollection()) {
            return true;
        }
        return this.fieldMetadataForName(fieldName) != null;
    }

    boolean hasVirtualAttributes() {
        if (this._internal) {
            return false;
        }
        return this.hasVersionField() || this.hasUUIDField();
    }

    public boolean holdsAnyClass() {
        return this.classReflector().isCollection();
    }

    void incrementFieldsOffset1(ByteArrayBuffer a_bytes) {
        int length = this.readAspectCount(a_bytes);
        for (int i = 0; i < length; ++i) {
            this._aspects[i].incrementOffset(a_bytes);
        }
    }

    final boolean init(ClassMetadata ancestor) {
        if (DTrace.enabled) {
            DTrace.CLASSMETADATA_INIT.log(this.getID());
        }
        this.setConfig(this.configImpl().configClass(this.getName()));
        this.setAncestor(ancestor);
        this.checkType();
        if (this.allowsQueries()) {
            this._index.initialize(this._container);
        }
        this.bitTrue(6);
        return true;
    }

    final void initConfigOnUp(Transaction systemTrans) {
        Config4Class extendedConfig = Platform4.extendConfiguration(this._classReflector, this._container.configure(), this._config);
        if (extendedConfig != null) {
            this._config = extendedConfig;
        }
        if (this._config == null) {
            return;
        }
        if (!this.stateOK()) {
            return;
        }
        this.initializeFieldsConfiguration(systemTrans, extendedConfig);
        this.checkAllConfiguredFieldsExist(extendedConfig);
    }

    private void initializeFieldsConfiguration(Transaction systemTrans, Config4Class extendedConfig) {
        if (this._aspects == null) {
            return;
        }
        for (int i = 0; i < this._aspects.length; ++i) {
            if (!(this._aspects[i] instanceof FieldMetadata)) continue;
            FieldMetadata field = (FieldMetadata)this._aspects[i];
            String fieldName = field.getName();
            if (!field.hasConfig() && extendedConfig != null && extendedConfig.configField(fieldName) != null) {
                field.initConfiguration(fieldName);
            }
            field.initConfigOnUp(systemTrans);
        }
    }

    private void checkAllConfiguredFieldsExist(Config4Class config) {
        Hashtable4 exceptionalFields = config.exceptionalFieldsOrNull();
        if (exceptionalFields == null) {
            return;
        }
        Iterator4 i = exceptionalFields.valuesIterator();
        while (i.moveNext()) {
            Config4Field fieldConfig = (Config4Field)i.current();
            if (fieldConfig.used()) continue;
            this.configImpl().diagnosticProcessor().objectFieldDoesNotExist(this.getName(), fieldConfig.getName());
        }
    }

    void initOnUp(Transaction systemTrans) {
        if (!this.stateOK()) {
            return;
        }
        this.initConfigOnUp(systemTrans);
        this.storeStaticFieldValues(systemTrans, false);
    }

    public Object instantiate(UnmarshallingContext context) {
        boolean instantiating;
        Object obj = context.persistentObject();
        boolean bl = instantiating = obj == null;
        if (instantiating) {
            obj = this.instantiateObject(context);
            if (obj == null) {
                return null;
            }
            this.shareTransaction(obj, context.transaction());
            this.shareObjectReference(obj, context.objectReference());
            this.onInstantiate(context, obj);
            if (context.activationDepth().mode().isPrefetch()) {
                context.objectReference().setStateDeactivated();
                return obj;
            }
            if (!context.activationDepth().requiresActivation()) {
                context.objectReference().setStateDeactivated();
                return obj;
            }
            return this.activate(context);
        }
        if (this.activatingActiveObject(context.activationDepth().mode(), context.objectReference())) {
            ActivationDepth child = context.activationDepth().descend(this);
            if (child.requiresActivation()) {
                this.cascadeActivation(new ActivationContext4(context.transaction(), obj, child));
            }
            return obj;
        }
        return this.activate(context);
    }

    protected final void onInstantiate(UnmarshallingContext context, Object obj) {
        context.setObjectWeak(obj);
        context.transaction().referenceSystem().addExistingReference(context.objectReference());
        this.objectOnInstantiate(context.transaction(), context.objectReference());
    }

    public Object instantiateTransient(UnmarshallingContext context) {
        Object obj = this.instantiateObject(context);
        if (obj == null) {
            return null;
        }
        context.container().peeked(context.objectId(), obj);
        if (context.activationDepth().requiresActivation()) {
            this.instantiateFields(context);
        }
        return obj;
    }

    private boolean activatingActiveObject(ActivationMode mode, ObjectReference ref) {
        return !mode.isRefresh() && ref.isActive();
    }

    private Object activate(UnmarshallingContext context) {
        Object obj = context.persistentObject();
        ObjectReference objectReference = context.objectReference();
        if (!this.objectCanActivate(context.transaction(), obj)) {
            objectReference.setStateDeactivated();
            return obj;
        }
        objectReference.setStateClean();
        if (context.activationDepth().requiresActivation()) {
            this.instantiateFields(context);
        }
        this.objectOnActivate(context.transaction(), objectReference);
        return obj;
    }

    public boolean hasObjectConstructor() {
        return this._translator != null && this._translator.isObjectConstructor();
    }

    public boolean isTranslated() {
        return this._translator != null;
    }

    private Object instantiateObject(UnmarshallingContext context) {
        Object obj = this._constructor.apply(context);
        context.persistentObject(obj);
        return obj;
    }

    private void objectOnInstantiate(Transaction transaction, ObjectInfo reference) {
        transaction.container().callbacks().objectOnInstantiate(transaction, reference);
    }

    private Object instantiateFromReflector(ObjectContainerBase stream) {
        if (this._classReflector == null) {
            throw new IllegalStateException();
        }
        try {
            return this._classReflector.newInstance();
        }
        catch (NoSuchMethodError e) {
            this.container().logMsg(7, this.classReflector().getName());
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void shareObjectReference(Object obj, ObjectReference ref) {
        if (obj instanceof Db4oTypeImpl) {
            ((Db4oTypeImpl)obj).setObjectReference(ref);
        }
    }

    private void shareTransaction(Object obj, Transaction transaction) {
        if (obj instanceof TransactionAware) {
            ((TransactionAware)obj).setTrans(transaction);
        }
    }

    private void objectOnActivate(Transaction transaction, ObjectInfo obj) {
        ObjectContainerBase container = transaction.container();
        container.callbacks().objectOnActivate(transaction, obj);
        this.dispatchEvent(transaction, obj.getObject(), 2);
    }

    private boolean objectCanActivate(Transaction transaction, Object obj) {
        ObjectContainerBase container = transaction.container();
        return container.callbacks().objectCanActivate(transaction, obj) && this.dispatchEvent(transaction, obj, 6);
    }

    void instantiateFields(UnmarshallingContext context) {
        TypeHandler4 handler = this.correctHandlerVersion(context);
        Handlers4.activate(context, handler);
    }

    public boolean isArray() {
        return this.classReflector().isCollection();
    }

    boolean isCollection(Object obj) {
        return this.reflector().forObject(obj).isCollection();
    }

    @Override
    public boolean isDirty() {
        if (!this.stateOK()) {
            return false;
        }
        return super.isDirty();
    }

    boolean isEnum() {
        return Platform4.isJavaEnum(this.reflector(), this.classReflector());
    }

    public boolean hasIdentity() {
        return true;
    }

    public boolean isStronglyTyped() {
        return true;
    }

    public boolean isValueType() {
        return Handlers4.holdsValueType(this._typeHandler);
    }

    private final Object lock() {
        return this._container.lock();
    }

    public String nameToWrite() {
        if (this._config != null && this._config.writeAs() != null) {
            return this._config.writeAs();
        }
        if (this.i_name == null) {
            return "";
        }
        return this.configImpl().resolveAliasRuntimeName(this.i_name);
    }

    public final boolean callConstructor() {
        TernaryBool specialized = this.callConstructorSpecialized();
        if (!specialized.isUnspecified()) {
            return specialized.definiteYes();
        }
        return this.configImpl().callConstructors().definiteYes();
    }

    private Config4Impl configImpl() {
        return this._container.configImpl();
    }

    private final TernaryBool callConstructorSpecialized() {
        TernaryBool res;
        if (this._config != null && !(res = this._config.callConstructor()).isUnspecified()) {
            return res;
        }
        if (this.isEnum()) {
            return TernaryBool.NO;
        }
        if (this._ancestor != null) {
            return this._ancestor.callConstructorSpecialized();
        }
        return TernaryBool.UNSPECIFIED;
    }

    @Override
    public int ownLength() {
        return MarshallerFamily.current()._class.marshalledLength(this._container, this);
    }

    void purge() {
        this._index.purge();
    }

    public TypeHandler4 readCandidateHandler(QueryingReadContext context) {
        TypeHandler4 typeHandler = this.correctHandlerVersion(context);
        if (typeHandler instanceof CascadingTypeHandler) {
            return ((CascadingTypeHandler)typeHandler).readCandidateHandler(context);
        }
        return null;
    }

    public TypeHandler4 seekCandidateHandler(QueryingReadContext context) {
        if (this.isArray()) {
            if (Platform4.isCollectionTranslator(this._config)) {
                context.seek(context.offset() + 4);
                return new ArrayHandler(null, false);
            }
            this.incrementFieldsOffset1((ByteArrayBuffer)context.buffer());
            if (this._ancestor != null) {
                return this._ancestor.seekCandidateHandler(context);
            }
        }
        return null;
    }

    public final int readAspectCount(ReadBuffer buffer) {
        int count = buffer.readInt();
        if (count > this._aspects.length) {
            return this._aspects.length;
        }
        return count;
    }

    byte[] readName(Transaction a_trans) {
        this.i_reader = a_trans.container().readBufferById(a_trans, this.getID());
        return this.readName1(a_trans, this.i_reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] readName1(Transaction trans, ByteArrayBuffer reader) {
        if (reader == null) {
            return null;
        }
        this.i_reader = reader;
        boolean ok = false;
        try {
            ClassMarshaller marshaller = MarshallerFamily.current()._class;
            this.i_nameBytes = marshaller.readName(trans, reader);
            marshaller.readMetaClassID(reader);
            this.setStateUnread();
            this.bitFalse(6);
            this.bitFalse(5);
            ok = true;
            byte[] byArray = this.i_nameBytes;
            return byArray;
        }
        finally {
            if (!ok) {
                this.setStateDead();
            }
        }
    }

    public void readVirtualAttributes(Transaction trans, ObjectReference ref, boolean lastCommitted) {
        int id = ref.getID();
        ObjectContainerBase container = trans.container();
        ByteArrayBuffer buffer = container.readBufferById(trans, id, lastCommitted);
        ObjectHeader oh = new ObjectHeader(this, (ReadWriteBuffer)buffer);
        ObjectReferenceContext context = new ObjectReferenceContext(trans, buffer, oh, ref);
        Handlers4.fieldAwareTypeHandler(this.correctHandlerVersion(context)).readVirtualAttributes(context);
    }

    public GenericReflector reflector() {
        return this._container.reflector();
    }

    @Override
    public void rename(String newName) {
        if (this._container.isClient()) {
            Exceptions4.throwRuntimeException(58);
        }
        int tempState = this._state;
        this.setStateOK();
        this.setName(newName);
        this.i_nameBytes = this.asBytes(this.i_name);
        this.setStateDirty();
        this.write(this._container.systemTransaction());
        ReflectClass oldReflector = this._classReflector;
        this.classReflector(this.container().reflector().forName(newName));
        this.container().classCollection().refreshClassCache(this, oldReflector);
        this.refresh();
        this._state = tempState;
    }

    private byte[] asBytes(String str) {
        return this.container().stringIO().write(str);
    }

    final void createConfigAndConstructor(Hashtable4 a_byteHashTable, ReflectClass claxx) {
        this.setName(this.resolveName(claxx));
        this.setConfig(this.configImpl().configClass(this.getName()));
        if (claxx == null) {
            this.resolveClassReflector(this.getName());
        } else {
            this.classReflector(claxx);
        }
        if (this.i_nameBytes != null) {
            a_byteHashTable.remove(this.i_nameBytes);
            this.i_nameBytes = null;
        }
    }

    String resolveName(ReflectClass claxx) {
        if (claxx != null) {
            return claxx.getName();
        }
        if (this.i_nameBytes != null) {
            String name = this._container.stringIO().read(this.i_nameBytes);
            return this.configImpl().resolveAliasStoredName(name);
        }
        throw new IllegalStateException();
    }

    boolean readThis() {
        boolean stateUnread = this.stateUnread();
        if (stateUnread) {
            this.setStateOK();
            this.setStateClean();
        }
        if (stateUnread || this.stateDead()) {
            this.forceRead();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void forceRead() {
        if (this.i_reader == null || this.bitIsTrue(8)) {
            return;
        }
        this.bitTrue(8);
        try {
            MarshallerFamily.forConverterVersion((int)this._container.converterVersion())._class.read(this._container, this, this.i_reader);
            this.i_nameBytes = null;
            this.i_reader = null;
        }
        finally {
            this.bitFalse(8);
        }
    }

    @Override
    public void readThis(Transaction a_trans, ByteArrayBuffer a_reader) {
        throw Exceptions4.virtualException();
    }

    public void refresh() {
        if (!this.stateUnread()) {
            this.resolveClassReflector(this.i_name);
            this.bitFalse(6);
            this.checkChanges();
            this.traverseDeclaredFields(new Procedure4(){

                public void apply(Object arg) {
                    ((FieldMetadata)arg).refresh();
                }
            });
        }
    }

    void removeFromIndex(Transaction ta, int id) {
        if (this.hasClassIndex()) {
            this._index.remove(ta, id);
        }
        if (this._ancestor != null) {
            this._ancestor.removeFromIndex(ta, id);
        }
    }

    boolean renameField(final String oldName, final String newName) {
        final BooleanByRef renamed = new BooleanByRef(false);
        for (int i = 0; i < this._aspects.length; ++i) {
            if (!this._aspects[i].getName().equals(newName)) continue;
            this._container.logMsg(9, "class:" + this.getName() + " field:" + newName);
            return false;
        }
        this.traverseDeclaredFields(new Procedure4(){

            public void apply(Object arg) {
                FieldMetadata field = (FieldMetadata)arg;
                if (field.getName().equals(oldName)) {
                    field.setName(newName);
                    renamed.value = true;
                }
            }
        });
        return renamed.value;
    }

    void setConfig(Config4Class config) {
        if (config == null) {
            return;
        }
        if (this._config == null) {
            this._config = config;
        }
    }

    void setName(String a_name) {
        this.i_name = a_name;
    }

    final void setStateDead() {
        this.bitTrue(7);
        this.bitFalse(4);
    }

    private final void setStateUnread() {
        this.bitFalse(7);
        this.bitTrue(4);
    }

    final void setStateOK() {
        this.bitFalse(7);
        this.bitFalse(4);
    }

    boolean stateDead() {
        return this.bitIsTrue(7);
    }

    final boolean stateOK() {
        return this.bitIsFalse(4) && this.bitIsFalse(7) && this.bitIsFalse(8);
    }

    boolean stateUnread() {
        return this.bitIsTrue(4) && this.bitIsFalse(7) && this.bitIsFalse(8);
    }

    boolean storeField(ReflectField field) {
        if (field.isStatic()) {
            return false;
        }
        if (this.isTransient(field) && !this.shouldStoreTransientFields()) {
            return false;
        }
        return Platform4.canSetAccessible() || field.isPublic();
    }

    boolean shouldStoreTransientFields() {
        Config4Class config = this.configOrAncestorConfig();
        if (config == null) {
            return false;
        }
        return config.storeTransientFields();
    }

    private boolean isTransient(ReflectField field) {
        return field.isTransient() || Platform4.isTransient(field.getFieldType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredField storedField(final String fieldName, Object fieldType) {
        Object object = this.lock();
        synchronized (object) {
            final ClassMetadata fieldTypeFilter = fieldType == null ? null : this._container.classMetadataForReflectClass(ReflectorUtils.reflectClassFor(this.reflector(), fieldType));
            final ByRef foundField = new ByRef();
            this.traverseAllAspects(new TraverseFieldCommand(){

                protected void process(FieldMetadata field) {
                    if (foundField.value != null) {
                        return;
                    }
                    if (field.getName().equals(fieldName) && (fieldTypeFilter == null || fieldTypeFilter == field.fieldType())) {
                        foundField.value = field;
                    }
                }
            });
            return (StoredField)foundField.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeStaticFieldValues(Transaction trans, boolean force) {
        if (this.bitIsTrue(5) && !force) {
            return;
        }
        this.bitTrue(5);
        if (!this.shouldStoreStaticFields(trans)) {
            return;
        }
        ObjectContainerBase stream = trans.container();
        stream.showInternalClasses(true);
        try {
            StaticClass sc = this.queryStaticClass(trans);
            if (sc == null) {
                this.createStaticClass(trans);
            } else {
                this.updateStaticClass(trans, sc);
            }
        }
        finally {
            stream.showInternalClasses(false);
        }
    }

    private boolean shouldStoreStaticFields(Transaction trans) {
        return !this.isReadOnlyContainer() && (this.staticFieldValuesArePersisted() || Platform4.storeStaticFieldValues(trans.reflector(), this.classReflector()));
    }

    private boolean isReadOnlyContainer() {
        return this.container().config().isReadOnly();
    }

    private void updateStaticClass(final Transaction trans, StaticClass sc) {
        ObjectContainerBase stream = trans.container();
        stream.activate(trans, sc, new FixedActivationDepth(4));
        final StaticField[] existingFields = sc.fields;
        Iterator4 staticFields = Iterators.map(this.staticReflectFields(), new Function4(){

            public Object apply(Object arg) {
                ReflectField reflectField = (ReflectField)arg;
                StaticField existingField = ClassMetadata.this.fieldByName(existingFields, reflectField.getName());
                if (existingField != null) {
                    ClassMetadata.this.updateExistingStaticField(trans, existingField, reflectField);
                    return existingField;
                }
                return ClassMetadata.this.toStaticField(reflectField);
            }
        });
        sc.fields = this.toStaticFieldArray(staticFields);
        if (!stream.isClient()) {
            this.setStaticClass(trans, sc);
        }
    }

    private void createStaticClass(Transaction trans) {
        if (trans.container().isClient()) {
            return;
        }
        StaticClass sc = new StaticClass(this.getName(), this.toStaticFieldArray(this.staticReflectFieldsToStaticFields()));
        this.setStaticClass(trans, sc);
    }

    private Iterator4 staticReflectFieldsToStaticFields() {
        return Iterators.map(this.staticReflectFields(), new Function4(){

            public Object apply(Object arg) {
                return ClassMetadata.this.toStaticField((ReflectField)arg);
            }
        });
    }

    protected StaticField toStaticField(ReflectField reflectField) {
        return new StaticField(reflectField.getName(), this.staticReflectFieldValue(reflectField));
    }

    private Object staticReflectFieldValue(ReflectField reflectField) {
        return this._fieldAccessor.get(reflectField, null);
    }

    private void setStaticClass(Transaction trans, StaticClass sc) {
        trans.container().storeInternal(trans, sc, true);
    }

    private StaticField[] toStaticFieldArray(Iterator4 iterator4) {
        return this.toStaticFieldArray(new Collection4(iterator4));
    }

    private StaticField[] toStaticFieldArray(Collection4 fields) {
        return fields.toArray(new StaticField[fields.size()]);
    }

    private Iterator4 staticReflectFields() {
        return Iterators.filter(this.reflectFields(), new Predicate4(){

            public boolean match(Object candidate) {
                return ((ReflectField)candidate).isStatic() && !((ReflectField)candidate).isTransient();
            }
        });
    }

    private ReflectField[] reflectFields() {
        return this.classReflector().getDeclaredFields();
    }

    protected void updateExistingStaticField(Transaction trans, StaticField existingField, ReflectField reflectField) {
        int id;
        ObjectContainerBase stream = trans.container();
        Object newValue = this.staticReflectFieldValue(reflectField);
        if (existingField.value != null && newValue != null && existingField.value.getClass() == newValue.getClass() && (id = stream.getID(trans, existingField.value)) > 0) {
            if (existingField.value != newValue) {
                stream.bind(trans, newValue, id);
                stream.refresh(trans, newValue, Integer.MAX_VALUE);
                existingField.value = newValue;
            }
            return;
        }
        if (newValue == null) {
            try {
                this._fieldAccessor.set(reflectField, null, existingField.value);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        existingField.value = newValue;
    }

    private boolean staticFieldValuesArePersisted() {
        return this._config != null && this._config.staticFieldValuesArePersisted();
    }

    protected StaticField fieldByName(StaticField[] fields, String fieldName) {
        for (int i = 0; i < fields.length; ++i) {
            StaticField field = fields[i];
            if (!fieldName.equals(field.name)) continue;
            return field;
        }
        return null;
    }

    private StaticClass queryStaticClass(Transaction trans) {
        Query q = trans.container().query(trans);
        q.constrain(Const4.CLASS_STATICCLASS);
        q.descend("name").constrain(this.getName());
        ObjectSet os = q.execute();
        return os.size() > 0 ? (StaticClass)os.next() : null;
    }

    public String toString() {
        if (this.i_name != null) {
            return this.i_name;
        }
        if (this.i_nameBytes == null) {
            return "*CLASS NAME UNKNOWN*";
        }
        UnicodeStringIO stringIO = this._container == null ? Const4.stringIO : this._container.stringIO();
        return ((LatinStringIO)stringIO).read(this.i_nameBytes);
    }

    @Override
    public boolean writeObjectBegin() {
        if (!this.stateOK()) {
            return false;
        }
        return super.writeObjectBegin();
    }

    @Override
    public final void writeThis(Transaction trans, ByteArrayBuffer writer) {
        MarshallerFamily.current()._class.write(trans, this, writer);
    }

    public PreparedComparison prepareComparison(Context context, Object source) {
        return Handlers4.prepareComparisonFor(this._typeHandler, context, source);
    }

    public static void defragObject(DefragmentContextImpl context) {
        ObjectHeader header = ObjectHeader.defrag(context);
        DefragmentContextImpl childContext = new DefragmentContextImpl(context, header);
        header.classMetadata().defragment(childContext);
    }

    public void defragment(DefragmentContext context) {
        this.correctHandlerVersion(context).defragment(context);
    }

    public void defragClass(DefragmentContextImpl context, int classIndexID) {
        MarshallerFamily mf = MarshallerFamily.forConverterVersion(this.container().converterVersion());
        mf._class.defrag(this, this._container.stringIO(), context, classIndexID);
    }

    public static ClassMetadata readClass(ObjectContainerBase stream, ByteArrayBuffer reader) {
        ObjectHeader oh = new ObjectHeader(stream, (ReadWriteBuffer)reader);
        return oh.classMetadata();
    }

    public boolean isAssignableFrom(ClassMetadata other) {
        return this.classReflector().isAssignableFrom(other.classReflector());
    }

    public void setAncestor(ClassMetadata ancestor) {
        if (ancestor == this) {
            throw new IllegalStateException();
        }
        this._ancestor = ancestor;
    }

    public Object wrapWithTransactionContext(Transaction transaction, Object value) {
        if (value instanceof Integer) {
            return value;
        }
        return new TransactionContext(transaction, value);
    }

    public TypeHandler4 typeHandler() {
        return this._typeHandler;
    }

    public TypeHandler4 delegateTypeHandler(Context context) {
        if (context instanceof HandlerVersionContext) {
            return this.correctHandlerVersion((HandlerVersionContext)context);
        }
        return this._typeHandler;
    }

    protected TypeHandler4 correctHandlerVersion(HandlerVersionContext context) {
        TypeHandler4 typeHandler = HandlerRegistry.correctHandlerVersion(context, this._typeHandler);
        if (typeHandler != this._typeHandler && typeHandler instanceof StandardReferenceTypeHandler) {
            ((StandardReferenceTypeHandler)typeHandler).classMetadata(this);
        }
        return typeHandler;
    }

    public void traverseDeclaredFields(Procedure4 procedure) {
        if (this._aspects == null) {
            return;
        }
        for (int i = 0; i < this._aspects.length; ++i) {
            if (!(this._aspects[i] instanceof FieldMetadata)) continue;
            procedure.apply(this._aspects[i]);
        }
    }

    public void traverseDeclaredAspects(Procedure4 procedure) {
        if (this._aspects == null) {
            return;
        }
        for (int i = 0; i < this._aspects.length; ++i) {
            procedure.apply(this._aspects[i]);
        }
    }

    public boolean aspectsAreNull() {
        return this._aspects == null;
    }

    public boolean isModified(Object obj) {
        return this._modificationChecker.isModified(obj);
    }

    @Override
    public int instanceCount() {
        return this.instanceCount(this._container.transaction());
    }

    public int instanceCount(Transaction trans) {
        return this._container.instanceCount(this, trans);
    }

    public boolean isStorable() {
        return !this.stateDead() && !this.isTransient();
    }

    private Object instantiateWithCustomTypeHandlerIfEnabled(UnmarshallingContext context) {
        if (!this._customTypeHandlerAspect.isEnabledOn(context)) {
            return this.instantiateForVersionWithoutCustomTypeHandler(context);
        }
        return this.instantiateWithCustomTypeHandler(context);
    }

    private Object instantiateForVersionWithoutCustomTypeHandler(UnmarshallingContext context) {
        Function4<UnmarshallingContext, Object> oldVersionConstructor = this.createConstructor(null);
        if (null == oldVersionConstructor) {
            throw new IllegalStateException();
        }
        return oldVersionConstructor.apply(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateWithCustomTypeHandler(final UnmarshallingContext context) {
        ContextState contextState = context.saveState();
        try {
            boolean fieldHasValue = this.seekToField(context, this._customTypeHandlerAspect);
            if (!fieldHasValue) {
                context.restoreState(contextState);
                Object object = this.instantiateForVersionWithoutCustomTypeHandler(context);
                return object;
            }
            final InstantiatingTypeHandler customTypeHandler = (InstantiatingTypeHandler)this._customTypeHandlerAspect._typeHandler;
            Object object = context.slotFormat().doWithSlotIndirection(context, new Closure4<Object>(){

                @Override
                public Object run() {
                    return customTypeHandler.instantiate(context);
                }
            });
            return object;
        }
        finally {
            context.restoreState(contextState);
        }
    }

    public boolean isStruct() {
        return Platform4.isStruct(this.classReflector());
    }

    public void dropClassIndex() {
        if (this.container().isClient()) {
            throw new IllegalStateException();
        }
        this._index = this.createIndexStrategy();
        this._index.initialize(this.container());
        this.container().setDirtyInSystemTransaction(this);
    }

    public void traverseAllAspects(TraverseAspectCommand command) {
        this.aspectTraversalStrategy().traverseAllAspects(command);
    }

    private AspectTraversalStrategy aspectTraversalStrategy() {
        if (this._aspectTraversalStrategy == null) {
            this._aspectTraversalStrategy = this.detectAspectTraversalStrategy();
        }
        return this._aspectTraversalStrategy;
    }

    protected AspectTraversalStrategy detectAspectTraversalStrategy() {
        List<HierarchyAnalyzer.Diff> ancestors = this.compareAncestorHierarchy();
        for (HierarchyAnalyzer.Diff diff : ancestors) {
            if (!diff.isRemoved()) continue;
            return this.createRemovedAspectTraversalStrategy(ancestors);
        }
        return new StandardAspectTraversalStrategy(this);
    }

    private AspectTraversalStrategy createRemovedAspectTraversalStrategy(List<HierarchyAnalyzer.Diff> ancestors) {
        return new ModifiedAspectTraversalStrategy(this, ancestors);
    }

    private List<HierarchyAnalyzer.Diff> compareAncestorHierarchy() {
        return new HierarchyAnalyzer(this, this.classReflector()).analyze();
    }

    private static final class AlwaysModified
    implements ModificationAware {
        static final AlwaysModified INSTANCE = new AlwaysModified();

        private AlwaysModified() {
        }

        public boolean isModified(Object obj) {
            return true;
        }
    }
}

