/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.TernaryBool;
import com.db4o.internal.JDK;
import com.db4o.internal.JDKFactory;
import com.db4o.internal.JDK_5;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.core.ReflectConstructor;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class DalvikVM
extends JDK_5 {
    private TernaryBool supportSkipConstructorCall = TernaryBool.UNSPECIFIED;

    DalvikVM() {
    }

    public ReflectConstructor serializableConstructor(Reflector reflector, final Class clazz) {
        return new ReflectConstructor(){

            public Object newInstance(Object[] parameters) {
                try {
                    return DalvikVM.this.newInstanceSkippingConstructor(clazz);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }

            public ReflectClass[] getParameterTypes() {
                return new ReflectClass[0];
            }
        };
    }

    private Object newInstanceSkippingConstructor(Class clazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method newInstance = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
        newInstance.setAccessible(true);
        return newInstance.invoke(null, clazz, Object.class);
    }

    boolean supportSkipConstructorCall() {
        if (this.supportSkipConstructorCall.isUnspecified()) {
            try {
                this.newInstanceSkippingConstructor(SkipConstructorCheck.class);
                this.supportSkipConstructorCall = TernaryBool.YES;
            }
            catch (Exception e) {
                this.supportSkipConstructorCall = TernaryBool.NO;
            }
        }
        return this.supportSkipConstructorCall.definiteYes();
    }

    public static class SkipConstructorCheck {
        public SkipConstructorCheck() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Factory
    implements JDKFactory {
        public JDK tryToCreate() {
            if (!"Dalvik".equals(System.getProperty("java.vm.name"))) {
                return null;
            }
            return new DalvikVM();
        }
    }
}

