/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.CorruptionException;
import com.db4o.config.ObjectTranslator;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.StoredField;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.No4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassAspect;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Field;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.FieldIndexException;
import com.db4o.internal.FieldMetadataState;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.Handlers4;
import com.db4o.internal.Indexable4;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.ReflectException;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.LegacyActivationDepth;
import com.db4o.internal.activation.UpdateDepth;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.btree.FieldIndexKeyHandler;
import com.db4o.internal.btree.FieldIndexKeyImpl;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.delete.DeleteContextImpl;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.handlers.array.MultidimensionalArrayHandler;
import com.db4o.internal.marshall.AspectType;
import com.db4o.internal.marshall.AspectVersionContext;
import com.db4o.internal.marshall.CollectIdContext;
import com.db4o.internal.marshall.MarshallingContext;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectIdContext;
import com.db4o.internal.marshall.ObjectIdContextImpl;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.query.processor.QField;
import com.db4o.internal.reflect.FieldAccessor;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.reflect.ReflectArray;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.typehandlers.ActivationContext;
import com.db4o.typehandlers.QueryableTypeHandler;
import com.db4o.typehandlers.TypeHandler4;

public class FieldMetadata
extends ClassAspect
implements StoredField {
    private ClassMetadata _containingClass;
    private String _name;
    protected boolean _isArray;
    private boolean _isNArray;
    private boolean _isPrimitive;
    private ReflectField _reflectField;
    private FieldMetadataState _state = FieldMetadataState.NOT_LOADED;
    private Config4Field _config;
    private Db4oTypeImpl _db4oType;
    private int _linkLength;
    private BTree _index;
    protected ClassMetadata _fieldType;
    protected int _fieldTypeID;
    static final FieldMetadata[] EMPTY_ARRAY = new FieldMetadata[0];
    private boolean _initialized = false;

    public FieldMetadata(ClassMetadata classMetadata) {
        this._containingClass = classMetadata;
    }

    protected final Class translatorStoredClass(ObjectTranslator translator) {
        try {
            return translator.storedClass();
        }
        catch (RuntimeException e) {
            throw new ReflectException(e);
        }
    }

    FieldMetadata(ClassMetadata containingClass, ReflectField field, ClassMetadata fieldType) {
        this(containingClass);
        this.init(field.getName());
        this._reflectField = field;
        this._fieldType = fieldType;
        this._fieldTypeID = fieldType.getID();
        boolean isPrimitive = field instanceof GenericField ? ((GenericField)field).isPrimitive() : false;
        this.configure(field.getFieldType(), isPrimitive);
        this.checkDb4oType();
        this.setAvailable();
    }

    protected void setAvailable() {
        this._state = FieldMetadataState.AVAILABLE;
    }

    protected FieldMetadata(int fieldTypeID) {
        this._fieldTypeID = fieldTypeID;
    }

    public FieldMetadata(ClassMetadata containingClass, String name, int fieldTypeID, boolean primitive, boolean isArray, boolean isNArray) {
        this(containingClass);
        this.init(name, fieldTypeID, primitive, isArray, isNArray);
    }

    protected FieldMetadata(ClassMetadata containingClass, String name) {
        this(containingClass);
        this.init(name);
    }

    public void addFieldIndex(ObjectIdContextImpl context) throws FieldIndexException {
        if (!this.hasIndex()) {
            this.incrementOffset(context);
            return;
        }
        try {
            this.addIndexEntry(context.transaction(), context.objectId(), this.readIndexEntry(context));
        }
        catch (CorruptionException exc) {
            throw new FieldIndexException(exc, this);
        }
    }

    protected final void addIndexEntry(StatefulBuffer a_bytes, Object indexEntry) {
        this.addIndexEntry(a_bytes.transaction(), a_bytes.getID(), indexEntry);
    }

    public void addIndexEntry(Transaction trans, int parentID, Object indexEntry) {
        if (!this.hasIndex()) {
            return;
        }
        BTree index = this.getIndex(trans);
        index.add(trans, this.createFieldIndexKey(parentID, indexEntry));
    }

    protected FieldIndexKey createFieldIndexKey(int parentID, Object indexEntry) {
        Object convertedIndexEntry = this.indexEntryFor(indexEntry);
        return new FieldIndexKeyImpl(parentID, convertedIndexEntry);
    }

    protected Object indexEntryFor(Object indexEntry) {
        return this._reflectField.indexEntry(indexEntry);
    }

    public boolean canUseNullBitmap() {
        return true;
    }

    public final Object readIndexEntry(ObjectIdContext context) throws CorruptionException, Db4oIOException {
        IndexableTypeHandler indexableTypeHandler = (IndexableTypeHandler)HandlerRegistry.correctHandlerVersion(context, this.getHandler());
        return indexableTypeHandler.readIndexEntry(context);
    }

    public void removeIndexEntry(Transaction trans, int parentID, Object indexEntry) {
        if (!this.hasIndex()) {
            return;
        }
        BTree index = this.getIndex(trans);
        if (index == null) {
            return;
        }
        index.remove(trans, this.createFieldIndexKey(parentID, indexEntry));
    }

    public boolean alive() {
        if (this._state == FieldMetadataState.AVAILABLE) {
            return true;
        }
        if (this._state == FieldMetadataState.NOT_LOADED) {
            return this.load();
        }
        return this._state == FieldMetadataState.AVAILABLE;
    }

    private boolean load() {
        if (this._fieldType == null) {
            this._fieldType = this.detectFieldType();
            this.checkFieldTypeID();
        }
        this.checkCorrectTypeForField();
        if (this._fieldType == null || this._reflectField == null) {
            this._state = FieldMetadataState.UNAVAILABLE;
            this._reflectField = null;
            return false;
        }
        if (this.updating()) {
            return false;
        }
        this.setAvailable();
        this.checkDb4oType();
        return true;
    }

    private boolean shouldStoreField() {
        return !this._reflectField.isTransient() || this._containingClass != null && this._containingClass.shouldStoreTransientFields();
    }

    public boolean updating() {
        return this._state == FieldMetadataState.UPDATING;
    }

    private void checkFieldTypeID() {
        int id;
        int n = id = this._fieldType != null ? this._fieldType.getID() : 0;
        if (this._fieldTypeID == 0) {
            this._fieldTypeID = id;
            return;
        }
        if (id > 0 && id != this._fieldTypeID) {
            this._fieldType = null;
        }
    }

    boolean canAddToQuery(String fieldName) {
        if (!this.alive()) {
            return false;
        }
        return fieldName.equals(this.getName()) && this.containingClass() != null && !this.containingClass().isInternal();
    }

    private boolean canHold(ReflectClass type) {
        if (type == null) {
            throw new ArgumentNullException();
        }
        TypeHandler4 typeHandler = this.getHandler();
        if (typeHandler instanceof QueryableTypeHandler && ((QueryableTypeHandler)typeHandler).descendsIntoMembers()) {
            return true;
        }
        ReflectClass classReflector = this.fieldType().classReflector();
        if (classReflector.isCollection()) {
            return true;
        }
        return classReflector.isAssignableFrom(type);
    }

    public GenericReflector reflector() {
        ObjectContainerBase container = this.container();
        if (container == null) {
            return null;
        }
        return container.reflector();
    }

    public Object coerce(ReflectClass valueClass, Object value) {
        if (value == null) {
            return this._isPrimitive ? No4.INSTANCE : value;
        }
        if (valueClass == null) {
            throw new ArgumentNullException();
        }
        if (this.getHandler() instanceof PrimitiveHandler) {
            return ((PrimitiveHandler)this.getHandler()).coerce(valueClass, value);
        }
        if (!this.canHold(valueClass)) {
            return No4.INSTANCE;
        }
        return value;
    }

    public final boolean canLoadByIndex() {
        return Handlers4.canLoadFieldByIndex(this.getHandler());
    }

    public final void cascadeActivation(ActivationContext context) {
        if (!this.alive()) {
            return;
        }
        Object cascadeTo = this.cascadingTarget(context);
        if (cascadeTo == null) {
            return;
        }
        ActivationContext cascadeContext = context.forObject(cascadeTo);
        ClassMetadata classMetadata = cascadeContext.classMetadata();
        if (classMetadata == null) {
            return;
        }
        this.ensureObjectIsActive(cascadeContext);
        Handlers4.cascadeActivation(cascadeContext, classMetadata.typeHandler());
    }

    private void ensureObjectIsActive(ActivationContext context) {
        if (!context.depth().mode().isActivate()) {
            return;
        }
        if (Handlers4.isValueType(this.getHandler())) {
            return;
        }
        ObjectContainerBase container = context.container();
        ClassMetadata classMetadata = container.classMetadataForObject(context.targetObject());
        if (classMetadata == null || !classMetadata.hasIdentity()) {
            return;
        }
        if (container.isActive(context.targetObject())) {
            return;
        }
        container.stillToActivate(context.descend());
    }

    protected final Object cascadingTarget(ActivationContext context) {
        if (context.depth().mode().isDeactivate()) {
            if (null == this._reflectField) {
                return null;
            }
            return this.fieldAccessor().get(this._reflectField, context.targetObject());
        }
        return this.getOrCreate(context.transaction(), context.targetObject());
    }

    private void checkDb4oType() {
        if (this._reflectField != null && this.container()._handlers.ICLASS_DB4OTYPE.isAssignableFrom(this._reflectField.getFieldType())) {
            this._db4oType = HandlerRegistry.getDb4oType(this._reflectField.getFieldType());
        }
    }

    void collectConstraints(Transaction trans, QConObject a_parent, Object a_template, Visitor4 a_visitor) {
        Object obj = this.getOn(trans, a_template);
        if (obj != null) {
            Collection4 objs = Platform4.flattenCollection(trans.container(), obj);
            Iterator4 j = objs.iterator();
            while (j.moveNext()) {
                Object nullValue;
                obj = j.current();
                if (obj == null) continue;
                if (this._isPrimitive && !this._isArray && obj.equals(nullValue = this._reflectField.getFieldType().nullValue())) {
                    return;
                }
                if (Platform4.ignoreAsConstraint(obj)) {
                    return;
                }
                if (a_parent.hasObjectInParentPath(obj)) continue;
                QConObject constraint = new QConObject(trans, a_parent, this.qField(trans), obj);
                constraint.byExample();
                a_visitor.visit(constraint);
            }
        }
    }

    public final void collectIDs(CollectIdContext context) throws FieldIndexException {
        if (!this.alive()) {
            this.incrementOffset(context.buffer());
            return;
        }
        TypeHandler4 handler = HandlerRegistry.correctHandlerVersion(context, this.getHandler());
        Handlers4.collectIdsInternal(context, handler, this.linkLength(), true);
    }

    void configure(ReflectClass clazz, boolean isPrimitive) {
        this._isArray = clazz.isArray();
        if (this._isArray) {
            ReflectArray reflectArray = this.reflector().array();
            this._isNArray = reflectArray.isNDimensional(clazz);
            this._isPrimitive = reflectArray.getComponentType(clazz).isPrimitive();
        } else {
            this._isPrimitive = isPrimitive | clazz.isPrimitive();
        }
    }

    protected final TypeHandler4 wrapHandlerToArrays(TypeHandler4 handler) {
        if (handler == null) {
            return null;
        }
        if (this._isNArray) {
            return new MultidimensionalArrayHandler(handler, this.arraysUsePrimitiveClassReflector());
        }
        if (this._isArray) {
            return new ArrayHandler(handler, this.arraysUsePrimitiveClassReflector());
        }
        return handler;
    }

    private boolean arraysUsePrimitiveClassReflector() {
        return this._isPrimitive;
    }

    public void deactivate(ActivationContext context) {
        if (!this.alive() || !this.shouldStoreField()) {
            return;
        }
        boolean isEnumClass = this._containingClass.isEnum();
        if (this._isPrimitive && !this._isArray) {
            if (!isEnumClass) {
                Object nullValue = this._reflectField.getFieldType().nullValue();
                this.fieldAccessor().set(this._reflectField, context.targetObject(), nullValue);
            }
            return;
        }
        if (context.depth().requiresActivation()) {
            this.cascadeActivation(context);
        }
        if (!isEnumClass) {
            this.fieldAccessor().set(this._reflectField, context.targetObject(), null);
        }
    }

    private FieldAccessor fieldAccessor() {
        return this._containingClass.fieldAccessor();
    }

    public void delete(DeleteContextImpl context, boolean isUpdate) throws FieldIndexException {
        if (!this.checkAlive(context)) {
            return;
        }
        try {
            this.removeIndexEntry(context);
            if (isUpdate) {
                this.incrementOffset(context);
                return;
            }
            StatefulBuffer buffer = (StatefulBuffer)context.buffer();
            final DeleteContextImpl childContext = new DeleteContextImpl(context, this.getStoredType(), this._config);
            context.slotFormat().doWithSlotIndirection(buffer, this.getHandler(), new Closure4(){

                public Object run() {
                    childContext.delete(FieldMetadata.this.getHandler());
                    return null;
                }
            });
        }
        catch (CorruptionException exc) {
            throw new FieldIndexException(exc, this);
        }
    }

    private final void removeIndexEntry(DeleteContextImpl context) throws CorruptionException, Db4oIOException {
        if (!this.hasIndex()) {
            return;
        }
        int offset = context.offset();
        Object obj = this.readIndexEntry(context);
        this.removeIndexEntry(context.transaction(), context.objectId(), obj);
        context.seek(offset);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldMetadata)) {
            return false;
        }
        FieldMetadata other = (FieldMetadata)obj;
        other.alive();
        this.alive();
        return other._isPrimitive == this._isPrimitive && other._fieldType == this._fieldType && other._name.equals(this._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public final Object get(Object onObject) {
        return this.get(null, onObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(Transaction trans, Object onObject) {
        if (this._containingClass == null) {
            return null;
        }
        ObjectContainerBase container = this.container();
        if (container == null) {
            return null;
        }
        Object object = container.lock();
        synchronized (object) {
            if (trans == null) {
                trans = container.transaction();
            }
            container.checkClosed();
            ObjectReference ref = trans.referenceForObject(onObject);
            if (ref == null) {
                return null;
            }
            int id = ref.getID();
            if (id <= 0) {
                return null;
            }
            UnmarshallingContext context = new UnmarshallingContext(trans, ref, 1, false);
            context.activationDepth(new LegacyActivationDepth(1));
            return context.readFieldValue(this);
        }
    }

    public String getName() {
        return this._name;
    }

    public final ClassMetadata fieldType() {
        return this._fieldType;
    }

    public TypeHandler4 getHandler() {
        if (this._fieldType == null) {
            return null;
        }
        return this.wrapHandlerToArrays(this._fieldType.typeHandler());
    }

    public int fieldTypeID() {
        return this._fieldTypeID;
    }

    public Object getOn(Transaction trans, Object onObject) {
        if (this.alive()) {
            return this.fieldAccessor().get(this._reflectField, onObject);
        }
        return null;
    }

    public Object getOrCreate(Transaction trans, Object onObject) {
        if (!this.alive()) {
            return null;
        }
        Object obj = this.fieldAccessor().get(this._reflectField, onObject);
        if (this._db4oType != null && obj == null) {
            obj = this._db4oType.createDefault(trans);
            this.fieldAccessor().set(this._reflectField, onObject, obj);
        }
        return obj;
    }

    public final ClassMetadata containingClass() {
        return this._containingClass;
    }

    public ReflectClass getStoredType() {
        if (this._reflectField == null) {
            return null;
        }
        return Handlers4.baseType(this._reflectField.getFieldType());
    }

    public ObjectContainerBase container() {
        if (this._containingClass == null) {
            return null;
        }
        return this._containingClass.container();
    }

    public boolean hasConfig() {
        return this._config != null;
    }

    public boolean hasIndex() {
        return this._index != null;
    }

    public final void init(String name) {
        this._name = name;
        this.initConfiguration(name);
    }

    final void initConfiguration(String name) {
        Config4Class containingClassConfig = this._containingClass.config();
        if (containingClassConfig == null) {
            return;
        }
        this._config = containingClassConfig.configField(name);
    }

    public void init(String name, int fieldTypeID, boolean isPrimitive, boolean isArray, boolean isNArray) {
        this._fieldTypeID = fieldTypeID;
        this._isPrimitive = isPrimitive;
        this._isArray = isArray;
        this._isNArray = isNArray;
        this.init(name);
        this.loadFieldTypeById();
        this.alive();
    }

    final void initConfigOnUp(Transaction trans) {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        if (this._config != null) {
            this._config.initOnUp(trans, this);
        }
    }

    public void activate(UnmarshallingContext context) {
        if (!this.checkAlive(context)) {
            return;
        }
        if (!this.shouldStoreField()) {
            this.incrementOffset(context);
            return;
        }
        Object toSet = this.read(context);
        this.informAboutTransaction(toSet, context.transaction());
        this.set(context.persistentObject(), toSet);
    }

    public void attemptUpdate(UnmarshallingContext context) {
        if (!this.updating()) {
            this.incrementOffset(context);
            return;
        }
        int savedOffset = context.offset();
        try {
            Object toSet = context.read(this.getHandler());
            if (toSet != null) {
                this.set(context.persistentObject(), toSet);
            }
        }
        catch (Exception ex) {
            context.buffer().seek(savedOffset);
            this.incrementOffset(context);
        }
    }

    private boolean checkAlive(AspectVersionContext context) {
        if (!this.checkEnabled(context)) {
            return false;
        }
        boolean alive = this.alive();
        if (!alive) {
            this.incrementOffset((ReadBuffer)((Object)context));
        }
        return alive;
    }

    private void informAboutTransaction(Object obj, Transaction trans) {
        if (this._db4oType != null && obj != null) {
            ((Db4oTypeImpl)obj).setTrans(trans);
        }
    }

    public boolean isArray() {
        return this._isArray;
    }

    public int linkLength() {
        this.alive();
        if (this._linkLength == 0) {
            this._linkLength = this.calculateLinkLength();
        }
        return this._linkLength;
    }

    private int calculateLinkLength() {
        return Handlers4.calculateLinkLength(this.getHandler());
    }

    public void loadFieldTypeById() {
        this._fieldType = this.container().classMetadataForID(this._fieldTypeID);
    }

    private ClassMetadata detectFieldType() {
        ReflectClass claxx = this._containingClass.classReflector();
        if (claxx == null) {
            return null;
        }
        this._reflectField = claxx.getDeclaredField(this._name);
        if (this._reflectField == null) {
            return null;
        }
        ReflectClass fieldType = this._reflectField.getFieldType();
        if (fieldType == null) {
            return null;
        }
        return Handlers4.erasedFieldType(this.container(), fieldType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeHandler4 typeHandlerForClass(ObjectContainerBase container, ReflectClass fieldType) {
        container.showInternalClasses(true);
        try {
            TypeHandler4 typeHandler4 = container.typeHandlerForClass(Handlers4.baseType(fieldType));
            return typeHandler4;
        }
        finally {
            container.showInternalClasses(false);
        }
    }

    private void checkCorrectTypeForField() {
        ClassMetadata currentFieldType = this.detectFieldType();
        if (currentFieldType == null) {
            this._reflectField = null;
            this._state = FieldMetadataState.UNAVAILABLE;
            return;
        }
        if (currentFieldType == this._fieldType && Handlers4.baseType(this._reflectField.getFieldType()).isPrimitive() == this._isPrimitive) {
            return;
        }
        if (Handlers4.isUntyped(currentFieldType.typeHandler()) && Handlers4.isUntyped(this._fieldType.typeHandler())) {
            return;
        }
        this._state = FieldMetadataState.UPDATING;
    }

    private UpdateDepth adjustUpdateDepthForCascade(Object obj, UpdateDepth updateDepth) {
        return updateDepth.adjustUpdateDepthForCascade(this._containingClass.isCollection(obj));
    }

    private boolean cascadeOnUpdate(Config4Class parentClassConfiguration) {
        return parentClassConfiguration != null && parentClassConfiguration.cascadeOnUpdate().definiteYes() || this._config != null && this._config.cascadeOnUpdate().definiteYes();
    }

    public void marshall(MarshallingContext context, Object obj) {
        UpdateDepth updateDepth = context.updateDepth();
        if (obj != null && this.cascadeOnUpdate(context.classConfiguration())) {
            context.updateDepth(this.adjustUpdateDepthForCascade(obj, updateDepth));
        }
        context.writeObjectWithCurrentState(this.getHandler(), obj);
        context.updateDepth(updateDepth);
        if (this.hasIndex()) {
            context.addIndexEntry(this, obj);
        }
    }

    public boolean needsArrayAndPrimitiveInfo() {
        return true;
    }

    public PreparedComparison prepareComparison(Context context, Object obj) {
        if (!this.alive()) {
            return null;
        }
        return Handlers4.prepareComparisonFor(this.getHandler(), context, obj);
    }

    public QField qField(Transaction a_trans) {
        int classMetadataID = 0;
        if (this._containingClass != null) {
            classMetadataID = this._containingClass.getID();
        }
        return new QField(a_trans, this._name, this, classMetadataID, this._handle);
    }

    public Object read(ObjectIdContext context) {
        if (!this.canReadFromSlot((AspectVersionContext)((Object)context))) {
            this.incrementOffset(context);
            return null;
        }
        return context.read(this.getHandler());
    }

    private boolean canReadFromSlot(AspectVersionContext context) {
        if (!this.isEnabledOn(context)) {
            return false;
        }
        if (this.alive()) {
            return true;
        }
        return this._state != FieldMetadataState.NOT_LOADED;
    }

    void refresh() {
        ClassMetadata newFieldType = this.detectFieldType();
        if (newFieldType != null && newFieldType.equals(this._fieldType)) {
            return;
        }
        this._reflectField = null;
        this._state = FieldMetadataState.UNAVAILABLE;
    }

    public void rename(String newName) {
        ObjectContainerBase container = this.container();
        if (!container.isClient()) {
            this._name = newName;
            this._containingClass.setStateDirty();
            this._containingClass.write(container.systemTransaction());
        } else {
            Exceptions4.throwRuntimeException(58);
        }
    }

    public void set(Object onObject, Object obj) {
        if (null == this._reflectField) {
            return;
        }
        this.fieldAccessor().set(this._reflectField, onObject, obj);
    }

    void setName(String a_name) {
        this._name = a_name;
    }

    boolean supportsIndex() {
        return this.alive() && this.getHandler() instanceof Indexable4 && !Handlers4.isUntyped(this.getHandler());
    }

    public final void traverseValues(Visitor4 userVisitor) {
        if (!this.alive()) {
            return;
        }
        this.traverseValues(this.container().transaction(), userVisitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traverseValues(Transaction transaction, final Visitor4 userVisitor) {
        if (!this.alive()) {
            return;
        }
        this.assertHasIndex();
        ObjectContainerBase stream = transaction.container();
        if (stream.isClient()) {
            Exceptions4.throwRuntimeException(67);
        }
        Object object = stream.lock();
        synchronized (object) {
            final Context context = transaction.context();
            this._index.traverseKeys(transaction, new Visitor4(){

                public void visit(Object obj) {
                    FieldIndexKey key = (FieldIndexKey)obj;
                    userVisitor.visit(((IndexableTypeHandler)FieldMetadata.this.getHandler()).indexEntryToObject(context, key.value()));
                }
            });
        }
    }

    private void assertHasIndex() {
        if (!this.hasIndex()) {
            Exceptions4.throwRuntimeException(66);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this._containingClass != null) {
            sb.append(this._containingClass.getName());
            sb.append(".");
        }
        sb.append(this.getName());
        return sb.toString();
    }

    private void initIndex(Transaction systemTrans) {
        this.initIndex(systemTrans, 0);
    }

    public void initIndex(Transaction systemTrans, int id) {
        if (this._index != null) {
            throw new IllegalStateException();
        }
        if (systemTrans.container().isClient()) {
            return;
        }
        this._index = this.newBTree(systemTrans, id);
    }

    protected final BTree newBTree(Transaction systemTrans, int id) {
        ObjectContainerBase stream = systemTrans.container();
        Indexable4 indexHandler = this.indexHandler(stream);
        if (indexHandler == null) {
            return null;
        }
        return new BTree(systemTrans, id, (Indexable4)new FieldIndexKeyHandler(indexHandler));
    }

    protected Indexable4 indexHandler(ObjectContainerBase stream) {
        if (this._reflectField == null) {
            return null;
        }
        ReflectClass indexType = this._reflectField.indexType();
        TypeHandler4 classHandler = this.typeHandlerForClass(stream, indexType);
        if (!(classHandler instanceof Indexable4)) {
            return null;
        }
        return (Indexable4)((Object)classHandler);
    }

    public BTree getIndex(Transaction trans) {
        return this._index;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isPrimitive() {
        return this._isPrimitive;
    }

    public BTreeRange search(Transaction transaction, Object value) {
        this.assertHasIndex();
        Object transActionalValue = Handlers4.wrapWithTransactionContext(transaction, value, this.getHandler());
        BTreeNodeSearchResult lowerBound = this.searchLowerBound(transaction, transActionalValue);
        BTreeNodeSearchResult upperBound = this.searchUpperBound(transaction, transActionalValue);
        return lowerBound.createIncludingRange(upperBound);
    }

    private BTreeNodeSearchResult searchUpperBound(Transaction transaction, Object value) {
        return this.searchBound(transaction, Integer.MAX_VALUE, value);
    }

    private BTreeNodeSearchResult searchLowerBound(Transaction transaction, Object value) {
        return this.searchBound(transaction, 0, value);
    }

    private BTreeNodeSearchResult searchBound(Transaction transaction, int parentID, Object keyPart) {
        return this.getIndex(transaction).searchLeaf(transaction, this.createFieldIndexKey(parentID, keyPart), SearchTarget.LOWEST);
    }

    public boolean rebuildIndexForClass(LocalObjectContainer stream, ClassMetadata classMetadata) {
        long[] ids = classMetadata.getIDs();
        for (int i = 0; i < ids.length; ++i) {
            this.rebuildIndexForObject(stream, classMetadata, (int)ids[i]);
        }
        return ids.length > 0;
    }

    protected void rebuildIndexForObject(LocalObjectContainer stream, ClassMetadata classMetadata, int objectId) throws FieldIndexException {
        StatefulBuffer writer = stream.readStatefulBufferById(stream.systemTransaction(), objectId);
        if (writer != null) {
            this.rebuildIndexForWriter(stream, writer, objectId);
        }
    }

    protected void rebuildIndexForWriter(LocalObjectContainer stream, StatefulBuffer writer, int objectId) {
        ObjectHeader oh = new ObjectHeader(stream, (ReadWriteBuffer)writer);
        Object obj = this.readIndexEntryForRebuild(writer, oh);
        this.addIndexEntry(stream.systemTransaction(), objectId, obj);
    }

    private final Object readIndexEntryForRebuild(StatefulBuffer writer, ObjectHeader oh) {
        ClassMetadata classMetadata = oh.classMetadata();
        if (classMetadata == null) {
            return this.defaultValueForFieldType();
        }
        ObjectIdContextImpl context = new ObjectIdContextImpl(writer.transaction(), writer, oh, writer.getID());
        if (!classMetadata.seekToField(context, this)) {
            return this.defaultValueForFieldType();
        }
        try {
            return this.readIndexEntry(context);
        }
        catch (CorruptionException exc) {
            throw new FieldIndexException(exc, this);
        }
    }

    private Object defaultValueForFieldType() {
        TypeHandler4 handler = this._fieldType.typeHandler();
        return handler instanceof PrimitiveHandler ? ((PrimitiveHandler)handler).primitiveNull() : null;
    }

    public final void dropIndex(LocalTransaction systemTrans) {
        if (this._index == null) {
            return;
        }
        ObjectContainerBase stream = systemTrans.container();
        if (stream.configImpl().messageLevel() > 0) {
            stream.message("dropping index " + this.toString());
        }
        this._index.free(systemTrans);
        stream.setDirtyInSystemTransaction(this.containingClass());
        this._index = null;
    }

    public void defragAspect(final DefragmentContext context) {
        if (!this.canDefragment()) {
            throw new IllegalStateException("Field '" + this.toString() + "' cannot be defragmented at this time.");
        }
        final TypeHandler4 correctTypeHandlerVersion = HandlerRegistry.correctHandlerVersion(context, this.getHandler(), this._fieldType);
        context.slotFormat().doWithSlotIndirection(context, correctTypeHandlerVersion, new Closure4(){

            public Object run() {
                context.defragment(correctTypeHandlerVersion);
                return null;
            }
        });
    }

    private boolean canDefragment() {
        if (this.alive() || this.updating()) {
            return true;
        }
        if (this._fieldType == null || this.getHandler() == null) {
            return false;
        }
        return !this._fieldType.stateDead();
    }

    public void createIndex() {
        if (this.hasIndex()) {
            return;
        }
        LocalObjectContainer container = (LocalObjectContainer)this.container();
        if (container.configImpl().messageLevel() > 0) {
            container.message("creating index " + this.toString());
        }
        this.initIndex(container.systemTransaction());
        container.setDirtyInSystemTransaction(this.containingClass());
        this.reindex(container);
    }

    private void reindex(LocalObjectContainer container) {
        ClassMetadata clazz = this.containingClass();
        if (this.rebuildIndexForClass(container, clazz)) {
            container.systemTransaction().commit();
        }
    }

    public AspectType aspectType() {
        return AspectType.FIELD;
    }

    public boolean canBeDisabled() {
        return true;
    }

    public void dropIndex() {
        this.dropIndex((LocalTransaction)this.container().systemTransaction());
    }
}

