/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.reflect.ReflectClass;

class ObjectAnalyzer {
    private final ObjectContainerBase _container;
    private final Object _obj;
    private ClassMetadata _classMetadata;
    private ObjectReference _ref;
    private boolean _notStorable;

    ObjectAnalyzer(ObjectContainerBase container, Object obj) {
        this._container = container;
        this._obj = obj;
    }

    void analyze(Transaction trans) {
        this._ref = trans.referenceForObject(this._obj);
        if (this._ref != null) {
            this._classMetadata = this._ref.classMetadata();
            return;
        }
        ReflectClass claxx = this._container.reflector().forObject(this._obj);
        if (claxx == null) {
            this.notStorable(this._obj, claxx);
            return;
        }
        if (!this.detectClassMetadata(trans, claxx)) {
            return;
        }
        if (this.isValueType(this._classMetadata)) {
            this.notStorable(this._obj, this._classMetadata.classReflector());
        }
    }

    private boolean detectClassMetadata(Transaction trans, ReflectClass claxx) {
        this._classMetadata = this._container.getActiveClassMetadata(claxx);
        if (this._classMetadata != null) {
            if (!this._classMetadata.isStorable()) {
                this.notStorable(this._obj, claxx);
                return false;
            }
            return true;
        }
        this._classMetadata = this._container.produceClassMetadata(claxx);
        if (this._classMetadata == null || !this._classMetadata.isStorable()) {
            this.notStorable(this._obj, claxx);
            return false;
        }
        this._ref = trans.referenceForObject(this._obj);
        return true;
    }

    private void notStorable(Object obj, ReflectClass claxx) {
        this._container.notStorable(claxx, obj);
        this._notStorable = true;
    }

    boolean notStorable() {
        return this._notStorable;
    }

    private final boolean isValueType(ClassMetadata classMetadata) {
        return classMetadata.isValueType();
    }

    ObjectReference objectReference() {
        return this._ref;
    }

    public ClassMetadata classMetadata() {
        return this._classMetadata;
    }
}

