/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalPersistentBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.slots.SlotChangeFactory;

public class PersistentIntegerArray
extends LocalPersistentBase {
    private final SlotChangeFactory _slotChangeFactory;
    private int[] _ints;

    public PersistentIntegerArray(SlotChangeFactory slotChangeFactory, TransactionalIdSystem idSystem, int[] arr) {
        super(idSystem);
        this._slotChangeFactory = slotChangeFactory;
        this._ints = new int[arr.length];
        System.arraycopy(arr, 0, this._ints, 0, arr.length);
    }

    public PersistentIntegerArray(SlotChangeFactory slotChangeFactory, TransactionalIdSystem idSystem, int id) {
        super(idSystem);
        this._slotChangeFactory = slotChangeFactory;
        this.setID(id);
    }

    public byte getIdentifier() {
        return 73;
    }

    public int ownLength() {
        return 4 * (this.size() + 1) + 0;
    }

    public void readThis(Transaction trans, ByteArrayBuffer reader) {
        int length = reader.readInt();
        this._ints = new int[length];
        for (int i = 0; i < length; ++i) {
            this._ints[i] = reader.readInt();
        }
    }

    public void writeThis(Transaction trans, ByteArrayBuffer writer) {
        writer.writeInt(this.size());
        for (int i = 0; i < this._ints.length; ++i) {
            writer.writeInt(this._ints[i]);
        }
    }

    private int size() {
        return this._ints.length;
    }

    public int[] array() {
        return this._ints;
    }

    public SlotChangeFactory slotChangeFactory() {
        return this._slotChangeFactory;
    }
}

