/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.config.Configuration;
import com.db4o.ext.DatabaseClosedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.OldFormatException;
import com.db4o.foundation.NotSupportedException;
import com.db4o.foundation.Runnable4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.ExternalObjectContainer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionObjectCarrier;
import com.db4o.internal.activation.UpdateDepth;
import com.db4o.internal.ids.TransportIdSystem;
import com.db4o.internal.references.HashcodeReferenceSystem;
import com.db4o.internal.references.ReferenceSystem;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.weakref.WeakReferenceSupportFactory;
import com.db4o.io.MemoryBin;
import com.db4o.io.Storage;
import com.db4o.reflect.ReflectClass;
import com.db4o.types.Db4oType;

public class TransportObjectContainer
extends LocalObjectContainer {
    private final ObjectContainerBase _parent;
    private final MemoryBin _memoryBin;

    public TransportObjectContainer(ObjectContainerBase parent, MemoryBin memoryFile) {
        super(parent.config());
        this._memoryBin = memoryFile;
        this._parent = parent;
        this._lock = parent.lock();
        this._showInternalClasses = parent._showInternalClasses;
        this.open();
    }

    protected void initialize1(Configuration config) {
        this._handlers = this._parent._handlers;
        this._classCollection = this._parent.classCollection();
        this._config = this._parent.configImpl();
        this._references = WeakReferenceSupportFactory.disabledWeakReferenceSupport();
    }

    protected void initializeClassMetadataRepository() {
    }

    protected void initalizeWeakReferenceSupport() {
    }

    void initializeEssentialClasses() {
    }

    protected void initializePostOpenExcludingTransportObjectContainer() {
    }

    void initNewClassCollection() {
    }

    boolean canUpdate() {
        return false;
    }

    public ClassMetadata classMetadataForID(int id) {
        return this._parent.classMetadataForID(id);
    }

    void configureNewFile() {
    }

    public int converterVersion() {
        return 12;
    }

    protected void dropReferences() {
        this._config = null;
    }

    protected void handleExceptionOnClose(Exception exc) {
    }

    public final Transaction newTransaction(Transaction parentTransaction, ReferenceSystem referenceSystem, boolean isSystemTransaction) {
        if (null != parentTransaction) {
            return parentTransaction;
        }
        return new TransactionObjectCarrier(this, null, new TransportIdSystem(this), referenceSystem);
    }

    public long currentVersion() {
        return 0L;
    }

    public Db4oType db4oTypeStored(Transaction a_trans, Object a_object) {
        return null;
    }

    public boolean dispatchsEvents() {
        return false;
    }

    protected void finalize() {
    }

    public final void free(int a_address, int a_length) {
    }

    public final void free(Slot slot) {
    }

    public Slot allocateSlot(int length) {
        return this.appendBytes(length);
    }

    protected boolean isValidPointer(int id) {
        return id != 0 && super.isValidPointer(id);
    }

    public Db4oDatabase identity() {
        return ((ExternalObjectContainer)this._parent).identity();
    }

    public boolean maintainsIndices() {
        return false;
    }

    public long generateTimeStampId() {
        return this._parent.generateTimeStampId();
    }

    void message(String msg) {
    }

    public ClassMetadata produceClassMetadata(ReflectClass claxx) {
        return this._parent.produceClassMetadata(claxx);
    }

    public void raiseCommitTimestamp(long a_minimumVersion) {
    }

    void readThis() {
    }

    boolean stateMessages() {
        return false;
    }

    public void shutdown() {
        this.processPendingClassUpdates();
        this.writeDirtyClassMetadata();
        this.transaction().commit();
    }

    public final void writeHeader(boolean startFileLockingThread, boolean shuttingDown) {
    }

    public int storeInternal(Transaction trans, Object obj, UpdateDepth depth, boolean checkJustSet) throws DatabaseClosedException, DatabaseReadOnlyException {
        int id = this._parent.getID(null, obj);
        if (id > 0) {
            return super.storeInternal(trans, new KnownObjectIdentity(id), depth, checkJustSet);
        }
        return super.storeInternal(trans, obj, depth, checkJustSet);
    }

    public Object getByID2(Transaction ta, int id) {
        Object obj = super.getByID2(ta, id);
        if (obj instanceof KnownObjectIdentity) {
            KnownObjectIdentity oi = (KnownObjectIdentity)obj;
            this.activate(oi);
            obj = this._parent.getByID(null, oi._id);
        }
        return obj;
    }

    public void deferredOpen() {
        this.open();
    }

    protected final void openImpl() throws OldFormatException {
        this.createIdSystem();
        if (this._memoryBin.length() == 0L) {
            this.configureNewFile();
            this.commitTransaction();
        } else {
            this.readThis();
        }
    }

    public void backup(Storage targetStorage, String path) throws NotSupportedException {
        throw new NotSupportedException();
    }

    public void blockSize(int size) {
    }

    public void closeTransaction(Transaction transaction, boolean isSystemTransaction, boolean rollbackOnClose) {
    }

    protected void shutdownDataStorage() {
        this.dropReferences();
    }

    public long fileLength() {
        return this._memoryBin.length();
    }

    public String fileName() {
        return "Memory File";
    }

    protected boolean hasShutDownHook() {
        return false;
    }

    public final boolean needsLockFileThread() {
        return false;
    }

    public void readBytes(byte[] bytes, int address, int length) {
        try {
            this._memoryBin.read(address, bytes, length);
        }
        catch (Exception e) {
            Exceptions4.throwRuntimeException(13, e);
        }
    }

    public void readBytes(byte[] bytes, int address, int addressOffset, int length) {
        this.readBytes(bytes, address + addressOffset, length);
    }

    public void syncFiles() {
    }

    public void writeBytes(ByteArrayBuffer buffer, int address, int addressOffset) {
        this._memoryBin.write(address + addressOffset, buffer._buffer, buffer.length());
    }

    public void overwriteDeletedBytes(int a_address, int a_length) {
    }

    public void reserve(int byteCount) {
        throw new NotSupportedException();
    }

    public byte blockSize() {
        return 1;
    }

    protected void fatalStorageShutdown() {
        this.shutdownDataStorage();
    }

    public ReferenceSystem createReferenceSystem() {
        return new HashcodeReferenceSystem();
    }

    protected void createIdSystem() {
    }

    public Runnable commitHook() {
        return Runnable4.DO_NOTHING;
    }

    public void syncFiles(Runnable runnable) {
        runnable.run();
    }

    public static class KnownObjectIdentity {
        public int _id;

        public KnownObjectIdentity(int id) {
            this._id = id;
        }
    }
}

