/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Tree;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Readable;

public final class TreeReader {
    private final Readable i_template;
    private final ByteArrayBuffer i_bytes;
    private int i_current = 0;
    private int i_levels = 0;
    private int i_size;
    private boolean i_orderOnRead;

    public TreeReader(ByteArrayBuffer a_bytes, Readable a_template) {
        this(a_bytes, a_template, false);
    }

    public TreeReader(ByteArrayBuffer a_bytes, Readable a_template, boolean a_orderOnRead) {
        this.i_template = a_template;
        this.i_bytes = a_bytes;
        this.i_orderOnRead = a_orderOnRead;
    }

    public Tree read() {
        return this.read(this.i_bytes.readInt());
    }

    public Tree read(int a_size) {
        this.i_size = a_size;
        if (this.i_size > 0) {
            if (this.i_orderOnRead) {
                Tree tree = null;
                for (int i = 0; i < this.i_size; ++i) {
                    tree = Tree.add(tree, (Tree)this.i_template.read(this.i_bytes));
                }
                return tree;
            }
            while (1 << this.i_levels < this.i_size + 1) {
                ++this.i_levels;
            }
            return this.linkUp(null, this.i_levels);
        }
        return null;
    }

    private final Tree linkUp(Tree a_preceding, int a_level) {
        Tree node = (Tree)this.i_template.read(this.i_bytes);
        ++this.i_current;
        node._preceding = a_preceding;
        node._subsequent = this.linkDown(a_level + 1);
        node.calculateSize();
        if (this.i_current < this.i_size) {
            return this.linkUp(node, a_level - 1);
        }
        return node;
    }

    private final Tree linkDown(int a_level) {
        if (this.i_current < this.i_size) {
            ++this.i_current;
            if (a_level < this.i_levels) {
                Tree preceding = this.linkDown(a_level + 1);
                Tree node = (Tree)this.i_template.read(this.i_bytes);
                node._preceding = preceding;
                node._subsequent = this.linkDown(a_level + 1);
                node.calculateSize();
                return node;
            }
            return (Tree)this.i_template.read(this.i_bytes);
        }
        return null;
    }
}

