/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.Iterator4;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreePointer;

public class BTreeIterator
implements Iterator4 {
    private final Transaction _transaction;
    private final BTree _bTree;
    private BTreePointer _currentPointer;
    private boolean _beyondEnd;

    public BTreeIterator(Transaction trans, BTree bTree) {
        this._transaction = trans;
        this._bTree = bTree;
    }

    public Object current() {
        if (this._currentPointer == null) {
            throw new IllegalStateException();
        }
        return this._currentPointer.key();
    }

    public boolean moveNext() {
        if (this._beyondEnd) {
            return false;
        }
        this._currentPointer = this.beforeFirst() ? this._bTree.firstPointer(this._transaction) : this._currentPointer.next();
        this._beyondEnd = this._currentPointer == null;
        return !this._beyondEnd;
    }

    private boolean beforeFirst() {
        return this._currentPointer == null;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }
}

