/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.DTrace;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.PersistentIntegerArray;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeConfiguration;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.freespace.AbstractFreespaceManager;
import com.db4o.internal.freespace.AddressKeySlotHandler;
import com.db4o.internal.freespace.FreespaceListener;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.freespace.InMemoryFreespaceManager;
import com.db4o.internal.freespace.LengthKeySlotHandler;
import com.db4o.internal.freespace.NullFreespaceListener;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChangeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeFreespaceManager
extends AbstractFreespaceManager {
    private final LocalObjectContainer _file;
    private InMemoryFreespaceManager _delegate;
    private BTree _slotsByAddress;
    private BTree _slotsByLength;
    private PersistentIntegerArray _idArray;
    private int _delegationRequests;
    private FreespaceListener _listener = NullFreespaceListener.INSTANCE;
    private TransactionalIdSystem _idSystem;

    public BTreeFreespaceManager(LocalObjectContainer file, Procedure4<Slot> slotFreedCallback, int discardLimit) {
        super(slotFreedCallback, discardLimit);
        this._file = file;
        this._delegate = new InMemoryFreespaceManager(slotFreedCallback, discardLimit);
        this._idSystem = file.systemData().freespaceIdSystem();
    }

    private void addSlot(Slot slot) {
        this._slotsByLength.add(this.transaction(), slot);
        this._slotsByAddress.add(this.transaction(), slot);
        this._listener.slotAdded(slot.length());
    }

    @Override
    public Slot allocateSafeSlot(int length) {
        return this._delegate.allocateSafeSlot(length);
    }

    @Override
    public void beginCommit() {
        this.beginDelegation();
    }

    private void beginDelegation() {
        ++this._delegationRequests;
    }

    @Override
    public void commit() {
        this._slotsByAddress.commit(this.transaction());
        this._slotsByLength.commit(this.transaction());
    }

    private void createBTrees(int addressID, int lengthID) {
        BTreeConfiguration config = new BTreeConfiguration(this._idSystem, SlotChangeFactory.FREE_SPACE, 64, false);
        this._slotsByAddress = new BTree((Transaction)this.transaction(), config, addressID, new AddressKeySlotHandler());
        this._slotsByLength = new BTree((Transaction)this.transaction(), config, lengthID, new LengthKeySlotHandler());
    }

    @Override
    public void endCommit() {
        this.endDelegation();
    }

    private void endDelegation() {
        --this._delegationRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(Slot slot) {
        if (!this.isStarted()) {
            return;
        }
        if (this.isDelegating()) {
            this._delegate.free(slot);
            return;
        }
        try {
            Slot nextSlot;
            Slot previousSlot;
            BTreePointer previousPointer;
            this.beginDelegation();
            if (DTrace.enabled) {
                DTrace.FREESPACEMANAGER_BTREE_FREE.logLength((long)slot.address(), slot.length());
            }
            Slot[] remove = new Slot[2];
            Slot newFreeSlot = slot;
            BTreePointer pointer = this.searchBTree(this._slotsByAddress, slot, SearchTarget.LOWEST);
            BTreePointer bTreePointer = previousPointer = pointer != null ? pointer.previous() : this._slotsByAddress.lastPointer(this.transaction());
            if (previousPointer != null && (previousSlot = (Slot)previousPointer.key()).isDirectlyPreceding(newFreeSlot)) {
                remove[0] = previousSlot;
                newFreeSlot = previousSlot.append(newFreeSlot);
            }
            if (pointer != null && newFreeSlot.isDirectlyPreceding(nextSlot = (Slot)pointer.key())) {
                remove[1] = nextSlot;
                newFreeSlot = newFreeSlot.append(nextSlot);
            }
            for (int i = 0; i < remove.length; ++i) {
                if (remove[i] == null) continue;
                this.removeSlot(remove[i]);
            }
            if (!this.canDiscard(newFreeSlot.length())) {
                this.addSlot(newFreeSlot);
            }
            this.slotFreed(slot);
        }
        finally {
            this.endDelegation();
        }
    }

    @Override
    public void freeSelf() {
        this._slotsByAddress.free(this.transaction());
        this._slotsByLength.free(this.transaction());
    }

    @Override
    public void freeSafeSlot(Slot slot) {
        this._delegate.freeSafeSlot(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slot allocateSlot(int length) {
        if (!this.isStarted()) {
            return null;
        }
        if (this.isDelegating()) {
            return this._delegate.allocateSlot(length);
        }
        try {
            this.beginDelegation();
            BTreePointer pointer = this.searchBTree(this._slotsByLength, new Slot(0, length), SearchTarget.HIGHEST);
            if (pointer == null) {
                Slot slot = null;
                return slot;
            }
            Slot slot = (Slot)pointer.key();
            this.removeSlot(slot);
            int remainingLength = slot.length() - length;
            if (this.splitRemainder(remainingLength)) {
                this.addSlot(slot.subSlot(length));
                slot = slot.truncate(length);
            }
            if (DTrace.enabled) {
                DTrace.FREESPACEMANAGER_GET_SLOT.logLength((long)slot.address(), slot.length());
            }
            Slot slot2 = slot;
            return slot2;
        }
        finally {
            this.endDelegation();
        }
    }

    private void initializeExisting(int id) {
        this._idArray = new PersistentIntegerArray(SlotChangeFactory.FREE_SPACE, this._idSystem, id);
        this._idArray.read(this.transaction());
        int[] ids = this._idArray.array();
        int addressId = ids[0];
        int lengthID = ids[1];
        this.createBTrees(addressId, lengthID);
        this._slotsByAddress.read(this.transaction());
        this._slotsByLength.read(this.transaction());
        this._delegate.read(this._file, this._file.systemData().inMemoryFreespaceSlot());
    }

    private void initializeNew() {
        this.createBTrees(0, 0);
        this._slotsByAddress.write(this.transaction());
        this._slotsByLength.write(this.transaction());
        int[] ids = new int[]{this._slotsByAddress.getID(), this._slotsByLength.getID()};
        this._idArray = new PersistentIntegerArray(SlotChangeFactory.FREE_SPACE, this._idSystem, ids);
        this._idArray.write(this.transaction());
        this._file.systemData().bTreeFreespaceId(this._idArray.getID());
    }

    private boolean isDelegating() {
        return this._delegationRequests > 0;
    }

    public void read(LocalObjectContainer container, int freeSpaceID) {
    }

    private void removeSlot(Slot slot) {
        this._slotsByLength.remove(this.transaction(), slot);
        this._slotsByAddress.remove(this.transaction(), slot);
        this._listener.slotRemoved(slot.length());
    }

    private BTreePointer searchBTree(BTree bTree, Slot slot, SearchTarget target) {
        BTreeNodeSearchResult searchResult = bTree.searchLeaf((Transaction)this.transaction(), slot, target);
        return searchResult.firstValidPointer();
    }

    @Override
    public int slotCount() {
        return this._slotsByAddress.size(this.transaction()) + this._delegate.slotCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int id) {
        try {
            this.beginDelegation();
            if (id == 0) {
                this.initializeNew();
            } else {
                this.initializeExisting(id);
            }
        }
        finally {
            this.endDelegation();
        }
    }

    @Override
    public boolean isStarted() {
        return this._idArray != null;
    }

    @Override
    public byte systemType() {
        return 4;
    }

    public String toString() {
        return this._slotsByLength.toString();
    }

    @Override
    public int totalFreespace() {
        return super.totalFreespace() + this._delegate.totalFreespace();
    }

    public void traverse(Visitor4 visitor) {
        this._slotsByAddress.traverseKeys(this.transaction(), visitor);
    }

    @Override
    public void migrateTo(FreespaceManager fm) {
        super.migrateTo(fm);
        this._delegate.migrateTo(fm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LocalObjectContainer container) {
        try {
            this.beginDelegation();
            this._delegate.write(container);
            container.systemData().bTreeFreespaceId(this._idArray.getID());
        }
        finally {
            this.endDelegation();
        }
    }

    @Override
    public void listener(FreespaceListener listener) {
        this._listener = listener;
    }

    private final LocalTransaction transaction() {
        return (LocalTransaction)this._file.systemTransaction();
    }

    @Override
    public Slot allocateTransactionLogSlot(int length) {
        return this._delegate.allocateTransactionLogSlot(length);
    }

    @Override
    public void read(LocalObjectContainer container, Slot slot) {
    }
}

