/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.DTrace;
import com.db4o.ext.InvalidIDException;
import com.db4o.foundation.CancellableVisitor4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitable;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.SystemData;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeReader;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.ids.FreespaceCommitter;
import com.db4o.internal.ids.IdSlotTree;
import com.db4o.internal.ids.SequentialIdGenerator;
import com.db4o.internal.ids.StackableIdSystem;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryIdSystem
implements StackableIdSystem {
    private final LocalObjectContainer _container;
    private IdSlotTree _ids;
    private Slot _slot;
    private final SequentialIdGenerator _idGenerator;
    private int _childId;

    public InMemoryIdSystem(LocalObjectContainer container, final int maxValidId) {
        this._container = container;
        this._idGenerator = new SequentialIdGenerator(new Function4<Integer, Integer>(){

            @Override
            public Integer apply(Integer start) {
                return InMemoryIdSystem.this.findFreeId(start, maxValidId);
            }
        }, this._container.handlers().lowestValidId(), maxValidId);
    }

    public InMemoryIdSystem(LocalObjectContainer container) {
        this(container, Integer.MAX_VALUE);
        this.readThis();
    }

    private void readThis() {
        SystemData systemData = this._container.systemData();
        this._slot = systemData.idSystemSlot();
        if (!Slot.isNull(this._slot)) {
            ByteArrayBuffer buffer = this._container.readBufferBySlot(this._slot);
            this._childId = buffer.readInt();
            this._idGenerator.read(buffer);
            this._ids = (IdSlotTree)new TreeReader(buffer, new IdSlotTree(0, null)).read();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void commit(Visitable<SlotChange> slotChanges, FreespaceCommitter freespaceCommitter) {
        Slot oldSlot = this._slot;
        Slot reservedSlot = this.allocateSlot(false, this.estimatedSlotLength(this.estimateMappingCount(slotChanges)));
        freespaceCommitter.commit();
        slotChanges.accept(new Visitor4<SlotChange>(){

            @Override
            public void visit(SlotChange slotChange) {
                if (!slotChange.slotModified()) {
                    return;
                }
                if (slotChange.removeId()) {
                    InMemoryIdSystem.this._ids = (IdSlotTree)Tree.removeLike(InMemoryIdSystem.this._ids, new TreeInt(slotChange._key));
                    return;
                }
                if (DTrace.enabled) {
                    DTrace.SLOT_COMMITTED.logLength((long)slotChange._key, slotChange.newSlot());
                }
                InMemoryIdSystem.this._ids = Tree.add(InMemoryIdSystem.this._ids, new IdSlotTree(slotChange._key, slotChange.newSlot()));
            }
        });
        this.writeThis(reservedSlot);
        this.freeSlot(oldSlot);
    }

    private Slot allocateSlot(boolean appendToFile, int slotLength) {
        Slot slot;
        if (!appendToFile && (slot = this._container.freespaceManager().allocateSafeSlot(slotLength)) != null) {
            return slot;
        }
        return this._container.appendBytes(slotLength);
    }

    private int estimateMappingCount(Visitable<SlotChange> slotChanges) {
        final IntByRef count = new IntByRef();
        count.value = this._ids == null ? 0 : this._ids.size();
        slotChanges.accept(new Visitor4<SlotChange>(){

            @Override
            public void visit(SlotChange slotChange) {
                if (!slotChange.slotModified() || slotChange.removeId()) {
                    return;
                }
                ++count.value;
            }
        });
        return count.value;
    }

    private void writeThis(Slot reservedSlot) {
        Object xByteSlot = null;
        int slotLength = this.slotLength();
        if (reservedSlot.length() >= slotLength) {
            this._slot = reservedSlot;
            reservedSlot = null;
        } else {
            this._slot = this.allocateSlot(true, slotLength);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(this._slot.length());
        buffer.writeInt(this._childId);
        this._idGenerator.write(buffer);
        TreeInt.write(buffer, this._ids);
        this._container.writeBytes(buffer, this._slot.address(), 0);
        this._container.systemData().idSystemSlot(this._slot);
        Runnable commitHook = this._container.commitHook();
        this._container.syncFiles(commitHook);
        this.freeSlot(reservedSlot);
    }

    private void freeSlot(Slot slot) {
        if (Slot.isNull(slot)) {
            return;
        }
        FreespaceManager freespaceManager = this._container.freespaceManager();
        if (freespaceManager == null) {
            return;
        }
        freespaceManager.freeSafeSlot(slot);
    }

    private int slotLength() {
        return TreeInt.marshalledLength(this._ids) + this._idGenerator.marshalledLength() + 4;
    }

    private int estimatedSlotLength(int estimatedCount) {
        IdSlotTree template = this._ids;
        if (template == null) {
            template = new IdSlotTree(0, new Slot(0, 0));
        }
        return template.marshalledLength(estimatedCount) + this._idGenerator.marshalledLength() + 4;
    }

    @Override
    public Slot committedSlot(int id) {
        IdSlotTree idSlotMapping = (IdSlotTree)Tree.find(this._ids, new TreeInt(id));
        if (idSlotMapping == null) {
            throw new InvalidIDException(id);
        }
        return idSlotMapping.slot();
    }

    @Override
    public void completeInterruptedTransaction(int address, int length) {
    }

    @Override
    public int newId() {
        int id = this._idGenerator.newId();
        this._ids = Tree.add(this._ids, new IdSlotTree(id, Slot.ZERO));
        return id;
    }

    private int findFreeId(final int start, int end) {
        if (this._ids == null) {
            return start;
        }
        final IntByRef lastId = new IntByRef();
        final IntByRef freeId = new IntByRef();
        Tree.traverse(this._ids, new TreeInt(start), new CancellableVisitor4<TreeInt>(){

            @Override
            public boolean visit(TreeInt node) {
                int id = node._key;
                if (lastId.value == 0) {
                    if (id > start) {
                        freeId.value = start;
                        return false;
                    }
                    lastId.value = id;
                    return true;
                }
                if (id > lastId.value + 1) {
                    freeId.value = lastId.value + 1;
                    return false;
                }
                lastId.value = id;
                return true;
            }
        });
        if (freeId.value > 0) {
            return freeId.value;
        }
        if (lastId.value < end) {
            return Math.max(start, lastId.value + 1);
        }
        return 0;
    }

    @Override
    public void returnUnusedIds(Visitable<Integer> visitable) {
        visitable.accept(new Visitor4<Integer>(){

            @Override
            public void visit(Integer obj) {
                InMemoryIdSystem.this._ids = (IdSlotTree)Tree.removeLike(InMemoryIdSystem.this._ids, new TreeInt(obj));
            }
        });
    }

    @Override
    public int childId() {
        return this._childId;
    }

    @Override
    public void childId(int id) {
        this._childId = id;
    }
}

