/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.foundation.Iterator4;
import com.db4o.internal.ObjectID;
import com.db4o.internal.ReadsObjectIds;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.activation.LegacyActivationDepth;
import com.db4o.internal.marshall.AbstractReadContext;
import com.db4o.internal.marshall.AspectVersionContext;
import com.db4o.internal.marshall.HandlerVersionContext;
import com.db4o.internal.marshall.IdObjectCollector;
import com.db4o.internal.marshall.ObjectIdContext;
import com.db4o.internal.query.processor.QCandidates;
import com.db4o.marshall.ReadBuffer;
import com.db4o.typehandlers.TypeHandler4;

public class QueryingReadContext
extends AbstractReadContext
implements HandlerVersionContext,
AspectVersionContext,
ObjectIdContext {
    private final QCandidates _candidates;
    private final int _collectionID;
    private final int _handlerVersion;
    private IdObjectCollector _collector;
    private int _declaredAspectCount;
    private int _id;

    private QueryingReadContext(Transaction transaction, QCandidates candidates, int handlerVersion, ReadBuffer buffer, int collectionID, IdObjectCollector collector) {
        super(transaction, buffer);
        this._candidates = candidates;
        this._activationDepth = new LegacyActivationDepth(0);
        this._collectionID = collectionID;
        this._handlerVersion = handlerVersion;
        this._collector = collector;
    }

    public QueryingReadContext(Transaction transaction, QCandidates candidates, int handlerVersion, ReadBuffer buffer, int collectionID) {
        this(transaction, candidates, handlerVersion, buffer, collectionID, new IdObjectCollector());
    }

    public QueryingReadContext(Transaction transaction, int handlerVersion, ReadBuffer buffer, int id) {
        this(transaction, null, handlerVersion, buffer, 0);
        this._id = id;
    }

    public QueryingReadContext(Transaction transaction, int handlerVersion, ReadBuffer buffer, int collectionID, IdObjectCollector collector) {
        this(transaction, null, handlerVersion, buffer, collectionID, collector);
    }

    public int collectionID() {
        return this._collectionID;
    }

    public QCandidates candidates() {
        return this._candidates;
    }

    public int handlerVersion() {
        return this._handlerVersion;
    }

    private void addId(int id) {
        this._collector.addId(id);
    }

    public TreeInt ids() {
        return this._collector.ids();
    }

    public void add(Object obj) {
        int id = this.getID(obj);
        if (id > 0) {
            this.addId(id);
            return;
        }
        this.addObjectWithoutId(obj);
    }

    private int getID(Object obj) {
        return this.container().getID(this.transaction(), obj);
    }

    public void readId(TypeHandler4 handler) {
        ObjectID objectID = ObjectID.NOT_POSSIBLE;
        try {
            int offset = this.offset();
            if (handler instanceof ReadsObjectIds) {
                objectID = ((ReadsObjectIds)((Object)handler)).readObjectID(this);
            }
            if (objectID.isValid()) {
                this.addId(objectID._id);
                return;
            }
            if (objectID == ObjectID.NOT_POSSIBLE) {
                this.seek(offset);
                Object obj = this.read(handler);
                if (obj != null) {
                    int id = this.getID(obj);
                    if (id > 0) {
                        this.addId(id);
                    } else {
                        this.addObjectWithoutId(obj);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addObjectWithoutId(Object obj) {
        this._collector.add(obj);
    }

    public void skipId(TypeHandler4 handler) {
        if (handler instanceof ReadsObjectIds) {
            ((ReadsObjectIds)((Object)handler)).readObjectID(this);
            return;
        }
        this.read(handler);
    }

    public Iterator4 objectsWithoutId() {
        return this._collector.objects();
    }

    public int declaredAspectCount() {
        return this._declaredAspectCount;
    }

    public void declaredAspectCount(int count) {
        this._declaredAspectCount = count;
    }

    public IdObjectCollector collector() {
        return this._collector;
    }

    public int objectId() {
        return this._id;
    }
}

