/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query;

import com.db4o.foundation.IntComparator;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.handlers.HandlerVersion;
import com.db4o.internal.marshall.QueryingReadContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SodaQueryComparator
implements Comparator<Integer>,
IntComparator {
    private final LocalObjectContainer _container;
    private final LocalTransaction _transaction;
    private final ClassMetadata _extentType;
    private final Ordering[] _orderings;
    private final Map<Integer, ByteArrayBuffer> _bufferCache = new HashMap<Integer, ByteArrayBuffer>();
    private final Map<FieldValueKey, Object> _fieldValueCache = new HashMap<FieldValueKey, Object>();

    public SodaQueryComparator(LocalObjectContainer container, Class extentType, Ordering ... orderings) {
        this(container, container.produceClassMetadata(container.reflector().forClass(extentType)), orderings);
    }

    public SodaQueryComparator(LocalObjectContainer container, ClassMetadata extent, Ordering ... orderings) {
        this._container = container;
        this._transaction = (LocalTransaction)this._container.transaction();
        this._extentType = extent;
        this._orderings = orderings;
        this.resolveFieldPaths(orderings);
    }

    private void resolveFieldPaths(Ordering[] orderings) {
        for (Ordering fieldPath : orderings) {
            fieldPath._resolvedPath = this.resolveFieldPath(fieldPath.fieldPath());
        }
    }

    public List<Integer> sort(long[] ids) {
        ArrayList<Integer> idList = this.listFrom(ids);
        Collections.sort(idList, this);
        return idList;
    }

    private ArrayList<Integer> listFrom(long[] ids) {
        ArrayList<Integer> idList = new ArrayList<Integer>(ids.length);
        for (long id : ids) {
            idList.add((int)id);
        }
        return idList;
    }

    private List<FieldMetadata> resolveFieldPath(String[] fieldPath) {
        ArrayList<FieldMetadata> fields = new ArrayList<FieldMetadata>(fieldPath.length);
        ClassMetadata currentType = this._extentType;
        for (String fieldName : fieldPath) {
            FieldMetadata field = currentType.fieldMetadataForName(fieldName);
            currentType = field.fieldType();
            fields.add(field);
        }
        return fields;
    }

    @Override
    public int compare(Integer x, Integer y) {
        return this.compare((int)x, (int)y);
    }

    @Override
    public int compare(int x, int y) {
        for (Ordering ordering : this._orderings) {
            int result = this.compareByField(x, y, ordering._resolvedPath);
            if (result == 0) continue;
            return ordering.direction().equals(Direction.ASCENDING) ? result : -result;
        }
        return 0;
    }

    private int compareByField(int x, int y, List<FieldMetadata> path) {
        Object xFieldValue = this.getFieldValue(x, path);
        Object yFieldValue = this.getFieldValue(y, path);
        FieldMetadata field = path.get(path.size() - 1);
        return field.prepareComparison(this._transaction.context(), xFieldValue).compareTo(yFieldValue);
    }

    private Object getFieldValue(int id, List<FieldMetadata> path) {
        for (int i = 0; i < path.size() - 1; ++i) {
            Object obj = this.getFieldValue(id, path.get(i));
            if (null == obj) {
                return null;
            }
            id = this._container.getID(this._transaction, obj);
        }
        return this.getFieldValue(id, path.get(path.size() - 1));
    }

    private Object getFieldValue(int id, FieldMetadata field) {
        FieldValueKey key = new FieldValueKey(id, field);
        Object cachedValue = this._fieldValueCache.get(key);
        if (null != cachedValue) {
            return cachedValue;
        }
        Object fieldValue = this.readFieldValue(id, field);
        this._fieldValueCache.put(key, fieldValue);
        return fieldValue;
    }

    private Object readFieldValue(int id, FieldMetadata field) {
        ByteArrayBuffer buffer = this.bufferFor(id);
        HandlerVersion handlerVersion = field.containingClass().seekToField(this._transaction, buffer, field);
        if (handlerVersion == HandlerVersion.INVALID) {
            return null;
        }
        QueryingReadContext context = new QueryingReadContext(this._transaction, handlerVersion._number, buffer, id);
        return field.read(context);
    }

    private ByteArrayBuffer bufferFor(int id) {
        ByteArrayBuffer cachedBuffer = this._bufferCache.get(id);
        if (null != cachedBuffer) {
            return cachedBuffer;
        }
        ByteArrayBuffer buffer = this._container.readBufferById(this._transaction, id);
        this._bufferCache.put(id, buffer);
        return buffer;
    }

    static class FieldValueKey {
        private int _id;
        private FieldMetadata _field;

        public FieldValueKey(int id, FieldMetadata field) {
            this._id = id;
            this._field = field;
        }

        public int hashCode() {
            return this._field.hashCode() ^ this._id;
        }

        public boolean equals(Object obj) {
            FieldValueKey other = (FieldValueKey)obj;
            return this._field == other._field && this._id == other._id;
        }
    }

    public static class Direction {
        public static final Direction ASCENDING = new Direction(0);
        public static final Direction DESCENDING = new Direction(1);
        private int value;

        private Direction() {
        }

        private Direction(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            return ((Direction)obj).value == this.value;
        }

        public String toString() {
            return this.equals(ASCENDING) ? "ASCENDING" : "DESCENDING";
        }
    }

    public static class Ordering {
        private Direction _direction;
        private String[] _fieldPath;
        transient List<FieldMetadata> _resolvedPath;

        public Ordering(Direction direction, String ... fieldPath) {
            this._direction = direction;
            this._fieldPath = fieldPath;
        }

        public Direction direction() {
            return this._direction;
        }

        public String[] fieldPath() {
            return this._fieldPath;
        }
    }
}

