/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.processor;

import com.db4o.DTrace;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.IntIterator4Adaptor;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.List4;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.TreeKeyIterator;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.IDGenerator;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectID;
import com.db4o.internal.ReadsObjectIds;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.fieldindex.FieldIndexProcessor;
import com.db4o.internal.fieldindex.FieldIndexProcessorResult;
import com.db4o.internal.handlers.StandardReferenceTypeHandler;
import com.db4o.internal.marshall.CollectIdContext;
import com.db4o.internal.marshall.QueryingReadContext;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QConClass;
import com.db4o.internal.query.processor.QField;
import com.db4o.typehandlers.TypeHandler4;

public final class QCandidates
implements Visitor4 {
    public final LocalTransaction i_trans;
    public Tree i_root;
    private List4 _constraints;
    ClassMetadata i_classMetadata;
    private QField _field;
    QCon i_currentConstraint;
    private IDGenerator _idGenerator;
    private boolean _loadedFromClassIndex;

    QCandidates(LocalTransaction a_trans, ClassMetadata a_classMetadata, QField a_field) {
        this.i_trans = a_trans;
        this.i_classMetadata = a_classMetadata;
        this._field = a_field;
        if (a_field == null || a_field._fieldMetadata == null || !(a_field._fieldMetadata.getHandler() instanceof StandardReferenceTypeHandler)) {
            return;
        }
        ClassMetadata yc = ((StandardReferenceTypeHandler)a_field._fieldMetadata.getHandler()).classMetadata();
        if (this.i_classMetadata == null) {
            this.i_classMetadata = yc;
        } else if ((yc = this.i_classMetadata.getHigherOrCommonHierarchy(yc)) != null) {
            this.i_classMetadata = yc;
        }
    }

    public QCandidate add(QCandidate candidate) {
        this.i_root = Tree.add(this.i_root, candidate);
        if (candidate._size == 0) {
            return candidate.getRoot();
        }
        return candidate;
    }

    void addConstraint(QCon a_constraint) {
        this._constraints = new List4<QCon>(this._constraints, a_constraint);
    }

    public QCandidate readSubCandidate(QueryingReadContext context, TypeHandler4 handler) {
        ObjectID objectID = ObjectID.NOT_POSSIBLE;
        try {
            int offset = context.offset();
            if (handler instanceof ReadsObjectIds) {
                objectID = ((ReadsObjectIds)((Object)handler)).readObjectID(context);
            }
            if (objectID.isValid()) {
                return new QCandidate(this, null, objectID._id);
            }
            if (objectID == ObjectID.NOT_POSSIBLE) {
                context.seek(offset);
                Object obj = context.read(handler);
                if (obj != null) {
                    QCandidate candidate = new QCandidate(this, obj, context.container().getID(context.transaction(), obj));
                    candidate.classMetadata(context.container().classMetadataForObject(obj));
                    return candidate;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    void collect(QCandidates a_candidates) {
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            QCon qCon = (QCon)i.current();
            this.setCurrentConstraint(qCon);
            qCon.collect(a_candidates);
        }
        this.setCurrentConstraint(null);
    }

    void execute() {
        FieldIndexProcessorResult result;
        if (DTrace.enabled) {
            DTrace.QUERY_PROCESS.log();
        }
        if ((result = this.processFieldIndexes()).foundIndex()) {
            this.i_root = result.toQCandidate(this);
        } else {
            this.loadFromClassIndex();
        }
        this.evaluate();
    }

    public Iterator4 executeSnapshot(Collection4 executionPath) {
        IntIterator4Adaptor indexIterator = new IntIterator4Adaptor(this.iterateIndex(this.processFieldIndexes()));
        Tree idRoot = TreeInt.addAll(null, indexIterator);
        TreeKeyIterator snapshotIterator = new TreeKeyIterator(idRoot);
        Iterator4 singleObjectQueryIterator = this.singleObjectSodaProcessor(snapshotIterator);
        return this.mapIdsToExecutionPath(singleObjectQueryIterator, executionPath);
    }

    private Iterator4 singleObjectSodaProcessor(Iterator4 indexIterator) {
        return Iterators.map(indexIterator, new Function4(){

            public Object apply(Object current) {
                int id = (Integer)current;
                QCandidate candidate = new QCandidate(QCandidates.this, null, id);
                QCandidates.this.i_root = candidate;
                QCandidates.this.evaluate();
                if (!candidate.include()) {
                    return Iterators.SKIP;
                }
                return current;
            }
        });
    }

    public Iterator4 executeLazy(Collection4 executionPath) {
        Iterator4 indexIterator = this.iterateIndex(this.processFieldIndexes());
        Iterator4 singleObjectQueryIterator = this.singleObjectSodaProcessor(indexIterator);
        return this.mapIdsToExecutionPath(singleObjectQueryIterator, executionPath);
    }

    private Iterator4 iterateIndex(FieldIndexProcessorResult result) {
        if (result.noMatch()) {
            return Iterators.EMPTY_ITERATOR;
        }
        if (result.foundIndex()) {
            return result.iterateIDs();
        }
        if (!this.i_classMetadata.hasClassIndex()) {
            return Iterators.EMPTY_ITERATOR;
        }
        return BTreeClassIndexStrategy.iterate(this.i_classMetadata, this.i_trans);
    }

    private Iterator4 mapIdsToExecutionPath(Iterator4 singleObjectQueryIterator, Collection4 executionPath) {
        if (executionPath == null) {
            return singleObjectQueryIterator;
        }
        Iterator4 res = singleObjectQueryIterator;
        Iterator4 executionPathIterator = executionPath.iterator();
        while (executionPathIterator.moveNext()) {
            final String fieldName = (String)executionPathIterator.current();
            res = Iterators.concat(Iterators.map(res, new Function4(){

                public Object apply(Object current) {
                    int id = (Integer)current;
                    CollectIdContext context = CollectIdContext.forID(QCandidates.this.i_trans, id);
                    if (context == null) {
                        return Iterators.SKIP;
                    }
                    context.classMetadata().collectIDs(context, fieldName);
                    return new TreeKeyIterator(context.ids());
                }
            }));
        }
        return res;
    }

    public ObjectContainerBase stream() {
        return this.i_trans.container();
    }

    public int classIndexEntryCount() {
        return this.i_classMetadata.indexEntryCount(this.i_trans);
    }

    private FieldIndexProcessorResult processFieldIndexes() {
        if (this._constraints == null) {
            return FieldIndexProcessorResult.NO_INDEX_FOUND;
        }
        return new FieldIndexProcessor(this).run();
    }

    void evaluate() {
        if (this._constraints == null) {
            return;
        }
        this.forEachConstraint(new Procedure4(){

            public void apply(Object arg) {
                QCon qCon = (QCon)arg;
                qCon.setCandidates(QCandidates.this);
                qCon.evaluateSelf();
            }
        });
        this.forEachConstraint(new Procedure4(){

            public void apply(Object arg) {
                ((QCon)arg).evaluateSimpleChildren();
            }
        });
        this.forEachConstraint(new Procedure4(){

            public void apply(Object arg) {
                ((QCon)arg).evaluateEvaluations();
            }
        });
        this.forEachConstraint(new Procedure4(){

            public void apply(Object arg) {
                ((QCon)arg).evaluateCreateChildrenCandidates();
            }
        });
        this.forEachConstraint(new Procedure4(){

            public void apply(Object arg) {
                ((QCon)arg).evaluateCollectChildren();
            }
        });
        this.forEachConstraint(new Procedure4(){

            public void apply(Object arg) {
                ((QCon)arg).evaluateChildren();
            }
        });
    }

    private void forEachConstraint(Procedure4 proc) {
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            QCon constraint = (QCon)i.current();
            if (constraint.processedByIndex()) continue;
            proc.apply(constraint);
        }
    }

    boolean isEmpty() {
        final boolean[] ret = new boolean[]{true};
        this.traverse(new Visitor4(){

            public void visit(Object obj) {
                if (((QCandidate)obj)._include) {
                    ret[0] = false;
                }
            }
        });
        return ret[0];
    }

    boolean filter(Visitor4 a_host) {
        if (this.i_root != null) {
            this.i_root.traverse(a_host);
            this.i_root = this.i_root.filter(new Predicate4(){

                public boolean match(Object a_candidate) {
                    return ((QCandidate)a_candidate)._include;
                }
            });
        }
        return this.i_root != null;
    }

    int generateCandidateId() {
        if (this._idGenerator == null) {
            this._idGenerator = new IDGenerator();
        }
        return -this._idGenerator.next();
    }

    public Iterator4 iterateConstraints() {
        if (this._constraints == null) {
            return Iterators.EMPTY_ITERATOR;
        }
        return new Iterator4Impl(this._constraints);
    }

    void loadFromClassIndex() {
        if (!this.isEmpty()) {
            return;
        }
        final TreeIntBuilder result = new TreeIntBuilder();
        ClassIndexStrategy index = this.i_classMetadata.index();
        index.traverseAll(this.i_trans, new Visitor4(){

            public void visit(Object obj) {
                result.add(new QCandidate(QCandidates.this, null, (Integer)obj));
            }
        });
        this.i_root = result.tree;
        DiagnosticProcessor dp = this.i_trans.container()._handlers.diagnosticProcessor();
        if (dp.enabled() && !this.isClassOnlyQuery()) {
            dp.loadedFromClassIndex(this.i_classMetadata);
        }
        this._loadedFromClassIndex = true;
    }

    void setCurrentConstraint(QCon a_constraint) {
        this.i_currentConstraint = a_constraint;
    }

    void traverse(Visitor4 a_visitor) {
        if (this.i_root != null) {
            this.i_root.traverse(a_visitor);
        }
    }

    boolean tryAddConstraint(QCon a_constraint) {
        QField qf;
        if (this._field != null && (qf = a_constraint.getField()) != null && this._field.name() != null && !this._field.name().equals(qf.name())) {
            return false;
        }
        if (this.i_classMetadata == null || a_constraint.isNullConstraint()) {
            this.addConstraint(a_constraint);
            return true;
        }
        ClassMetadata yc = a_constraint.getYapClass();
        if (yc != null && (yc = this.i_classMetadata.getHigherOrCommonHierarchy(yc)) != null) {
            this.i_classMetadata = yc;
            this.addConstraint(a_constraint);
            return true;
        }
        this.addConstraint(a_constraint);
        return false;
    }

    public void visit(Object a_tree) {
        QCandidate parent = (QCandidate)a_tree;
        if (parent.createChild(this)) {
            return;
        }
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).visitOnNull(parent.getRoot());
        }
    }

    public String toString() {
        final StringBuffer sb = new StringBuffer();
        this.i_root.traverse(new Visitor4(){

            public void visit(Object obj) {
                QCandidate candidate = (QCandidate)obj;
                sb.append(" ");
                sb.append(candidate._key);
            }
        });
        return sb.toString();
    }

    public final Transaction transaction() {
        return this.i_trans;
    }

    public boolean wasLoadedFromClassIndex() {
        return this._loadedFromClassIndex;
    }

    public boolean fitsIntoExistingConstraintHierarchy(QCon constraint) {
        QField qf;
        if (this._field != null && (qf = constraint.getField()) != null && this._field.name() != null && !this._field.name().equals(qf.name())) {
            return false;
        }
        if (this.i_classMetadata == null || constraint.isNullConstraint()) {
            return true;
        }
        ClassMetadata classMetadata = constraint.getYapClass();
        if (classMetadata == null) {
            return false;
        }
        if ((classMetadata = this.i_classMetadata.getHigherOrCommonHierarchy(classMetadata)) == null) {
            return false;
        }
        this.i_classMetadata = classMetadata;
        return true;
    }

    private boolean isClassOnlyQuery() {
        if (this._constraints._next != null) {
            return false;
        }
        if (!(this._constraints._element instanceof QConClass)) {
            return false;
        }
        return !((QCon)this._constraints._element).hasChildren();
    }

    static final class TreeIntBuilder {
        public TreeInt tree;

        TreeIntBuilder() {
        }

        public void add(TreeInt node) {
            this.tree = Tree.add(this.tree, node);
        }
    }
}

