/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.transactionlog;

import com.db4o.foundation.Visitable;
import com.db4o.foundation.io.File4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;
import com.db4o.internal.transactionlog.TransactionLogHandler;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.FileStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedTransactionLogHandler
extends TransactionLogHandler {
    static final int LOCK_INT = 0x7FFFFFFE;
    private Bin _lockFile;
    private Bin _logFile;
    private final String _fileName;

    public FileBasedTransactionLogHandler(LocalObjectContainer container, String fileName) {
        super(container);
        this._fileName = fileName;
    }

    public static String logFileName(String fileName) {
        return fileName + ".log";
    }

    public static String lockFileName(String fileName) {
        return fileName + ".lock";
    }

    private Bin openBin(String fileName) {
        return new FileStorage().open(new BinConfiguration(fileName, this._container.config().lockFile(), 0L, false));
    }

    @Override
    public void completeInterruptedTransaction(int transactionId1, int transactionId2) {
        if (!File4.exists(FileBasedTransactionLogHandler.lockFileName(this._fileName))) {
            return;
        }
        if (!this.lockFileSignalsInterruptedTransaction()) {
            return;
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        this.openLogFile();
        this.read(this._logFile, buffer);
        int length = buffer.readInt();
        if (length > 0) {
            buffer = new ByteArrayBuffer(length);
            this.read(this._logFile, buffer);
            buffer.incrementOffset(4);
            this.readWriteSlotChanges(buffer);
        }
        this.deleteLockFile();
        this.closeLogFile();
        this.deleteLogFile();
    }

    private boolean lockFileSignalsInterruptedTransaction() {
        this.openLockFile();
        ByteArrayBuffer buffer = this.newLockFileBuffer();
        this.read(this._lockFile, buffer);
        for (int i = 0; i < 2; ++i) {
            int checkInt = buffer.readInt();
            if (checkInt == 0x7FFFFFFE) continue;
            this.closeLockFile();
            return false;
        }
        this.closeLockFile();
        return true;
    }

    @Override
    public void close() {
        if (!this.logsOpened()) {
            return;
        }
        this.closeLockFile();
        this.closeLogFile();
        this.deleteLockFile();
        this.deleteLogFile();
    }

    private void closeLockFile() {
        this.syncAndClose(this._lockFile);
        this._lockFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAndClose(Bin bin) {
        try {
            bin.sync();
        }
        finally {
            bin.close();
        }
    }

    private void closeLogFile() {
        this.syncAndClose(this._logFile);
        this._logFile = null;
    }

    private void deleteLockFile() {
        File4.delete(FileBasedTransactionLogHandler.lockFileName(this._fileName));
    }

    private void deleteLogFile() {
        File4.delete(FileBasedTransactionLogHandler.logFileName(this._fileName));
    }

    @Override
    public Slot allocateSlot(boolean append, int slotChangeCount) {
        return null;
    }

    @Override
    public void applySlotChanges(Visitable<SlotChange> slotChangeTree, int slotChangeCount, Slot reservedSlot) {
        if (slotChangeCount < 1) {
            return;
        }
        Runnable commitHook = this._container.commitHook();
        this.flushDatabaseFile();
        this.ensureLogAndLock();
        int length = this.transactionLogSlotLength(slotChangeCount);
        ByteArrayBuffer logBuffer = new ByteArrayBuffer(length);
        logBuffer.writeInt(length);
        logBuffer.writeInt(slotChangeCount);
        this.appendSlotChanges(logBuffer, slotChangeTree);
        this.write(this._logFile, logBuffer);
        this._logFile.sync();
        this.writeToLockFile(0x7FFFFFFE);
        this.writeSlots(slotChangeTree);
        commitHook.run();
        this.flushDatabaseFile();
        this.writeToLockFile(0);
    }

    private void writeToLockFile(int lockSignal) {
        ByteArrayBuffer lockBuffer = this.newLockFileBuffer();
        lockBuffer.writeInt(lockSignal);
        lockBuffer.writeInt(lockSignal);
        this.write(this._lockFile, lockBuffer);
        this._lockFile.sync();
    }

    private ByteArrayBuffer newLockFileBuffer() {
        return new ByteArrayBuffer(this.lockFileBufferLength());
    }

    private int lockFileBufferLength() {
        return 16;
    }

    private void ensureLogAndLock() {
        if (this._container.config().isReadOnly()) {
            return;
        }
        if (this.logsOpened()) {
            return;
        }
        this.openLockFile();
        this.openLogFile();
    }

    private void openLogFile() {
        this._logFile = this.openBin(FileBasedTransactionLogHandler.logFileName(this._fileName));
    }

    private void openLockFile() {
        this._lockFile = this.openBin(FileBasedTransactionLogHandler.lockFileName(this._fileName));
    }

    private boolean logsOpened() {
        return this._lockFile != null;
    }

    private void read(Bin storage, ByteArrayBuffer buffer) {
        storage.read(0L, buffer._buffer, buffer.length());
    }

    private void write(Bin storage, ByteArrayBuffer buffer) {
        storage.write(0L, buffer._buffer, buffer.length());
    }
}

