/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.weakref;

import com.db4o.ext.DatabaseClosedException;
import com.db4o.foundation.SimpleTimer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Platform4;
import com.db4o.internal.weakref.WeakReferenceSupport;

class EnabledWeakReferenceSupport
implements WeakReferenceSupport {
    private final Object _queue;
    private final ObjectContainerBase _container;
    private SimpleTimer _timer;

    EnabledWeakReferenceSupport(ObjectContainerBase container) {
        this._container = container;
        this._queue = Platform4.createReferenceQueue();
    }

    public Object newWeakReference(ObjectReference referent, Object obj) {
        return Platform4.createActiveObjectReference(this._queue, referent, obj);
    }

    public void purge() {
        Platform4.pollReferenceQueue(this._container, this._queue);
    }

    public void start() {
        if (this._timer != null) {
            return;
        }
        if (!this._container.configImpl().weakReferences()) {
            return;
        }
        if (this._container.configImpl().weakReferenceCollectionInterval() <= 0) {
            return;
        }
        this._timer = new SimpleTimer(new Collector(), this._container.configImpl().weakReferenceCollectionInterval());
        this._container.threadPool().start("db4o WeakReference collector", this._timer);
    }

    public void stop() {
        if (this._timer == null) {
            return;
        }
        this._timer.stop();
        this._timer = null;
    }

    private final class Collector
    implements Runnable {
        private Collector() {
        }

        public void run() {
            try {
                EnabledWeakReferenceSupport.this.purge();
            }
            catch (DatabaseClosedException dce) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

