/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.DoublingGrowthStrategy;
import com.db4o.io.GrowthStrategy;
import com.db4o.io.MemoryBin;
import com.db4o.io.ReadOnlyBin;
import com.db4o.io.Storage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MemoryStorage
implements Storage {
    private final Map<String, MemoryBin> _bins = new HashMap<String, MemoryBin>();
    private final GrowthStrategy _growthStrategy;

    public MemoryStorage() {
        this(new DoublingGrowthStrategy());
    }

    public MemoryStorage(GrowthStrategy growthStrategy) {
        this._growthStrategy = growthStrategy;
    }

    public boolean exists(String uri) {
        return this._bins.containsKey(uri);
    }

    public Bin open(BinConfiguration config) throws Db4oIOException {
        Bin storage = this.produceStorage(config);
        return config.readOnly() ? new ReadOnlyBin(storage) : storage;
    }

    public MemoryBin bin(String uri) {
        return this._bins.get(uri);
    }

    public void bin(String uri, MemoryBin bin) {
        this._bins.put(uri, bin);
    }

    private Bin produceStorage(BinConfiguration config) {
        MemoryBin storage = this.bin(config.uri());
        if (null != storage) {
            return storage;
        }
        MemoryBin newStorage = new MemoryBin(new byte[(int)config.initialLength()], this._growthStrategy);
        this._bins.put(config.uri(), newStorage);
        return newStorage;
    }

    public void delete(String uri) throws IOException {
        this._bins.remove(uri);
    }

    public void rename(String oldUri, String newUri) throws IOException {
        MemoryBin bin = this._bins.remove(oldUri);
        if (bin == null) {
            throw new IOException("Bin not found: " + oldUri);
        }
        this._bins.put(newUri, bin);
    }
}

