/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.foundation.Closure4;
import com.db4o.foundation.Lock4;
import com.db4o.io.Bin;
import com.db4o.io.BinDecorator;

public class ThreadedSyncBin
extends BinDecorator {
    private static final int ONE_SECOND = 1000;
    private volatile Runnable _syncRunnable;
    private volatile boolean _closed;
    private final Thread _thread;
    private final Lock4 _lock = new Lock4();

    public ThreadedSyncBin(Bin bin) {
        super(bin);
        this._thread = new Thread(new Runnable(){

            public void run() {
                Closure4 closure = new Closure4(){

                    public Object run() {
                        ThreadedSyncBin.this.runSyncRunnable();
                        ThreadedSyncBin.this._lock.snooze(1000L);
                        return null;
                    }
                };
                do {
                    ThreadedSyncBin.this._lock.run(closure);
                } while (!ThreadedSyncBin.this._closed);
            }
        }, "ThreadedSyncBin");
        this._thread.start();
    }

    public void close() {
        this.waitForPendingSync();
        this._closed = true;
        this._lock.run(new Closure4(){

            public Object run() {
                ThreadedSyncBin.this._lock.awake();
                return null;
            }
        });
        super.close();
    }

    private void waitForPendingSync() {
        while (this._syncRunnable != null) {
            if (Thread.currentThread() != this._thread) continue;
            return;
        }
    }

    public long length() {
        this.waitForPendingSync();
        return super.length();
    }

    public int read(long position, byte[] buffer, int bytesToRead) {
        this.waitForPendingSync();
        return super.read(position, buffer, bytesToRead);
    }

    public void write(long position, byte[] bytes, int bytesToWrite) {
        this.waitForPendingSync();
        super.write(position, bytes, bytesToWrite);
    }

    public void sync() {
        this.waitForPendingSync();
        super.sync();
    }

    public void sync(final Runnable runnable) {
        this.waitForPendingSync();
        this._lock.run(new Closure4(){

            public Object run() {
                ThreadedSyncBin.this._syncRunnable = runnable;
                ThreadedSyncBin.this._lock.awake();
                return null;
            }
        });
    }

    final void runSyncRunnable() {
        Runnable runnable = this._syncRunnable;
        if (runnable != null) {
            super.sync();
            runnable.run();
            super.sync();
            this._syncRunnable = null;
        }
    }
}

