package weibo4j.examples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import weibo4j.Status;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.http.AccessToken;
import weibo4j.http.RequestToken;

public class WebOAuth
{

	public static RequestToken request(String backUrl)
	{
		try
		{
			System.setProperty("weibo4j.oauth.consumerKey", Weibo.CONSUMER_KEY);
			System.setProperty("weibo4j.oauth.consumerSecret",
					Weibo.CONSUMER_SECRET);

			Weibo weibo = new Weibo();
			RequestToken requestToken = weibo.getOAuthRequestToken(backUrl);

			System.out.println("Got request token.");
			System.out.println("Request token: " + requestToken.getToken());
			System.out.println("Request token secret: "
					+ requestToken.getTokenSecret());
			return requestToken;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return null;
		}
	}

	public static AccessToken requstAccessToken(RequestToken requestToken,
			String verifier)
	{
		try
		{
			System.setProperty("weibo4j.oauth.consumerKey", Weibo.CONSUMER_KEY);
			System.setProperty("weibo4j.oauth.consumerSecret",
					Weibo.CONSUMER_SECRET);

			Weibo weibo = new Weibo();
			AccessToken accessToken = weibo.getOAuthAccessToken(
					requestToken.getToken(), requestToken.getTokenSecret(),
					verifier);

			System.out.println("Got access token.");
			System.out.println("access token: " + accessToken.getToken());
			System.out.println("access token secret: "
					+ accessToken.getTokenSecret());
			return accessToken;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return null;
		}
	}

	public static void update(AccessToken access, String content)
	{
		try
		{
			Weibo weibo = new Weibo();
			weibo.setToken(access.getToken(), access.getTokenSecret());
			Status status = weibo.updateStatus(content);
			System.out.println("Successfully updated the status to ["
					+ status.getText() + "].");
		}
		catch (WeiboException e)
		{
			e.printStackTrace();
		}
	}

	public static void main(String[] args) throws Exception
	{
		RequestToken requestToken = request("http://www.csdn.net");

		System.out.println(requestToken.getAuthorizationURL());

		String pin = readLine();
		
		AccessToken accessToken = requstAccessToken(requestToken, pin);
		update(accessToken, "测试OAuth");

	}
	
	private static String readLine() throws IOException {
		BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        byte[] bs = reader.readLine().getBytes("gbk");
		String getStr = new String(bs);
		System.out.println(getStr);
		return getStr;
	}
}
