package microblog;

import java.util.List;
import microblog.commons.Const;
import weibo4j.Count;
import weibo4j.WeiboResponse;
import weibo4j.User;

public abstract class MicroBlogListenerImpl implements MicroBlogListener,
		CountListener, Const
{
	@Override
	public void onEnd(String msg, Object obj, int type)
	{
		switch (type)
		{
			case OPERATION_TYPE_LOGIN_SUCCESS:
				onLoginSuccess(msg, (User) obj);
				break;
			case OPERATION_TYPE_HOME_TIMELINE_SUCCESS:
			case OPERATION_TYPE_PUBLIC_TIMELINE_SUCCESS:
			case OPERATION_TYPE_USER_TIMELINE_SUCCESS:
			case OPERATION_TYPE_MENTIONS_SUCCESS:
			case OPERATION_TYPE_COMMENT_SUCCESS:
			case OPERATION_TYPE_COMMENTS_TIMELINE_SUCCESS:
			case OPERATION_TYPE_COMMENT_BY_ME_SUCCESS:
			case OPERATION_TYPE_FAVORITES_SUCCESS:
			case OPERATION_TYPE_DIRECT_MESSAGE_SUCCESS:
			case OPERATION_TYPE_DIRECT_MESSAGE_ME_SUCCESS:
			case OPERATION_TYPE_SEARCH_MBLOG_SUCCESS:
			case OPERATION_TYPE_SEARCH_USER_SUCCESS:
				onTimelineSuccess(msg, (List<WeiboResponse>) obj);
				break;
			case OPERATION_TYPE_COUNT_SUCCESS:
				onGetCountSuccess((Count) obj);
				break;
			default:
				break;
		}

	}

	@Override
	public void onException(String msg, int type)
	{

		switch (type)
		{
			case OPERATION_TYPE_LOGIN_EXCEPTION:
				onLoginException(msg);
				break;
			case OPERATION_TYPE_HOME_TIMELINE_EXCEPTION:
			case OPERATION_TYPE_PUBLIC_TIMELINE_EXCEPTION:
			case OPERATION_TYPE_USER_TIMELINE_EXCEPTION:
			case OPERATION_TYPE_MENTIONS_EXCEPTION:
			case OPERATION_TYPE_COMMENT_EXCEPTION:
			case OPERATION_TYPE_COMMENTS_TIMELINE_EXCEPTION:
			case OPERATION_TYPE_COMMENT_BY_ME_EXCEPTION:
			case OPERATION_TYPE_FAVORITES_EXCEPTION:
			case OPERATION_TYPE_DIRECT_MESSAGE_EXCEPTION:
			case OPERATION_TYPE_DIRECT_MESSAGE_ME_EXCEPTION:
			case OPERATION_TYPE_SEARCH_MBLOG_EXCEPTION:
			case OPERATION_TYPE_SEARCH_USER_EXCEPTION:

				onTimelineException(msg); 
				break;
			case OPERATION_TYPE_COUNT_EXCEPTION:
				onGetCountException();
				break;
			default:
				break;
		}
	}

	@Override
	public void onLoginException(String msg)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public boolean onWait(String msg, int type)
	{
		return true;

	}

	@Override
	public void onTimelineException(String msg)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onTimelineSuccess(String msg,
			List<WeiboResponse> twitterResponses)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onLoginSuccess(String msg, User user)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onGetCountException()
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onGetCountSuccess(Count count)
	{
		// TODO Auto-generated method stub

	}

}
