package microblog.commons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ConstExt implements Const
{
	public static Map<Integer, String[]> chineseMap = new HashMap<Integer, String[]>();
	public static Map<Integer, String[]> englishMap = new HashMap<Integer, String[]>();

	// ////////////////ݿȭ///////////////////////////
	public final static String SYSTEM_DB_NAME = "happyblog.db";

	public final static List<String> SQL_CREATE_TABLE_ACCOUNTS_LIST = new ArrayList<String>();
	public final static String SQL_CREATE_TABLE_ACCOUNTS = "CREATE TABLE [t_accounts] ("
			+ "[happyblog_account] VARCHAR(50) NOT NULL ON CONFLICT ROLLBACK,"
			+ "[microblog] VARCHAR(20) NOT NULL ON CONFLICT ROLLBACK,"
			+ "[microblog_account] VARCHAR(200) NOT NULL ON CONFLICT ROLLBACK,"
			+ "[password] VARCHAR(60) NOT NULL ON CONFLICT ROLLBACK,"
			+ "[alias] VARCHAR(20) NOT NULL ON CONFLICT ROLLBACK,"
			+ "[add_account_time] DATETIME  NOT NULL ON CONFLICT ROLLBACK,"
			+ "[sync] BOOLEAN NOT NULL ON CONFLICT ROLLBACK DEFAULT false);";
	public final static String SQL_CREATE_TABLE_TASK_QUEUE = "CREATE TABLE [t_task_queue] ("
			+ "[microblog] VARCHAR(20) NOT NULL,"
			+ "[msg] TEXT NOT NULL,"
			+ "[image] BLOB,"
			+ "[post_datetime] DATETIME NOT NULL ON CONFLICT ROLLBACK,[type] VARCHAR(20) NOT NULL,[flag] BOOLEAN NOT NULL)";
	public final static String SQL_CREATE_TABLE_NOTIFICATION_LIST = "CREATE TABLE [t_notification_list] ("
			+ "[id] AUTOINC NOT NULL ON CONFLICT ROLLBACK,"
			+ "[title] VARCHAR(50) NOT NULL,"
			+ "[notification_time] DATETIME NOT NULL ON CONFLICT ROLLBACK,"
			+ "[state] VARCHAR(10) NOT NULL,"
			+ "[microblog] VARCHAR(20) NOT NULL,"
			+ "[alias] VARCHAR(50) NOT NULL);";
	public final static String SQL_CREATE_TABLE_NOTIFICATION_TASK_LIST = "CREATE TABLE [t_notification_task_list] ("
			+ "[id] AUTOINC NOT NULL ON CONFLICT ROLLBACK,"
			+ "[task_content] TEXT NOT NULL ON CONFLICT ROLLBACK,"
			+ "[task_image] BINARY,"
			+ "[task_type] VARCHAR(20) NOT NULL ON CONFLICT ROLLBACK,"
			+ "CONSTRAINT [sqlite_autoindex_t_notification_task_list_1] PRIMARY KEY ([id]));";

	public final static String SQL_CREATE_INDEX_ACCOUNTS_1 = "CREATE INDEX [index_happyblog_account] ON [t_accounts] ([happyblog_account] COLLATE BINARY);";
	public final static String SQL_CREATE_INDEX_ACCOUNTS_2 = "CREATE UNIQUE INDEX [index_happyblog_account_microblog_microblog_account] ON [t_accounts] ([happyblog_account], [microblog], [microblog_account]);";
	public final static String SQL_CREATE_INDEX_ACCOUNTS_3 = "CREATE UNIQUE INDEX [index_happyblog_account_alias] ON [t_accounts] ([happyblog_account], [alias]);";

	public final static String SQL_INSERT_ACCOUNT = "insert into t_accounts(happyblog_account, microblog, microblog_account, password, alias,add_account_time) values(?,?,?,?,?,?);";

	// ҵ΢ûIDҪע
	public final static List<String> MY_USER_ID_LIST = new ArrayList<String>();

	static
	{

		chineseMap.put(MESSAGE_LOGIN, new String[]
		{ "֤ûԺ...", "û֤ɹ.", "û" });

		chineseMap.put(MESSAGE_HOME_TIMELINE, new String[]
		{ "ڻҳ΢ϢԺ...", "ɹҳ΢Ϣ.", "ҳ΢Ϣʧܣ" });

		chineseMap.put(MESSAGE_PUBLIC_TIMELINE, new String[]
		{ "ڻù΢ϢԺ...", "ɹù΢Ϣ.", "ù΢Ϣʧܣ" });

		chineseMap.put(MESSAGE_UPDATE_STATUS, new String[]
		{ "ڷ΢Ժ...", "ɹ΢.", "΢ʧܣ" });

		chineseMap.put(MESSAGE_COUNT, new String[]
		{ "ڻתԺ...", "ɹת.", "תʧܣ" });
		chineseMap.put(MESSAGE_COMMENT, new String[]
		{ "ڻϢԺ...", "ɹϢ.", "Ϣʧܣ" });

		chineseMap.put(MESSAGE_USER_TIMELINE, new String[]
		{ "ڻû΢Ժ...", "ɹû΢.", "û΢ʧܣ" });

		chineseMap.put(MESSAGE_MENTIONS, new String[]
		{ "ڻ@ᵽҵ΢Ժ...", "ɹ@ᵽҵ΢.", "@ᵽҵ΢ʧܣ" });
		chineseMap.put(MESSAGE_COMMENTS_TIMELINE, new String[]
		{ "ڻϢԺ...", "ɹϢ.", "Ϣʧܣ" });

		chineseMap.put(MESSAGE_COMMENTS_BY_ME, new String[]
		{ "ڻϢԺ...", "ɹϢ.", "Ϣʧܣ" });

		chineseMap.put(MESSAGE_FAVORITES, new String[]
		{ "ڻҵղأԺ...", "ɹҵղ.", "ҵղʧܣ" });


		chineseMap.put(MESSAGE_DIRECT_MESSAGE, new String[]
		                                     		{ "ڻ˽ţԺ...", "ɹ˽.", "˽ʧܣ" });

		chineseMap.put(MESSAGE_SEARCH_MBLOG, new String[]
				                                     		{ "ڲѯ΢Ժ...", "ѯ΢ɹ.", "ѯ΢ʧܣ" });
		
		chineseMap.put(MESSAGE_SEARCH_USER, new String[]
			                                     		{ "ڲѯûԺ...", "ѯ΢ɹ.", "ѯ΢ʧܣ" });
		SQL_CREATE_TABLE_ACCOUNTS_LIST.add(SQL_CREATE_TABLE_ACCOUNTS);
		SQL_CREATE_TABLE_ACCOUNTS_LIST.add(SQL_CREATE_INDEX_ACCOUNTS_1);
		SQL_CREATE_TABLE_ACCOUNTS_LIST.add(SQL_CREATE_INDEX_ACCOUNTS_2);
		SQL_CREATE_TABLE_ACCOUNTS_LIST.add(SQL_CREATE_INDEX_ACCOUNTS_3);

		// lntoto@126.com
		MY_USER_ID_LIST.add("1644687235");
		// techcast@126.com
		//MY_USER_ID_LIST.add("1801201017");
	}

}
