package microblog.net;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microblog.net.interfaces.PullListener;
import weibo4j.Status;

//  ÿһӦʹһʵ
public class PullFile
{
	public static Map<String, List<String>> mProfileImageCache = new HashMap<String, List<String>>();

	public PullListener mPullListener;

	private String mPath;

	public void setOnPullListener(PullListener listener)
	{
		mPullListener = listener;
	}

	public void pull(String path, Object obj)
	{
		mPath = path;
		
		Thread thread = new Thread(new PullThread(obj));
		thread.start();
	}

	// //////////private//////////////
	private InputStream pullFile(URL url) throws Exception
	{

		HttpURLConnection httpURLConnection = (HttpURLConnection) url
				.openConnection();
		httpURLConnection.setRequestMethod("GET");
		httpURLConnection.setDoInput(true);
		httpURLConnection.setUseCaches(false);
		return httpURLConnection.getInputStream();
	}

	// ////////////////////////////////

	class PullThread implements Runnable
	{
		private Object mObject;

		public PullThread(Object object)
		{
			mObject = object;
		}

		@Override
		public void run()
		{
			try
			{
				URL url = new URL(mPath);
				InputStream is = pullFile(url);
				
				if (mPullListener != null)
					mPullListener.onPullFile(mPath, is, mObject);
				//is.close();
 
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}

		}
	}
}
