package microblog.storage;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import microblog.commons.EncryptDecrypt;
import weibo4j.Status;
import weibo4j.Weibo;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;

public class Cache
{
	public static String rootPath;

	public static void save(String name, List<WeiboResponse> responses)
			throws Exception
	{

		if (responses.size() == 0)
			return; 
		String xml = EncryptDecrypt.encrypt(responses.get(0).asString());
		
		FileOutputStream fos = new FileOutputStream(rootPath + name.hashCode());
		fos.write(xml.getBytes("utf-8"));

		
		fos.close();
	}

	public static List<WeiboResponse> restoreStatuses(String name, Weibo twitter)
			throws Exception
	{
		String xml = "";
		FileInputStream fis = new FileInputStream(rootPath + name.hashCode());
		InputStreamReader isr = new InputStreamReader(fis, "utf-8");
		BufferedReader br = new BufferedReader(isr);
		String s = "";
		while ((s = br.readLine()) != null)
		{
			xml += s;
		}
		Response response = new Response();
		response.responseAsString = EncryptDecrypt.decrypt(xml);

		List<Status> statuses = Status.constructStatuses(response, twitter);
		List<WeiboResponse> responses = new ArrayList<WeiboResponse>();
		for(Status status: statuses)
		{
			responses.add(status);
		}
		fis.close();
		return responses;
	}

}
