package microblog.thread;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONML;
import weibo4j.org.json.JSONObject;
import microblog.MyMicroBlog;
import microblog.commons.Const;
import microblog.net.DataTransfer;
import microblog.net.interfaces.MessageServiceListener;

public class MessageService implements Runnable
{
	private MessageServiceListener mMessageServiceListener;

	public void setMessageServiceListener(MessageServiceListener listener)
	{
		mMessageServiceListener = listener;
	}

	public static class MessageInitData
	{
		private int id;
		private int versionCode;

		public int getId()
		{
			return id;
		}

		public void setId(int id)
		{
			this.id = id;
		}

		public int getVersionCode()
		{
			return versionCode;
		}

		public void setVersionCode(int versionCode)
		{
			this.versionCode = versionCode;
		}

	}

	public static class MessageRequest
	{
		private int id;
		private int versionCode;

		public int getId()
		{
			return id;
		}

		public void setId(int id)
		{
			this.id = id;
		}

		public int getVersionCode()
		{
			return versionCode;
		}

		public void setVersionCode(int versionCode)
		{
			this.versionCode = versionCode;
		}

	}

	public static class Message implements Serializable
	{
		private int id;
		private String tickerText;
		private String title;
		private String message;
		private String postTime;
		private int versionCode;
		private String versionName;
		private int clientType;
		private String topic;
		private boolean tickerTextShared;
		private boolean titleShared;
		private boolean messageShared;

		public int getId()
		{
			return id;
		}

		public void setId(int id)
		{
			this.id = id;
		}

		public String getTickerText()
		{
			return tickerText;
		}

		public void setTickerText(String tickerText)
		{
			this.tickerText = tickerText;
		}

		public String getTitle()
		{
			return title;
		}

		public void setTitle(String title)
		{
			this.title = title;
		}

		public String getMessage()
		{
			return message;
		}

		public void setMessage(String message)
		{
			this.message = message;
		}

		public String getPostTime()
		{
			return postTime;
		}

		public void setPostTime(String postTime)
		{
			this.postTime = postTime;
		}

		public int getVersionCode()
		{
			return versionCode;
		}

		public void setVersionCode(int versionCode)
		{
			this.versionCode = versionCode;
		}

		public String getVersionName()
		{
			return versionName;
		}

		public void setVersionName(String versionName)
		{
			this.versionName = versionName;
		}

		public int getClientType()
		{
			return clientType;
		}

		public void setClientType(int clientType)
		{
			this.clientType = clientType;
		}

		public String getTopic()
		{
			return topic;
		}

		public void setTopic(String topic)
		{
			this.topic = topic;
		}

		public boolean isTickerTextShared()
		{
			return tickerTextShared;
		}

		public void setTickerTextShared(boolean tickerTextShared)
		{
			this.tickerTextShared = tickerTextShared;
		}

		public boolean isTitleShared()
		{
			return titleShared;
		}

		public void setTitleShared(boolean titleShared)
		{
			this.titleShared = titleShared;
		}

		public boolean isMessageShared()
		{
			return messageShared;
		}

		public void setMessageShared(boolean messageShared)
		{
			this.messageShared = messageShared;
		}

	}

	@Override
	public void run()
	{
		MessageRequest messageRequest = new MessageRequest();
		if (mMessageServiceListener == null)
			return;

		while (true)
		{

			try
			{
				//  ÿ1Ӷһη
				Thread.sleep(1024 * 60 * 1);
				//Thread.sleep(2000);

				MessageInitData messageInitData = mMessageServiceListener
						.onMessageInit();
				if (messageInitData == null)
					return;
				messageRequest.setId(messageInitData.getId());
				messageRequest.setVersionCode(messageInitData.getVersionCode());
				JSONObject jsonObject = new JSONObject(messageRequest);
				String result = DataTransfer.sendData(jsonObject.toString(),
						Const.URL_HAPPYBLOG_MESSAGES);
				JSONArray jsonArray = new JSONArray(result);
				List<Message> messages = new ArrayList<Message>();
			
				for (int i = 0; i < jsonArray.length(); i++)
				{
					jsonObject = new JSONObject(jsonArray.get(i).toString());
					Message message = new Message();
					message.setId(Integer.parseInt(String.valueOf(jsonObject
							.get("id"))));

					message.setTickerText(String.valueOf(jsonObject
							.get("ticker_text")));
					message.setTitle(String.valueOf(jsonObject.get("title")));
					message.setMessage(String
							.valueOf(jsonObject.get("message")));
					message.setPostTime(String.valueOf(jsonObject
							.get("post_time")));
					message.setClientType(Integer.parseInt(String
							.valueOf(jsonObject.get("client_type"))));
					message.setVersionCode(Integer.parseInt(String
							.valueOf((jsonObject.get("version_code")))));
					message.setVersionName(String.valueOf(jsonObject
							.get("version_name")));
					message.setTopic(String.valueOf(jsonObject.get("topic")));
					String tickerTextShared = String.valueOf(jsonObject
							.get("ticker_text_shared"));
					if ("on".equals(tickerTextShared))
						message.setTickerTextShared(true);
					else
						message.setTickerTextShared(false);
					String titleShared = String.valueOf(jsonObject
							.get("title_shared"));
					if ("on".equals(titleShared))
						message.setTitleShared(true);
					else
						message.setTitleShared(false);
					
					String messageShared = String.valueOf(jsonObject
							.get("message_shared"));
					if ("on".equals(messageShared))
						message.setMessageShared(true);
					else
						message.setMessageShared(false);

					messages.add(message);
				}
		
				mMessageServiceListener.onProcessMessages(messages);

			}
			catch (Exception e)
			{
				MyMicroBlog.myLog.write("messages_service_exception", String
						.valueOf(e));
			}
		}

	}
}
