package mobile.android.photo.share;

import java.io.ByteArrayOutputStream;

import microblog.KeySecret;
import microblog.MyMicroBlog;
import weibo4j.Status;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.graphics.BitmapFactory;
import android.graphics.BitmapFactory.Options;
import android.graphics.Matrix;

public class WeiboTools
{
	public static Status uploadImage(String filename) throws Exception
	{
		KeySecret keySecret = new KeySecret();
		keySecret.setConsumerKey("app key");
		keySecret.setConsumerSecret("app secret");
		MyMicroBlog microBlog = new MyMicroBlog("account",
				"password", keySecret);

		Options options = new Options(); 
		options.inSampleSize = 5;
		Bitmap bitmap = BitmapFactory.decodeFile(filename, options);
		Matrix matrix = new Matrix();
		matrix.setRotate(90);
		Bitmap rotateBitmap = Bitmap.createBitmap(bitmap, 0, 0,
				bitmap.getWidth(), bitmap.getHeight(), matrix, false);
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		rotateBitmap.compress(CompressFormat.JPEG, 100, baos);

		byte[] buffer = baos.toByteArray();
		Status status = microBlog.updateStatus("ͼƬ", baos.toByteArray());
		baos.close();
		return status;

	}

}
