package microblog;

import weibo4j.Weibo;

public abstract class AsyncTask implements Runnable
{

	private MicroBlogListener mMicroBlogListener;
	private int mType; // ͣû¼Status
	private int mMsgId;
	private int mLanguage; // ǰ
	private boolean mShowWaitMsg;

	public abstract Object invoke() throws Exception;

	public AsyncTask(MicroBlogListener microBlogListener, int type, int msgId,
			int language)
	{
		this(microBlogListener, type, msgId, language, true);
		 
  
	} 

	public AsyncTask(MicroBlogListener microBlogListener, int type, int msgId,
			int language, boolean showWaitMsg)
	{
		mMicroBlogListener = microBlogListener;
		mMsgId = msgId;
		mType = type;
		mLanguage = language;
		mShowWaitMsg = showWaitMsg;
	}

	@Override
	public void run()
	{

		String[] msgArray = MyUtil.getString(mMsgId, mLanguage);

		try
		{
		
			// mType + 1ʾɹID
			if (mMicroBlogListener != null && mShowWaitMsg) 
				if(mMicroBlogListener.onWait(msgArray[0], mType) == false)
					return;
			
			Object obj = invoke();

			if (mMicroBlogListener != null)
				mMicroBlogListener.onEnd(msgArray[1], obj, mType + 1);
		}
		catch (Exception e) 
		{
			
		
			// mType + 2ʾʧܵID
			if (mMicroBlogListener != null)
				mMicroBlogListener.onException(msgArray[2], mType + 2);
		}
	}

}
