package microblog;

import java.util.List; 

import weibo4j.Count;
import weibo4j.Status;
import weibo4j.WeiboResponse;
import weibo4j.User;

public interface MicroBlogListener
{
	public boolean onWait(String msg, int type);

	public void onEnd(String msg, Object obj, int type);

	public void onException(String msg, int type);

	public void onLoginSuccess(String msg, User user);

	public void onLoginException(String msg);

	public void onTimelineSuccess(String msg, List<WeiboResponse> twitterResponses);

	public void onTimelineException(String msg);


}
